/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.gui.utils;

import java.lang.reflect.InvocationTargetException;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class LookAndFeelManager {
    private static UIManager.LookAndFeelInfo[] availableLookAndFeels = UIManager.getInstalledLookAndFeels();
    private boolean ret;

    public String[] getInstalledLookAndFeels() {
        String[] stringArray = new String[availableLookAndFeels.length];
        for (int i = 0; i < availableLookAndFeels.length; ++i) {
            stringArray[i] = availableLookAndFeels[i].getClassName();
        }
        return stringArray;
    }

    public int numbersOfInstalledLookAndFeels() {
        return availableLookAndFeels.length;
    }

    public String getCurrentLookAndFeel() {
        return UIManager.getLookAndFeel().getClass().getName();
    }

    public boolean isSupportedLookAndFeel(String string) {
        for (int i = 0; i < availableLookAndFeels.length; ++i) {
            if (!availableLookAndFeels[i].getClassName().equals(string)) continue;
            return true;
        }
        return false;
    }

    public boolean setLookAndFeel(final String string) {
        this.ret = false;
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    try {
                        UIManager.setLookAndFeel(string);
                        LookAndFeelManager.this.ret = true;
                    }
                    catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                        System.err.println("Cannot find this look and feel:");
                        System.err.println(unsupportedLookAndFeelException.getLocalizedMessage());
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        System.err.println("LookAndFeel class could not be found:");
                        System.err.println(classNotFoundException.getLocalizedMessage());
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        System.err.println("Illegal access while setting the Look And Feel:");
                        System.err.println(illegalAccessException.getLocalizedMessage());
                    }
                    catch (InstantiationException instantiationException) {
                        System.err.println("Instantiation error while setting the Look And Feel:");
                        System.err.println(instantiationException.getLocalizedMessage());
                    }
                }
            });
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            System.err.println(invocationTargetException);
        }
        return this.ret;
    }

    public boolean setSystemLookAndFeel() {
        return this.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
    }
}

