/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.gui.datatip;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.scilab.modules.commons.gui.FindIconHelper;
import org.scilab.modules.graphic_objects.graphicController.GraphicController;
import org.scilab.modules.gui.datatip.DatatipCreate;
import org.scilab.modules.gui.datatip.DatatipDelete;
import org.scilab.modules.gui.utils.ScilabSwingUtilities;
import org.scilab.modules.localization.Messages;
import org.scilab.modules.renderer.CallRenderer;
import org.scilab.modules.renderer.JoGLView.DrawerVisitor;
import org.scilab.modules.renderer.utils.AxesHandler;
import org.scilab.modules.renderer.utils.EntityPicker;
import org.scilab.modules.renderer.utils.ObjectSearcher;

public class DatatipManagerMode {
    private static DatatipManagerMode instance;
    private Integer selectedTip;
    private Integer markColor;
    private Integer figureUid;
    private boolean datatipManagerModeStatus;
    private Map<Integer, Stack<Integer>> lastDatatips;
    private static String datatipMessage;

    public DatatipManagerMode() {
        instance = this;
        this.selectedTip = null;
        this.figureUid = null;
        this.lastDatatips = new HashMap<Integer, Stack<Integer>>();
        this.datatipManagerModeStatus = false;
    }

    public void setEnabled(boolean bl) {
        this.datatipManagerModeStatus = bl;
        if (!this.datatipManagerModeStatus) {
            GraphicController.getController().setProperty(this.figureUid, 89, (Object)"");
        } else {
            GraphicController.getController().setProperty(this.figureUid, 89, (Object)datatipMessage);
        }
    }

    public static DatatipManagerMode getInstance() {
        return instance;
    }

    public Integer getMarkColor() {
        return this.markColor;
    }

    public void setMarkColor(Integer n) {
        this.markColor = n;
    }

    public boolean isEnabled() {
        return this.datatipManagerModeStatus;
    }

    public void setSelectedTip(Integer n) {
        this.markColor = this.highlightSelected(n, this.selectedTip, this.markColor);
        this.selectedTip = n;
    }

    public Integer getSelectedTip() {
        return this.selectedTip;
    }

    public void setLastTip(Integer n, Integer n2) {
        Stack<Integer> stack = this.lastDatatips.get(n);
        if (stack == null) {
            stack = new Stack();
            this.lastDatatips.put(n, stack);
        }
        stack.push(n2);
    }

    public Integer getLastTip(Integer n) {
        Stack<Integer> stack = this.lastDatatips.get(n);
        if (stack != null && !stack.isEmpty()) {
            return stack.pop();
        }
        return null;
    }

    public boolean hasLast(Integer[] integerArray) {
        Integer[] integerArray2;
        for (Integer n : integerArray2 = AxesHandler.clickedAxes((Integer)this.getFigure(), (Integer[])integerArray)) {
            if (n == null || !this.lastDatatips.containsKey(n) || this.lastDatatips.get(n).isEmpty()) continue;
            return true;
        }
        return false;
    }

    public void enableTranslation(boolean bl) {
        DrawerVisitor.getVisitor((Integer)this.figureUid).getInteractionManager().setTranslationEnable(bl);
    }

    public boolean isInteractiveZoom() {
        return DrawerVisitor.getVisitor((Integer)this.figureUid).getInteractionManager().isInteractiveZoom();
    }

    public void setFigure(Integer n) {
        this.figureUid = n;
    }

    public Integer getFigure() {
        return this.figureUid;
    }

    private Integer highlightSelected(Integer n, Integer n2, Integer n3) {
        Integer n4 = 0;
        if (n2 != null) {
            GraphicController.getController().setProperty(n2, 203, (Object)n3);
        }
        if (n != null) {
            n4 = (Integer)GraphicController.getController().getProperty(n, 203);
            GraphicController.getController().setProperty(n, 203, (Object)-3);
        }
        return n4;
    }

    public boolean pickAndHighlight(Integer n, Integer n2) {
        Integer[] integerArray = new Integer[]{n, n2};
        Integer n3 = new EntityPicker().pickDatatip(this.figureUid, integerArray);
        this.setSelectedTip(n3);
        return n3 != null;
    }

    public boolean pickAndDelete(Integer n, Integer n2) {
        Integer[] integerArray = new Integer[]{n, n2};
        Integer n3 = new EntityPicker().pickDatatip(this.figureUid, integerArray);
        if (n3 != null) {
            DatatipDelete.deleteDatatip(n3);
            if (n3.equals(this.selectedTip)) {
                this.selectedTip = null;
            }
        }
        return n3 != null;
    }

    public void onRightMouseClick(final MouseEvent mouseEvent) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem(Messages.gettext((String)"Delete all the datatips"));
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DatatipManagerMode.this.deleteAll(new Integer[]{mouseEvent.getX(), mouseEvent.getY()});
            }
        });
        JMenuItem jMenuItem2 = new JMenuItem(Messages.gettext((String)"Delete all the datatips on the selected curve"));
        jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DatatipManagerMode.this.deleteAllOnCurve(new Integer[]{mouseEvent.getX(), mouseEvent.getY()});
            }
        });
        jMenuItem2.setEnabled(this.onCurve(new Integer[]{mouseEvent.getX(), mouseEvent.getY()}));
        JMenuItem jMenuItem3 = new JMenuItem(Messages.gettext((String)"Delete the nearest datatip"));
        jMenuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DatatipManagerMode.this.deleteNearest(new Integer[]{mouseEvent.getX(), mouseEvent.getY()});
            }
        });
        JMenuItem jMenuItem4 = new JMenuItem(Messages.gettext((String)"Edit curve datatip display function"));
        jMenuItem4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DatatipManagerMode.this.editDisplayFunction(mouseEvent.getComponent(), new Integer[]{mouseEvent.getX(), mouseEvent.getY()});
            }
        });
        jMenuItem4.setEnabled(this.onCurve(new Integer[]{mouseEvent.getX(), mouseEvent.getY()}));
        JMenuItem jMenuItem5 = new JMenuItem(Messages.gettext((String)"Enable interpolation"));
        jMenuItem5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DatatipManagerMode.this.enableInterpolation(new Integer[]{mouseEvent.getX(), mouseEvent.getY()}, true);
            }
        });
        jMenuItem5.setEnabled(this.onCurve(new Integer[]{mouseEvent.getX(), mouseEvent.getY()}));
        JMenuItem jMenuItem6 = new JMenuItem(Messages.gettext((String)"Disable interpolation"));
        jMenuItem6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DatatipManagerMode.this.enableInterpolation(new Integer[]{mouseEvent.getX(), mouseEvent.getY()}, false);
            }
        });
        jMenuItem6.setEnabled(this.onCurve(new Integer[]{mouseEvent.getX(), mouseEvent.getY()}));
        jPopupMenu.add(jMenuItem);
        jPopupMenu.add(jMenuItem2);
        jPopupMenu.add(jMenuItem3);
        jPopupMenu.addSeparator();
        jPopupMenu.add(jMenuItem4);
        jPopupMenu.addSeparator();
        jPopupMenu.add(jMenuItem5);
        jPopupMenu.add(jMenuItem6);
        jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
    }

    private void enableInterpolation(Integer[] integerArray, boolean bl) {
        Integer[] integerArray2;
        for (Integer n : integerArray2 = AxesHandler.clickedAxes((Integer)this.getFigure(), (Integer[])integerArray)) {
            Integer n2 = new EntityPicker().pick(this.getFigure(), integerArray[0], integerArray[1]);
            if (n2 == null) continue;
            DatatipCreate.datatipSetInterp(n2, bl);
            return;
        }
    }

    private void editDisplayFunction(Component component, Integer[] integerArray) {
        Integer[] integerArray2;
        for (Integer n : integerArray2 = AxesHandler.clickedAxes((Integer)this.getFigure(), (Integer[])integerArray)) {
            final Integer n2 = new EntityPicker().pick(this.getFigure(), integerArray[0], integerArray[1]);
            if (n2 == null) continue;
            String string = (String)GraphicController.getController().getProperty(n2, 344);
            JFrame jFrame = (JFrame)SwingUtilities.getAncestorOfClass(JFrame.class, component);
            final JDialog jDialog = new JDialog(jFrame);
            jDialog.setIconImage(new ImageIcon(FindIconHelper.findIcon((String)"datatips")).getImage());
            jDialog.setTitle(Messages.gettext((String)"Display function name"));
            jDialog.setDefaultCloseOperation(2);
            ScilabSwingUtilities.closeOnEscape(jDialog);
            boolean bl = System.getProperty("os.name").toLowerCase().contains("windows");
            JPanel jPanel = new JPanel();
            final JTextField jTextField = new JTextField(30);
            jTextField.setText(string);
            JButton jButton = new JButton(Messages.gettext((String)"OK"));
            ActionListener actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    String string = jTextField.getText();
                    if (string != null && !string.isEmpty()) {
                        GraphicController.getController().setProperty(n2, 344, (Object)string);
                    }
                    jDialog.dispose();
                }
            };
            jButton.addActionListener(actionListener);
            jTextField.addActionListener(actionListener);
            JButton jButton2 = new JButton(Messages.gettext((String)"Cancel"));
            jButton2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    jDialog.dispose();
                }
            });
            jPanel.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridwidth = 3;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(10, 5, 5, 5);
            jPanel.add((Component)jTextField, gridBagConstraints);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.fill = 2;
            jPanel.add((Component)new JPanel(), gridBagConstraints);
            gridBagConstraints.gridx = bl ? 1 : 2;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.anchor = 21;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = new Insets(0, 0, 5, 5);
            jPanel.add((Component)jButton, gridBagConstraints);
            gridBagConstraints.gridx = bl ? 2 : 1;
            jPanel.add((Component)jButton2, gridBagConstraints);
            jDialog.setContentPane(jPanel);
            jDialog.pack();
            Point point = jFrame.getLocationOnScreen();
            Dimension dimension = jFrame.getSize();
            Dimension dimension2 = jDialog.getSize();
            jDialog.setLocation(point.x + (dimension.width - dimension2.width) / 2, point.y + (dimension.height - dimension2.height) / 2);
            jDialog.setVisible(true);
            jTextField.requestFocus();
            return;
        }
    }

    private void deleteNearest(Integer[] integerArray) {
        Integer[] integerArray2;
        for (Integer n : integerArray2 = AxesHandler.clickedAxes((Integer)this.getFigure(), (Integer[])integerArray)) {
            Integer[] integerArray3 = new ObjectSearcher().search(n, 338, true);
            if (integerArray3 == null) continue;
            int n2 = integerArray[0];
            int n3 = integerArray[1];
            double d = Double.POSITIVE_INFINITY;
            int n4 = -1;
            Integer[] integerArray4 = integerArray3;
            int n5 = integerArray4.length;
            for (int i = 0; i < n5; ++i) {
                int n6 = integerArray4[i];
                Double[] doubleArray = (Double[])GraphicController.getController().getProperty(Integer.valueOf(n6), 339);
                double[] dArray = new double[]{doubleArray[0], doubleArray[1], doubleArray[2]};
                double[] dArray2 = CallRenderer.getPixelFrom3dCoordinates((int)n, (double[])dArray);
                double d2 = Math.hypot((double)n2 - dArray2[0], (double)n3 - dArray2[1]);
                if (!(d2 < d)) continue;
                d = d2;
                n4 = n6;
            }
            if (n4 != -1) {
                DatatipDelete.deleteDatatip(n4);
            }
            return;
        }
    }

    private void deleteAllOnCurve(Integer[] integerArray) {
        Integer[] integerArray2;
        for (Integer n : integerArray2 = AxesHandler.clickedAxes((Integer)this.getFigure(), (Integer[])integerArray)) {
            Integer n2 = new EntityPicker().pick(this.getFigure(), integerArray[0], integerArray[1]);
            if (n2 == null) continue;
            Integer[] integerArray3 = (Integer[])GraphicController.getController().getProperty(n2, 357);
            if (integerArray3 != null) {
                Integer[] integerArray4 = integerArray3;
                int n3 = integerArray4.length;
                for (int i = 0; i < n3; ++i) {
                    int n4 = integerArray4[i];
                    DatatipDelete.deleteDatatip(n4);
                }
            }
            return;
        }
    }

    private void deleteAll(Integer[] integerArray) {
        Integer[] integerArray2;
        for (Integer n : integerArray2 = AxesHandler.clickedAxes((Integer)this.getFigure(), (Integer[])integerArray)) {
            Integer[] integerArray3 = new ObjectSearcher().search(n, 338, true);
            if (integerArray3 == null) continue;
            Integer[] integerArray4 = integerArray3;
            int n2 = integerArray4.length;
            for (int i = 0; i < n2; ++i) {
                int n3 = integerArray4[i];
                DatatipDelete.deleteDatatip(n3);
            }
            return;
        }
    }

    private boolean onCurve(Integer[] integerArray) {
        Integer[] integerArray2;
        for (Integer n : integerArray2 = AxesHandler.clickedAxes((Integer)this.getFigure(), (Integer[])integerArray)) {
            Integer n2 = new EntityPicker().pick(this.getFigure(), integerArray[0], integerArray[1]);
            if (n2 == null) continue;
            return true;
        }
        return false;
    }

    static {
        datatipMessage = Messages.gettext((String)"Left click on the curve creates a datatip and right click on the datatip removes it.");
    }
}

