/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.gui.bridge.editbox;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.InputMap;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.text.BoxView;
import javax.swing.text.ComponentView;
import javax.swing.text.Element;
import javax.swing.text.IconView;
import javax.swing.text.LabelView;
import javax.swing.text.ParagraphView;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import org.scilab.modules.graphic_objects.console.Console;
import org.scilab.modules.graphic_objects.graphicController.GraphicController;
import org.scilab.modules.gui.SwingView;
import org.scilab.modules.gui.SwingViewObject;
import org.scilab.modules.gui.SwingViewWidget;
import org.scilab.modules.gui.events.callback.CommonCallBack;
import org.scilab.modules.gui.menubar.MenuBar;
import org.scilab.modules.gui.textbox.TextBox;
import org.scilab.modules.gui.toolbar.ToolBar;
import org.scilab.modules.gui.utils.Position;
import org.scilab.modules.gui.utils.PositionConverter;
import org.scilab.modules.gui.utils.ScilabRelief;
import org.scilab.modules.gui.utils.ScilabSwingUtilities;
import org.scilab.modules.gui.utils.Size;
import org.scilab.modules.gui.widget.Widget;

public class SwingScilabEditBox
extends JScrollPane
implements SwingViewObject,
Widget {
    private static final long serialVersionUID = 2048261239598753717L;
    private Integer uid;
    private CommonCallBack callback;
    private FocusListener focusListener;
    private Border defaultBorder = null;
    private StyledDocument doc;
    private SimpleAttributeSet docAttributes = new SimpleAttributeSet();
    private JTextPane textPane = new JTextPane();
    private JPanel noWrapPanel = (JPanel)this.getViewport().getView();
    private boolean scrollable = false;
    private boolean isMultiLine = false;
    private Object enterKeyAction;
    private Object tabKeyAction;
    private Object shiftTabKeyAction;

    public SwingScilabEditBox() {
        super(new JPanel(new BorderLayout()));
        this.textPane = new JTextPane();
        this.noWrapPanel.add((Component)this.textPane, "Center");
        this.setVerticalScrollBarPolicy(21);
        this.setHorizontalScrollBarPolicy(31);
        this.textPane.setEditorKit(new EditBoxEditorKit());
        this.doc = (StyledDocument)this.textPane.getDocument();
        this.focusListener = new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                SwingScilabEditBox.this.validateUserInput();
            }
        };
        this.textPane.addFocusListener(this.focusListener);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(10, 0);
        KeyStroke keyStroke2 = KeyStroke.getKeyStroke(9, 0);
        KeyStroke keyStroke3 = KeyStroke.getKeyStroke(9, 64);
        InputMap inputMap = this.textPane.getInputMap();
        this.enterKeyAction = inputMap.get(keyStroke);
        this.tabKeyAction = inputMap.get(keyStroke2);
        this.shiftTabKeyAction = inputMap.get(keyStroke3);
        if (!Console.getConsole().getUseDeprecatedLF()) {
            this.setEditFont(this.getFont());
        }
        this.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                int n = SwingScilabEditBox.this.getVerticalScrollBar().getValue();
                if (n == SwingScilabEditBox.this.getVerticalScrollBar().getMinimum() || n == SwingScilabEditBox.this.getVerticalScrollBar().getMaximum() - SwingScilabEditBox.this.getVerticalScrollBar().getVisibleAmount()) {
                    SwingScilabEditBox.this.getParent().dispatchEvent(mouseWheelEvent);
                }
            }
        });
    }

    private void validateUserInput() {
        if (this.getParent() != null) {
            String[] stringArray = this.getText().split("\n");
            GraphicController.getController().setProperty(this.uid, 308, (Object)stringArray);
            if (SwingView.getFromId(this.uid) != null && this.callback != null) {
                this.callback.actionPerformed(null);
            }
        }
    }

    @Override
    public void draw() {
        this.setVisible(true);
        this.doLayout();
    }

    @Override
    public Size getDims() {
        return new Size(this.getSize().width, this.getSize().height);
    }

    @Override
    public Position getPosition() {
        return PositionConverter.javaToScilab(this.getLocation(), this.getSize(), this.getParent());
    }

    @Override
    public void setDims(Size size) {
        this.setSize(size.getWidth(), size.getHeight());
    }

    @Override
    public void setPosition(Position position) {
        Position position2 = PositionConverter.scilabToJava(position, this.getDims(), this.getParent());
        this.setLocation(position2.getX(), position2.getY());
    }

    @Override
    public void setCallback(CommonCallBack commonCallBack) {
        this.callback = commonCallBack;
    }

    public void setText(String[] stringArray) {
        if (stringArray.length == 0) {
            try {
                this.textPane.setText(null);
                this.doc.setParagraphAttributes(0, this.doc.getLength() - 1, this.docAttributes, true);
            }
            catch (Exception exception) {}
        } else {
            StringBuffer stringBuffer = new StringBuffer(stringArray[0]);
            for (int i = 1; i < stringArray.length; ++i) {
                stringBuffer.append("\n" + stringArray[i]);
            }
            try {
                this.textPane.setText(stringBuffer.toString());
                this.doc.setParagraphAttributes(0, this.doc.getLength() - 1, this.docAttributes, true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void setText(String string) {
        try {
            this.textPane.setText(string);
            this.doc.setParagraphAttributes(0, this.doc.getLength() - 1, this.docAttributes, true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void setEmptyText() {
        this.textPane.setText(null);
        this.doc.setParagraphAttributes(0, this.doc.getLength() - 1, this.docAttributes, true);
    }

    @Override
    public void setEnabled(boolean bl) {
        if (bl == this.isEnabled()) {
            return;
        }
        super.setEnabled(bl);
        this.textPane.setEnabled(bl);
        if (bl) {
            SwingViewWidget.update(this, 294, GraphicController.getController().getProperty(this.uid, 294));
        } else {
            Color color = new Color(0.9f, 0.9f, 0.9f);
            this.setBackground(color);
        }
        if (this.callback != null) {
            if (bl) {
                this.removeFocusListener(this.focusListener);
                this.addFocusListener(this.focusListener);
            } else {
                this.removeFocusListener(this.focusListener);
            }
        }
    }

    @Override
    public void addMenuBar(MenuBar menuBar) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addToolBar(ToolBar toolBar) {
        throw new UnsupportedOperationException();
    }

    @Override
    public MenuBar getMenuBar() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ToolBar getToolBar() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setHorizontalAlignment(String string) {
        if (!string.equals("")) {
            int n = 0;
            if (string.equals("right")) {
                n = 2;
            } else if (string.equals("center")) {
                n = 1;
            }
            StyleConstants.setAlignment(this.docAttributes, n);
            this.doc.setParagraphAttributes(0, this.doc.getLength(), this.docAttributes, true);
        }
    }

    @Override
    public void setVerticalAlignment(String string) {
        if (!string.equals("")) {
            if (string.equals("bottom")) {
                this.textPane.setAlignmentY(1.0f);
            } else if (string.equals("top")) {
                this.textPane.setAlignmentY(0.0f);
            } else if (string.equals("middle")) {
                this.textPane.setAlignmentY(0.5f);
            }
            this.setText(this.getText());
        }
    }

    @Override
    public void setRelief(String string) {
        if (this.defaultBorder == null) {
            this.defaultBorder = this.textPane.getBorder();
        }
        this.textPane.setBorder(ScilabRelief.getBorderFromRelief(string, this.defaultBorder));
    }

    @Override
    public void setToolTipText(String string) {
        this.textPane.setToolTipText(string);
    }

    @Override
    public void destroy() {
        ScilabSwingUtilities.removeFromParent(this);
    }

    @Override
    public void addInfoBar(TextBox textBox) {
        throw new UnsupportedOperationException();
    }

    @Override
    public TextBox getInfoBar() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setId(Integer n) {
        this.uid = n;
    }

    @Override
    public Integer getId() {
        return this.uid;
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.docAttributes != null && this.textPane != null) {
            this.textPane.setBackground(color);
            StyleConstants.setBackground(this.docAttributes, color);
        }
    }

    public void setEditFont(Font font) {
        super.setFont(font);
        if (this.textPane != null) {
            this.textPane.setFont(font);
            StyleConstants.setFontFamily(this.docAttributes, font.getFamily());
            StyleConstants.setFontSize(this.docAttributes, font.getSize());
            StyleConstants.setBold(this.docAttributes, font.isBold());
            StyleConstants.setItalic(this.docAttributes, font.isItalic());
            this.doc.setParagraphAttributes(0, this.doc.getLength() - 1, this.docAttributes, true);
        }
    }

    @Override
    public void setFont(Font font) {
        this.setEditFont(font);
    }

    @Override
    public void update(int n, Object object) {
        GraphicController graphicController = GraphicController.getController();
        switch (n) {
            case 305: {
                double d = (Double)graphicController.getProperty(this.uid, 306);
                double d2 = (Double)graphicController.getProperty(this.uid, 305);
                if (d2 - d > 1.0) {
                    this.setMultiLineText(true);
                } else {
                    this.setMultiLineText(false);
                }
                this.setScrollable(this.scrollable);
                this.update(308, GraphicController.getController().getProperty(this.uid, 308));
                break;
            }
            case 306: {
                Double d = (Double)object;
                Double d3 = (Double)graphicController.getProperty(this.uid, 305);
                if (d3 - d > 1.0) {
                    this.setMultiLineText(true);
                } else {
                    this.setMultiLineText(false);
                }
                this.setScrollable(this.scrollable);
                this.update(308, GraphicController.getController().getProperty(this.uid, 308));
                break;
            }
            case 308: {
                String[] stringArray = (String[])object;
                double d = (Double)graphicController.getProperty(this.uid, 306);
                double d4 = (Double)graphicController.getProperty(this.uid, 305);
                if (stringArray.length > 1 && d4 - d <= 1.0) {
                    graphicController.setProperty(this.uid, 305, (Object)(d + 2.0));
                    return;
                }
                ArrayList<String> arrayList = new ArrayList<String>();
                for (int i = 0; i < stringArray.length; ++i) {
                    String string = stringArray[i];
                    int n2 = 0;
                    int n3 = 0;
                    while ((n2 = string.indexOf(10, n3)) != -1) {
                        arrayList.add(string.substring(n3, n2));
                        n3 = n2 + 1;
                    }
                    if (n3 > string.length()) continue;
                    arrayList.add(string.substring(n3));
                }
                if (arrayList.size() != stringArray.length) {
                    String[] stringArray2 = new String[arrayList.size()];
                    arrayList.toArray(stringArray2);
                    graphicController.setProperty(this.uid, 308, (Object)stringArray2);
                    return;
                }
                if (d4 - d > 1.0) {
                    this.setText(stringArray);
                    this.setMultiLineText(true);
                    break;
                }
                if (stringArray.length == 0) {
                    this.setEmptyText();
                } else {
                    this.setText(stringArray[0]);
                }
                this.setMultiLineText(false);
                break;
            }
            case 403: {
                this.setScrollable((Boolean)object);
                break;
            }
            default: {
                SwingViewWidget.update(this, n, object);
            }
        }
        this.setMinimumSize(this.textPane.getMinimumSize());
    }

    public void setScrollable(Boolean bl) {
        this.scrollable = bl;
        if (bl.booleanValue()) {
            if (this.isMultiLine) {
                this.setWordWrap(false);
            } else {
                this.setWordWrap(false);
            }
            this.setHorizontalScrollBarPolicy(30);
        } else {
            if (this.isMultiLine) {
                this.setWordWrap(true);
            } else {
                this.setWordWrap(false);
            }
            this.setHorizontalScrollBarPolicy(31);
        }
    }

    private void setWordWrap(boolean bl) {
        if (bl) {
            this.setViewportView(this.textPane);
        } else {
            this.setViewportView(this.noWrapPanel);
            this.noWrapPanel.add(this.textPane);
        }
    }

    @Override
    public String getText() {
        return this.textPane.getText();
    }

    public void setMultiLineText(boolean bl) {
        this.isMultiLine = bl;
        KeyStroke keyStroke = KeyStroke.getKeyStroke(10, 0);
        KeyStroke keyStroke2 = KeyStroke.getKeyStroke(9, 0);
        KeyStroke keyStroke3 = KeyStroke.getKeyStroke(9, 64);
        if (bl) {
            this.setVerticalScrollBarPolicy(20);
            this.textPane.getInputMap().remove(keyStroke);
            this.textPane.getInputMap().remove(keyStroke2);
            this.textPane.getInputMap().remove(keyStroke3);
            this.textPane.getInputMap().put(keyStroke, this.enterKeyAction);
            this.textPane.getInputMap().put(keyStroke2, this.tabKeyAction);
            this.textPane.getInputMap().put(keyStroke2, this.shiftTabKeyAction);
        } else {
            this.setVerticalScrollBarPolicy(21);
            AbstractAction abstractAction = new AbstractAction(){
                private static final long serialVersionUID = -5286137769378297783L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                    keyboardFocusManager.focusNextComponent();
                }
            };
            AbstractAction abstractAction2 = new AbstractAction(){
                private static final long serialVersionUID = -5286137769378297783L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SwingScilabEditBox.this.validateUserInput();
                }
            };
            AbstractAction abstractAction3 = new AbstractAction(){
                private static final long serialVersionUID = -5286137769378297783L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                    keyboardFocusManager.focusPreviousComponent();
                }
            };
            this.textPane.getInputMap().remove(keyStroke);
            this.textPane.getInputMap().remove(keyStroke2);
            this.textPane.getInputMap().remove(keyStroke3);
            this.textPane.getInputMap().put(keyStroke, abstractAction2);
            this.textPane.getInputMap().put(keyStroke2, abstractAction);
            this.textPane.getInputMap().put(keyStroke3, abstractAction3);
        }
    }

    @Override
    public void resetBackground() {
        Color color = (Color)UIManager.getLookAndFeelDefaults().get("TextField.background");
        if (color != null) {
            this.setBackground(color);
        }
    }

    @Override
    public void resetForeground() {
        Color color = (Color)UIManager.getLookAndFeelDefaults().get("TextField.foreground");
        if (color != null) {
            this.setForeground(color);
        }
    }

    @Override
    public void requestFocus() {
        super.requestFocus();
        this.textPane.requestFocus();
    }

    private class EditBoxEditorKit
    extends StyledEditorKit {
        private static final long serialVersionUID = -3293325523458217074L;

        private EditBoxEditorKit() {
        }

        @Override
        public ViewFactory getViewFactory() {
            return new ViewFactory(){

                @Override
                public View create(Element element) {
                    String string = element.getName();
                    if (string != null) {
                        if (string.equals("content")) {
                            return new LabelView(element);
                        }
                        if (string.equals("paragraph")) {
                            return new ParagraphView(element);
                        }
                        if (string.equals("section")) {
                            return new EditBoxView(element, 1);
                        }
                        if (string.equals("component")) {
                            return new ComponentView(element);
                        }
                        if (string.equals("icon")) {
                            return new IconView(element);
                        }
                    }
                    return new LabelView(element);
                }
            };
        }
    }

    private class EditBoxView
    extends BoxView {
        public EditBoxView(Element element, int n) {
            super(element, n);
        }

        @Override
        protected void layoutMajorAxis(int n, int n2, int[] nArray, int[] nArray2) {
            block5: {
                int n3;
                int n4;
                int n5;
                block4: {
                    int n6;
                    super.layoutMajorAxis(n, n2, nArray, nArray2);
                    n5 = 0;
                    n4 = 0;
                    if (SwingScilabEditBox.this.textPane.getAlignmentY() != 1.0f) break block4;
                    for (n6 = 0; n6 < nArray2.length; ++n6) {
                        n5 += nArray2[n6];
                    }
                    n4 = n - n5;
                    n6 = 0;
                    while (n6 < nArray.length) {
                        int n7 = n6++;
                        nArray[n7] = nArray[n7] + n4;
                    }
                    break block5;
                }
                if (SwingScilabEditBox.this.textPane.getAlignmentY() != 0.5f) break block5;
                for (n3 = 0; n3 < nArray2.length; ++n3) {
                    n5 += nArray2[n3];
                }
                n4 = (n - n5) / 2;
                n3 = 0;
                while (n3 < nArray.length) {
                    int n8 = n3++;
                    nArray[n8] = nArray[n8] + n4;
                }
            }
        }
    }
}

