/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.renderer.JoGLView.interaction;

import java.awt.Dimension;
import java.awt.Point;
import java.util.ArrayList;
import org.scilab.modules.graphic_objects.axes.Axes;
import org.scilab.modules.graphic_objects.graphicController.GraphicController;
import org.scilab.modules.graphic_objects.graphicObject.GraphicObject;
import org.scilab.modules.renderer.JoGLView.DrawerVisitor;

public abstract class FigureInteraction {
    protected DrawerVisitor drawerVisitor;
    private boolean isEnable;

    public FigureInteraction(DrawerVisitor drawerVisitor) {
        this.drawerVisitor = drawerVisitor;
        this.isEnable = false;
    }

    protected DrawerVisitor getDrawerVisitor() {
        return this.drawerVisitor;
    }

    protected Axes getUnderlyingAxes(Point point) {
        Axes axes = null;
        Dimension dimension = this.drawerVisitor.getCanvas().getDimension();
        double d = point.getX() / dimension.getWidth();
        double d2 = point.getY() / dimension.getHeight();
        for (Integer n : this.drawerVisitor.getFigure().getChildren()) {
            Double[] doubleArray;
            GraphicObject graphicObject = GraphicController.getController().getObjectFromId(n);
            if (!(graphicObject instanceof Axes) || !graphicObject.getVisible().booleanValue() || !(d >= (doubleArray = ((Axes)graphicObject).getAxesBounds())[0]) || !(d <= doubleArray[0] + doubleArray[2]) || !(d2 >= doubleArray[1]) || !(d2 <= doubleArray[1] + doubleArray[3])) continue;
            axes = (Axes)graphicObject;
            return axes;
        }
        return axes;
    }

    protected Axes[] getAllUnderlyingAxes(Point point) {
        Integer[] integerArray;
        ArrayList<Axes> arrayList = new ArrayList<Axes>();
        Dimension dimension = this.drawerVisitor.getCanvas().getDimension();
        double d = point.getX() / dimension.getWidth();
        double d2 = point.getY() / dimension.getHeight();
        for (Integer n : this.drawerVisitor.getFigure().getChildren()) {
            Double[] doubleArray;
            GraphicObject graphicObject = GraphicController.getController().getObjectFromId(n);
            if (!(graphicObject instanceof Axes) || !graphicObject.getVisible().booleanValue() || !(d >= (doubleArray = ((Axes)graphicObject).getAxesBounds())[0]) || !(d <= doubleArray[0] + doubleArray[2]) || !(d2 >= doubleArray[1]) || !(d2 <= doubleArray[1] + doubleArray[3])) continue;
            arrayList.add((Axes)graphicObject);
        }
        if (arrayList.size() > 0) {
            integerArray = new Axes[arrayList.size()];
            integerArray = (Axes[])arrayList.toArray(integerArray);
        } else {
            integerArray = new Axes[]{};
        }
        return integerArray;
    }

    protected Axes[] getAllVisibleAxes(Point point) {
        Integer[] integerArray;
        ArrayList<Axes> arrayList = new ArrayList<Axes>();
        Dimension dimension = this.drawerVisitor.getCanvas().getDimension();
        double d = point.getX() / dimension.getWidth();
        double d2 = point.getY() / dimension.getHeight();
        for (Integer n : this.drawerVisitor.getFigure().getChildren()) {
            GraphicObject graphicObject = GraphicController.getController().getObjectFromId(n);
            if (!(graphicObject instanceof Axes) || !graphicObject.getVisible().booleanValue()) continue;
            arrayList.add((Axes)graphicObject);
        }
        if (arrayList.size() > 0) {
            integerArray = new Axes[arrayList.size()];
            integerArray = (Axes[])arrayList.toArray(integerArray);
        } else {
            integerArray = new Axes[]{};
        }
        return integerArray;
    }

    public boolean isEnable() {
        return this.isEnable;
    }

    public void setEnable(boolean bl) {
        if (this.isEnable != bl) {
            this.isEnable = bl;
            this.changeEnable(bl);
        }
    }

    protected abstract void changeEnable(boolean var1);

    protected boolean tightZoomBounds(Axes axes, Double[] doubleArray) {
        boolean bl = false;
        Double[] doubleArray2 = new Double[]{-1.0, 1.0, -1.0, 1.0, -1.0, 1.0};
        for (int n : new int[]{0, 2, 4}) {
            if (doubleArray[n] < doubleArray2[n]) {
                doubleArray[n] = doubleArray2[n];
                continue;
            }
            bl = true;
        }
        for (int n : new int[]{1, 3, 5}) {
            if (doubleArray[n] > doubleArray2[n]) {
                doubleArray[n] = doubleArray2[n];
                continue;
            }
            bl = true;
        }
        return bl;
    }

    protected Point bound(Point point) {
        Dimension dimension = this.getDrawerVisitor().getCanvas().getDimension();
        return new Point(Math.max(1, Math.min(point.x, dimension.width)), Math.max(1, Math.min(point.y, dimension.height)));
    }
}

