/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.renderer.JoGLView.datatip;

import java.awt.Dimension;
import java.nio.FloatBuffer;
import org.scilab.forge.scirenderer.Canvas;
import org.scilab.forge.scirenderer.DrawingTools;
import org.scilab.forge.scirenderer.SciRendererException;
import org.scilab.forge.scirenderer.buffers.DataBuffer;
import org.scilab.forge.scirenderer.buffers.ElementsBuffer;
import org.scilab.forge.scirenderer.shapes.appearance.Appearance;
import org.scilab.forge.scirenderer.shapes.geometry.DefaultGeometry;
import org.scilab.forge.scirenderer.shapes.geometry.Geometry;
import org.scilab.forge.scirenderer.texture.AnchorPosition;
import org.scilab.forge.scirenderer.texture.Texture;
import org.scilab.forge.scirenderer.tranformations.DegenerateMatrixException;
import org.scilab.forge.scirenderer.tranformations.Transformation;
import org.scilab.forge.scirenderer.tranformations.Vector3d;
import org.scilab.modules.graphic_objects.PolylineData;
import org.scilab.modules.graphic_objects.axes.Axes;
import org.scilab.modules.graphic_objects.datatip.Datatip;
import org.scilab.modules.graphic_objects.figure.ColorMap;
import org.scilab.modules.graphic_objects.graphicController.GraphicController;
import org.scilab.modules.graphic_objects.textObject.Text;
import org.scilab.modules.renderer.CallRenderer;
import org.scilab.modules.renderer.JoGLView.DrawerVisitor;
import org.scilab.modules.renderer.JoGLView.text.TextManager;
import org.scilab.modules.renderer.JoGLView.util.ColorFactory;
import org.scilab.modules.renderer.JoGLView.util.ScaleUtils;

public class DatatipTextDrawer
extends TextManager {
    ElementsBuffer lineBuffer;
    Canvas canvas;

    public DatatipTextDrawer(Canvas canvas) {
        super(canvas.getTextureManager());
        this.canvas = canvas;
        this.lineBuffer = canvas.getBuffersManager().createElementsBuffer();
    }

    @Override
    public void disposeAll() {
        super.disposeAll();
        this.canvas.getBuffersManager().dispose((DataBuffer)this.lineBuffer);
    }

    public final void draw(DrawingTools drawingTools, ColorMap colorMap, Datatip datatip) throws SciRendererException {
        Vector3d vector3d;
        Vector3d vector3d2;
        Vector3d vector3d3;
        Texture texture = this.getTexture(colorMap, (Text)datatip);
        Dimension dimension = this.getSpriteDims(colorMap, (Text)datatip);
        Transformation transformation = drawingTools.getTransformationManager().getCanvasProjection();
        Integer n = datatip.getParentAxes();
        Axes axes = (Axes)GraphicController.getController().getObjectFromId(n);
        Vector3d[] vector3dArray = this.computeTextBoxVectors(transformation, (Text)datatip, texture.getDataProvider().getTextureSize(), axes);
        double[] dArray = this.computeRatios(transformation, (Text)datatip, vector3dArray, texture.getDataProvider().getTextureSize(), dimension);
        if (datatip.getTextBoxMode() == 2 && dArray[0] != 1.0) {
            texture = this.updateSprite(colorMap, (Text)datatip, dArray[0], dArray[1]);
        }
        Vector3d[] vector3dArray2 = this.computeTextPosition(transformation, (Text)datatip, vector3dArray, texture.getDataProvider().getTextureSize());
        drawingTools.getTransformationManager().useWindowCoordinate();
        Integer n2 = datatip.getMarkSize();
        Integer n3 = datatip.getMarkSizeUnit();
        double d = n3 == 1 ? 8.0 + 2.0 * (double)n2.intValue() : (double)n2.intValue();
        double d2 = datatip.getMarkStyle() == 11 ? 1.0 : 2.0;
        d -= (d /= 2.0) >= 2.0 ? d2 : 0.0;
        if (!datatip.getDetachedMode().booleanValue()) {
            vector3d3 = new Vector3d(d, d, 0.0);
            if (datatip.isAutoOrientationEnabled().booleanValue()) {
                int n4 = DatatipTextDrawer.getAutoOrientation(datatip);
                if (n4 != -1) {
                    vector3d2 = vector3dArray2[0];
                    vector3d = vector3d3;
                    if (n4 == 2 || n4 == 3) {
                        vector3d2 = vector3d2.minus(vector3dArray[1]);
                        vector3d = vector3d.setY(-d);
                    }
                    if (n4 == 0 || n4 == 2) {
                        vector3d2 = vector3d2.minus(vector3dArray[0]);
                        vector3d = vector3d.setX(-d);
                    }
                    Vector3d vector3d4 = transformation.unproject(vector3d2.plus(vector3dArray[0]).plus(vector3dArray[1]));
                    Vector3d vector3d5 = transformation.unproject(vector3d2);
                    if (vector3d4.getX() < -1.0 || vector3d4.getX() > 1.0 || vector3d4.getY() < -1.0 || vector3d4.getY() > 1.0 || vector3d5.getX() < -1.0 || vector3d5.getX() > 1.0 || vector3d5.getY() < -1.0 || vector3d5.getY() > 1.0) {
                        n4 = -1;
                    } else {
                        vector3dArray2[0] = vector3d2;
                        vector3d3 = vector3d;
                    }
                }
                if (n4 == -1) {
                    vector3d2 = transformation.unproject(vector3dArray2[0].minus(vector3dArray[0]).plus(vector3dArray[1]));
                    if (vector3d2.getX() >= -1.0 && vector3d2.getX() <= 1.0 && vector3d2.getY() >= -1.0 && vector3d2.getY() <= 1.0) {
                        vector3dArray2[0] = vector3dArray2[0].minus(vector3dArray[0]);
                        vector3d3 = vector3d3.setX(-d);
                    } else {
                        vector3d2 = transformation.unproject(vector3dArray2[0].plus(vector3dArray[0]).minus(vector3dArray[1]));
                        if (vector3d2.getX() >= -1.0 && vector3d2.getX() <= 1.0 && vector3d2.getY() >= -1.0 && vector3d2.getY() <= 1.0) {
                            vector3dArray2[0] = vector3dArray2[0].minus(vector3dArray[1]);
                            vector3d3 = vector3d3.setY(-d);
                        } else {
                            vector3d2 = transformation.unproject(vector3dArray2[0].minus(vector3dArray[0]).minus(vector3dArray[1]));
                            if (vector3d2.getX() >= -1.0 && vector3d2.getX() <= 1.0 && vector3d2.getY() >= -1.0 && vector3d2.getY() <= 1.0) {
                                vector3dArray2[0] = vector3dArray2[0].minus(vector3dArray[1]);
                                vector3dArray2[0] = vector3dArray2[0].minus(vector3dArray[0]);
                                vector3d3 = vector3d3.setX(-d);
                                vector3d3 = vector3d3.setY(-d);
                            }
                        }
                    }
                }
            } else {
                if (datatip.getOrientation() == 2 || datatip.getOrientation() == 3) {
                    vector3dArray2[0] = vector3dArray2[0].minus(vector3dArray[1]);
                    vector3d3 = vector3d3.setY(-d);
                }
                if (datatip.getOrientation() == 0 || datatip.getOrientation() == 2) {
                    vector3dArray2[0] = vector3dArray2[0].minus(vector3dArray[0]);
                    vector3d3 = vector3d3.setX(-d);
                }
                if (datatip.getOrientation() == 4) {
                    vector3dArray2[0] = vector3dArray2[0].minus(vector3dArray[0]);
                    vector3dArray2[0] = vector3dArray2[0].minus(vector3dArray[1].times(0.5));
                    vector3d3 = vector3d3.setY(0.0);
                    vector3d3 = vector3d3.setX(Math.sqrt(2.0) * -d);
                }
                if (datatip.getOrientation() == 5) {
                    vector3dArray2[0] = vector3dArray2[0].minus(vector3dArray[1].times(0.5));
                    vector3d3 = vector3d3.setY(0.0);
                    vector3d3 = vector3d3.setX(Math.sqrt(2.0) * d);
                }
                if (datatip.getOrientation() == 6) {
                    vector3dArray2[0] = vector3dArray2[0].minus(vector3dArray[0].times(0.5));
                    vector3d3 = vector3d3.setX(0.0);
                    vector3d3 = vector3d3.setY(Math.sqrt(2.0) * d);
                }
                if (datatip.getOrientation() == 7) {
                    vector3dArray2[0] = vector3dArray2[0].minus(vector3dArray[0].times(0.5));
                    vector3dArray2[0] = vector3dArray2[0].minus(vector3dArray[1]);
                    vector3d3 = vector3d3.setX(0.0);
                    vector3d3 = vector3d3.setY(Math.sqrt(2.0) * -d);
                }
            }
            vector3dArray2[0] = vector3dArray2[0].plus(vector3d3);
            vector3dArray2[1] = vector3dArray2[1].plus(vector3d3);
        }
        vector3d3 = vector3dArray2[0];
        if (datatip.getDetachedMode().booleanValue()) {
            vector3d3 = transformation.project(DatatipTextDrawer.calculateDetachedPoint(datatip));
            this.drawDetachedLine(drawingTools, colorMap, datatip, this.calculateDetachedLine(vector3d3, vector3dArray2, vector3dArray, d));
            Vector3d vector3d6 = vector3dArray2[1].minus(vector3dArray2[0]);
            vector3dArray2[0] = vector3d3;
            vector3dArray2[1] = vector3d3.plus(vector3d6);
        }
        drawingTools.draw(texture, AnchorPosition.LOWER_LEFT, vector3d3, -180.0 * datatip.getFontAngle() / Math.PI);
        drawingTools.getTransformationManager().useSceneCoordinate();
        Vector3d[] vector3dArray3 = datatip.getTextBoxMode() == 2 ? this.computeProjTextBoxCorners(vector3dArray2[1], datatip.getFontAngle(), vector3dArray) : this.computeProjCorners(vector3dArray2[0], datatip.getFontAngle(), texture.getDataProvider().getTextureSize());
        vector3d2 = this.computeCorners(transformation, vector3dArray3, axes);
        vector3d = this.cornersToCoordinateArray((Vector3d[])vector3d2);
        datatip.setCorners((Double[])vector3d);
    }

    public void drawDetachedLine(DrawingTools drawingTools, ColorMap colorMap, Datatip datatip, Vector3d[] vector3dArray) throws SciRendererException {
        DefaultGeometry defaultGeometry = new DefaultGeometry();
        defaultGeometry.setLineDrawingMode(Geometry.LineDrawingMode.SEGMENTS);
        defaultGeometry.setFillDrawingMode(Geometry.FillDrawingMode.NONE);
        defaultGeometry.setFaceCullingMode(Geometry.FaceCullingMode.BOTH);
        Appearance appearance = new Appearance();
        appearance.setLineColor(ColorFactory.createColor(colorMap, datatip.getLine().getColor()));
        appearance.setLinePattern(datatip.getLineStyleAsEnum().asPattern());
        FloatBuffer floatBuffer = FloatBuffer.allocate(6);
        floatBuffer.put(0, (float)vector3dArray[0].getX());
        floatBuffer.put(1, (float)vector3dArray[0].getY());
        floatBuffer.put(2, (float)vector3dArray[0].getZ());
        floatBuffer.put(3, (float)vector3dArray[1].getX());
        floatBuffer.put(4, (float)vector3dArray[1].getY());
        floatBuffer.put(5, (float)vector3dArray[1].getZ());
        this.lineBuffer.setData(floatBuffer, 3);
        defaultGeometry.setVertices(this.lineBuffer);
        drawingTools.draw((Geometry)defaultGeometry, appearance);
    }

    private Vector3d[] calculateDetachedLine(Vector3d vector3d, Vector3d[] vector3dArray, Vector3d[] vector3dArray2, double d) {
        Vector3d vector3d2 = vector3d;
        Vector3d vector3d3 = vector3dArray[0];
        double d2 = d;
        double d3 = d;
        if (vector3d2.getX() < vector3dArray[0].getX()) {
            vector3d2 = vector3d2.plus(vector3dArray2[0]);
            d2 = -d;
        }
        if (vector3d2.getY() < vector3dArray[0].getY()) {
            vector3d2 = vector3d2.plus(vector3dArray2[1]);
            d3 = -d;
        }
        vector3d3 = vector3d3.plus(new Vector3d(new double[]{d2, d3, 0.0}));
        return new Vector3d[]{vector3d3, vector3d2};
    }

    public static void updateTextCorners(Datatip datatip) {
        Object[] objectArray;
        Vector3d[] vector3dArray;
        Vector3d[] vector3dArray2 = null;
        DrawerVisitor drawerVisitor = DrawerVisitor.getVisitor(datatip.getParentFrameOrFigure());
        Transformation transformation = drawerVisitor.getAxesDrawer().getProjection(datatip.getParentAxes());
        Axes axes = (Axes)GraphicController.getController().getObjectFromId(datatip.getParentAxes());
        Dimension dimension = drawerVisitor.getDatatipTextDrawer().getSpriteDims(drawerVisitor.getColorMap(), (Text)datatip);
        try {
            vector3dArray = drawerVisitor.getDatatipTextDrawer().computeTextBoxVectors(transformation, (Text)datatip, dimension, axes);
            objectArray = drawerVisitor.getDatatipTextDrawer().computeTextPosition(transformation, (Text)datatip, vector3dArray, dimension);
            Integer n = datatip.getMarkSize();
            Integer n2 = datatip.getMarkSizeUnit();
            double d = n2 == 1 ? 8.0 + 2.0 * (double)n.intValue() : (double)n.intValue();
            double d2 = datatip.getMarkStyle() == 11 ? 1.0 : 2.0;
            Vector3d vector3d = new Vector3d(d -= (d /= 2.0) >= 2.0 ? d2 : 0.0, d, 0.0);
            if (datatip.getOrientation() == 2 || datatip.getOrientation() == 3) {
                objectArray[0] = objectArray[0].minus(vector3dArray[1]);
                vector3d = vector3d.setY(-d);
            }
            if (datatip.getOrientation() == 0 || datatip.getOrientation() == 2) {
                objectArray[0] = objectArray[0].minus(vector3dArray[0]);
                vector3d = vector3d.setX(-d);
            }
            if (datatip.getOrientation() == 4) {
                objectArray[0] = objectArray[0].minus(vector3dArray[0]);
                objectArray[0] = objectArray[0].minus(vector3dArray[1].times(0.5));
                vector3d = vector3d.setY(0.0);
                vector3d = vector3d.setX(Math.sqrt(2.0) * -d);
            }
            if (datatip.getOrientation() == 5) {
                objectArray[0] = objectArray[0].minus(vector3dArray[1].times(0.5));
                vector3d = vector3d.setY(0.0);
                vector3d = vector3d.setX(Math.sqrt(2.0) * d);
            }
            if (datatip.getOrientation() == 6) {
                objectArray[0] = objectArray[0].minus(vector3dArray[0].times(0.5));
                vector3d = vector3d.setX(0.0);
                vector3d = vector3d.setY(Math.sqrt(2.0) * d);
            }
            if (datatip.getOrientation() == 7) {
                objectArray[0] = objectArray[0].minus(vector3dArray[0].times(0.5));
                objectArray[0] = objectArray[0].minus(vector3dArray[1]);
                vector3d = vector3d.setX(0.0);
                vector3d = vector3d.setY(Math.sqrt(2.0) * -d);
            }
            objectArray[0] = objectArray[0].plus(vector3d);
            objectArray[1] = objectArray[1].plus(vector3d);
            vector3dArray2 = datatip.getTextBoxMode() == 2 ? drawerVisitor.getDatatipTextDrawer().computeProjTextBoxCorners(objectArray[1], datatip.getFontAngle(), vector3dArray) : drawerVisitor.getDatatipTextDrawer().computeProjCorners(objectArray[0], datatip.getFontAngle(), dimension);
        }
        catch (DegenerateMatrixException degenerateMatrixException) {
            degenerateMatrixException.printStackTrace();
        }
        vector3dArray = drawerVisitor.getDatatipTextDrawer().computeCorners(transformation, vector3dArray2, axes);
        objectArray = drawerVisitor.getDatatipTextDrawer().cornersToCoordinateArray(vector3dArray);
        datatip.setCorners((Double[])objectArray);
    }

    public static Vector3d calculateAnchorPoint(Datatip datatip) {
        Axes axes = (Axes)GraphicController.getController().getObjectFromId(datatip.getParentAxes());
        double[][] dArray = axes.getScaleTranslateFactors();
        boolean[] blArray = new boolean[]{axes.getXAxisLogFlag(), axes.getYAxisLogFlag(), axes.getZAxisLogFlag()};
        Vector3d vector3d = ScaleUtils.applyLogScale(new Vector3d(datatip.getTipData()), blArray);
        return new Vector3d(vector3d.getX() * dArray[0][0] + dArray[1][0], vector3d.getY() * dArray[0][1] + dArray[1][1], vector3d.getZ() * dArray[0][2] + dArray[1][2]);
    }

    public static Vector3d calculateDetachedPoint(Datatip datatip) {
        Axes axes = (Axes)GraphicController.getController().getObjectFromId(datatip.getParentAxes());
        double[][] dArray = axes.getScaleTranslateFactors();
        boolean[] blArray = new boolean[]{axes.getXAxisLogFlag(), axes.getYAxisLogFlag(), axes.getZAxisLogFlag()};
        Double[] doubleArray = datatip.getDetachedPosition();
        Vector3d vector3d = ScaleUtils.applyLogScale(new Vector3d(doubleArray[0].doubleValue(), doubleArray[1].doubleValue(), doubleArray[2].doubleValue()), blArray);
        return new Vector3d(vector3d.getX() * dArray[0][0] + dArray[1][0], vector3d.getY() * dArray[0][1] + dArray[1][1], vector3d.getZ() * dArray[0][2] + dArray[1][2]);
    }

    private static int getAutoOrientation(Datatip datatip) {
        int n;
        double[] dArray;
        double[] dArray2;
        double[] dArray3;
        double[] dArray4 = (double[])PolylineData.getDataX((int)datatip.getParent());
        Double[] doubleArray = datatip.getIndexes();
        int n2 = doubleArray[0].intValue();
        if (n2 == 0 || n2 >= dArray4.length - 1) {
            return -1;
        }
        double[] dArray5 = (double[])PolylineData.getDataY((int)datatip.getParent());
        Integer n3 = datatip.getParentAxes();
        if (PolylineData.isZCoordSet((int)datatip.getParent()) != 0) {
            double[] dArray6 = (double[])PolylineData.getDataZ((int)datatip.getParent());
            dArray3 = CallRenderer.getPixelFrom3dCoordinates(n3, new double[]{dArray4[n2 - 1], dArray5[n2 - 1], dArray6[n2 - 1]});
            dArray2 = CallRenderer.getPixelFrom3dCoordinates(n3, new double[]{dArray4[n2], dArray5[n2], dArray6[n2]});
            dArray = CallRenderer.getPixelFrom3dCoordinates(n3, new double[]{dArray4[n2 + 1], dArray5[n2 + 1], dArray6[n2 + 1]});
        } else {
            dArray3 = CallRenderer.getPixelFrom3dCoordinates(n3, new double[]{dArray4[n2 - 1], dArray5[n2 - 1], 0.0});
            dArray2 = CallRenderer.getPixelFrom3dCoordinates(n3, new double[]{dArray4[n2], dArray5[n2], 0.0});
            dArray = CallRenderer.getPixelFrom3dCoordinates(n3, new double[]{dArray4[n2 + 1], dArray5[n2 + 1], 0.0});
        }
        double d = Math.atan2(dArray2[1] - dArray3[1], dArray3[0] - dArray2[0]);
        double d2 = Math.atan2(dArray2[1] - dArray[1], dArray[0] - dArray2[0]);
        int n4 = DatatipTextDrawer.getQuad(d);
        int n5 = DatatipTextDrawer.getQuad(d2);
        if (n4 == n5) {
            n = (n4 + 2) % 4;
        } else {
            int n6 = n4 + n5;
            if (n6 == 3) {
                n = (n4 * n5 + 1) % 3;
            } else if (n6 == 1 || n6 == 5) {
                n = (n6 + 3) % 8;
            } else {
                double d3 = Math.max(d, d2);
                double d4 = Math.min(d, d2);
                n = n6 == 4 ? (d3 - d4 <= Math.PI ? 2 : 0) : (d3 - d4 <= Math.PI ? 1 : 3);
            }
        }
        if (n <= 1) {
            return 1 - n;
        }
        return n;
    }

    private static int getQuad(double d) {
        if (d >= 0.0) {
            if (d <= 1.5707963267948966) {
                return 0;
            }
            return 1;
        }
        if (d <= -1.5707963267948966) {
            return 2;
        }
        return 3;
    }
}

