/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.renderer.JoGLView.axes;

import java.awt.Dimension;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.Map;
import org.scilab.forge.scirenderer.DrawingTools;
import org.scilab.forge.scirenderer.SciRendererException;
import org.scilab.forge.scirenderer.clipping.ClippingPlane;
import org.scilab.forge.scirenderer.implementation.jogl.drawer.JoGLShapeDrawer;
import org.scilab.forge.scirenderer.shapes.appearance.Appearance;
import org.scilab.forge.scirenderer.shapes.geometry.Geometry;
import org.scilab.forge.scirenderer.tranformations.DegenerateMatrixException;
import org.scilab.forge.scirenderer.tranformations.Transformation;
import org.scilab.forge.scirenderer.tranformations.TransformationFactory;
import org.scilab.forge.scirenderer.tranformations.TransformationStack;
import org.scilab.forge.scirenderer.tranformations.Vector3d;
import org.scilab.forge.scirenderer.tranformations.Vector4d;
import org.scilab.modules.graphic_objects.axes.Axes;
import org.scilab.modules.graphic_objects.axes.AxisProperty;
import org.scilab.modules.graphic_objects.axes.Box;
import org.scilab.modules.graphic_objects.axes.Camera;
import org.scilab.modules.graphic_objects.contouredObject.Line;
import org.scilab.modules.graphic_objects.figure.ColorMap;
import org.scilab.modules.graphic_objects.figure.Figure;
import org.scilab.modules.graphic_objects.graphicController.GraphicController;
import org.scilab.modules.graphic_objects.graphicObject.ClippableProperty;
import org.scilab.modules.graphic_objects.graphicObject.GraphicObject;
import org.scilab.modules.graphic_objects.legend.Legend;
import org.scilab.modules.renderer.JoGLView.DrawerVisitor;
import org.scilab.modules.renderer.JoGLView.axes.Geometries;
import org.scilab.modules.renderer.JoGLView.axes.ruler.AxesRulerDrawer;
import org.scilab.modules.renderer.JoGLView.label.AxisLabelPositioner;
import org.scilab.modules.renderer.JoGLView.label.LabelManager;
import org.scilab.modules.renderer.JoGLView.label.TitlePositioner;
import org.scilab.modules.renderer.JoGLView.label.YAxisLabelPositioner;
import org.scilab.modules.renderer.JoGLView.util.ColorFactory;
import org.scilab.modules.renderer.JoGLView.util.ScaleUtils;

public class AxesDrawer {
    private static final double DEFAULT_THETA = 270.0;
    private static final Line.LineType HIDDEN_BORDER_PATTERN = Line.LineType.DASH;
    private static final double CLIPPING_EPSILON = 1.0E-5;
    private final DrawerVisitor visitor;
    private final Geometries geometries;
    private final AxesRulerDrawer rulerDrawer;
    private Geometry.FaceCullingMode frontFaceCullingMode;
    private Geometry.FaceCullingMode backFaceCullingMode;
    private final LabelManager labelManager;
    private final Map<Integer, AxisLabelPositioner> xAxisLabelPositioner = new HashMap<Integer, AxisLabelPositioner>();
    private final Map<Integer, AxisLabelPositioner> yAxisLabelPositioner = new HashMap<Integer, AxisLabelPositioner>();
    private final Map<Integer, AxisLabelPositioner> zAxisLabelPositioner = new HashMap<Integer, AxisLabelPositioner>();
    private final Map<Integer, TitlePositioner> titlePositioner = new HashMap<Integer, TitlePositioner>();
    private double[] reversedBounds;
    private double[] reversedBoundsIntervals;
    private Transformation currentProjection;
    private Transformation currentDataTransformation;
    private final Map<Integer, Transformation> projectionMap = new HashMap<Integer, Transformation>();
    private final Map<Integer, Transformation> projection2dViewMap = new HashMap<Integer, Transformation>();
    private final Map<Integer, Transformation> sceneProjectionMap = new HashMap<Integer, Transformation>();

    public AxesDrawer(DrawerVisitor drawerVisitor) {
        this.visitor = drawerVisitor;
        this.labelManager = drawerVisitor.getLabelManager();
        this.geometries = new Geometries(drawerVisitor.getCanvas());
        this.rulerDrawer = new AxesRulerDrawer(drawerVisitor.getCanvas());
        this.reversedBounds = new double[6];
        this.reversedBoundsIntervals = new double[3];
    }

    public LabelManager getLabelManager() {
        return this.labelManager;
    }

    public Transformation getCurrentProjection(Axes axes) throws DegenerateMatrixException {
        DrawingTools drawingTools = this.visitor.getDrawingTools();
        Transformation transformation = this.computeZoneProjection(axes);
        Transformation transformation2 = this.computeBoxTransformation(axes, this.visitor.getCanvas().getDimension(), false);
        Transformation transformation3 = this.computeDataTransformation(axes);
        Transformation transformation4 = drawingTools == null ? TransformationFactory.getIdentity() : drawingTools.getTransformationManager().getWindowTransformation().getInverseTransformation();
        Transformation transformation5 = transformation.rightTimes(transformation2);
        transformation5 = transformation5.rightTimes(transformation3);
        return transformation4.rightTimes(transformation5);
    }

    public void computeRulers(Axes axes) {
        Figure figure = (Figure)GraphicController.getController().getObjectFromId(axes.getParentFigure());
        if (figure == null) {
            return;
        }
        ColorMap colorMap = figure.getColorMap();
        try {
            Dimension dimension = this.visitor.getCanvas().getDimension();
            double d = dimension.getWidth() / 2.0;
            double d2 = dimension.getHeight() / 2.0;
            Transformation transformation = TransformationFactory.getAffineTransformation((Vector3d)new Vector3d(d, d2, 1.0), (Vector3d)new Vector3d(d, d2, 0.0));
            Transformation transformation2 = this.computeZoneProjection(axes);
            Transformation transformation3 = this.computeBoxTransformation(axes, dimension, false);
            Transformation transformation4 = transformation.rightTimes(transformation2).rightTimes(transformation3);
            this.rulerDrawer.computeRulers(axes, this, colorMap, transformation3, transformation4);
        }
        catch (DegenerateMatrixException degenerateMatrixException) {
            // empty catch block
        }
    }

    public void computeMargins(Axes axes) {
        if (axes.getAutoMargins().booleanValue() && axes.getViewAsEnum() == Camera.ViewType.VIEW_2D) {
            Figure figure = (Figure)GraphicController.getController().getObjectFromId(axes.getParentFigure());
            ColorMap colorMap = null;
            if (figure == null) {
                return;
            }
            colorMap = figure.getColorMap();
            Dimension[] dimensionArray = this.labelManager.getLabelsSize(colorMap, axes, this);
            Integer[] integerArray = new Integer[]{this.visitor.getCanvas().getWidth(), this.visitor.getCanvas().getHeight()};
            if (integerArray[0] != 0 && integerArray[1] != 0) {
                double d;
                Double[] doubleArray = axes.getAxesBounds();
                Double[] doubleArray2 = axes.getMargins();
                Double[] doubleArray3 = new Double[]{0.0, 0.0, 0.0, 0.0};
                Double[] doubleArray4 = new Double[]{0.0, 0.0, 0.0, 0.0};
                Double[] doubleArray5 = new Double[]{0.0, 0.0, 0.0, 0.0};
                AxisProperty.AxisLocation axisLocation = axes.getXAxis().getAxisLocation();
                AxisProperty.AxisLocation axisLocation2 = axes.getYAxis().getAxisLocation();
                if (dimensionArray[0].height != 0 || dimensionArray[2].height != 0 || dimensionArray[1].width != 0) {
                    if (dimensionArray[2].height != 0) {
                        d = ((double)(dimensionArray[2].height + 2) + 8.0) / ((double)integerArray[1].intValue() * doubleArray[3]);
                        doubleArray3[2] = d;
                    }
                    if (dimensionArray[0].height != 0 && (axisLocation == AxisProperty.AxisLocation.BOTTOM || axisLocation == AxisProperty.AxisLocation.TOP)) {
                        d = (double)(dimensionArray[0].height + 2) / ((double)integerArray[1].intValue() * doubleArray[3]);
                        if (axisLocation == AxisProperty.AxisLocation.BOTTOM) {
                            doubleArray3[3] = d;
                        } else {
                            Double[] doubleArray6 = doubleArray3;
                            Double.valueOf(doubleArray6[2] + d);
                        }
                    }
                    if (dimensionArray[1].width != 0 && (axisLocation2 == AxisProperty.AxisLocation.LEFT || axisLocation2 == AxisProperty.AxisLocation.RIGHT)) {
                        d = (double)(dimensionArray[1].width + 2) / ((double)integerArray[0].intValue() * doubleArray[2]);
                        if (axisLocation2 == AxisProperty.AxisLocation.LEFT) {
                            doubleArray3[0] = d;
                        } else {
                            doubleArray3[1] = d;
                        }
                    }
                }
                d = this.rulerDrawer.getRulerDrawer(axes, 0).getDistanceRatio();
                double d2 = this.rulerDrawer.getRulerDrawer(axes, 1).getDistanceRatio();
                if (axisLocation == AxisProperty.AxisLocation.BOTTOM) {
                    doubleArray4[3] = (1.0 - doubleArray2[2] - doubleArray2[3]) * d / 2.0;
                } else if (axisLocation == AxisProperty.AxisLocation.TOP) {
                    doubleArray4[2] = (1.0 - doubleArray2[2] - doubleArray2[3]) * d / 2.0;
                }
                if (axisLocation2 == AxisProperty.AxisLocation.LEFT) {
                    doubleArray4[0] = (1.0 - doubleArray2[0] - doubleArray2[1]) * d2 / 2.0;
                } else if (axisLocation2 == AxisProperty.AxisLocation.RIGHT) {
                    doubleArray4[1] = (1.0 - doubleArray2[0] - doubleArray2[1]) * d2 / 2.0;
                }
                if (axes.getChildren() != null) {
                    for (Integer n : axes.getChildren()) {
                        GraphicObject graphicObject = GraphicController.getController().getObjectFromId(n);
                        if (!(graphicObject instanceof Legend)) continue;
                        Legend legend = (Legend)graphicObject;
                        Dimension dimension = this.visitor.getLegendDrawer().computeDimensions(axes, legend);
                        if (dimension == null) break;
                        Legend.LegendLocation legendLocation = legend.getLegendLocationAsEnum();
                        switch (legendLocation) {
                            case OUT_UPPER_RIGHT: 
                            case OUT_LOWER_RIGHT: {
                                double d3 = legend.getLineWidth() + 0.0625;
                                doubleArray5[0] = Math.max(doubleArray4[0] + doubleArray3[0], 0.125);
                                doubleArray5[1] = Math.max(((double)(dimension.width + 2) / (doubleArray[2] * (double)integerArray[0].intValue()) + d3 * (1.0 - doubleArray5[0])) / (1.0 + d3) + doubleArray4[1] + doubleArray3[1], 0.125);
                                break;
                            }
                            case OUT_UPPER_LEFT: 
                            case OUT_LOWER_LEFT: {
                                double d3 = legend.getLineWidth() + 0.0625;
                                doubleArray5[1] = Math.max(doubleArray4[1] + doubleArray3[1], 0.125);
                                doubleArray5[0] = Math.max(((double)(dimension.width + 2) / (doubleArray[2] * (double)integerArray[0].intValue()) + d3 * (1.0 - doubleArray5[1])) / (1.0 + d3) + doubleArray4[0] + doubleArray3[0], 0.125);
                                break;
                            }
                            case UPPER_CAPTION: {
                                double d3 = 0.05;
                                doubleArray5[3] = Math.max(doubleArray4[3] + doubleArray3[3], 0.125);
                                doubleArray5[2] = Math.max(Math.max(((double)(dimension.height + 2) / (doubleArray[3] * (double)integerArray[1].intValue()) + d3 * (1.0 - doubleArray5[3])) / (1.0 + d3), doubleArray3[2]) + doubleArray4[2], 0.125);
                                break;
                            }
                            case LOWER_CAPTION: {
                                double d3 = 0.05;
                                doubleArray5[2] = Math.max(doubleArray4[2] + doubleArray3[2], 0.125);
                                doubleArray5[3] = Math.max(Math.max(((double)(dimension.height + 2) / (doubleArray[3] * (double)integerArray[1].intValue()) + d3 * (1.0 - doubleArray5[2])) / (1.0 + d3), doubleArray3[3]) + doubleArray4[3], 0.125);
                                break;
                            }
                        }
                        break;
                    }
                }
                for (int i = 0; i < doubleArray5.length; ++i) {
                    if (doubleArray5[i] != 0.0) continue;
                    doubleArray5[i] = Math.max(doubleArray4[i] + doubleArray3[i], 0.125);
                }
                if (!(doubleArray5[0].equals(doubleArray2[0]) && doubleArray5[1].equals(doubleArray2[1]) && doubleArray5[2].equals(doubleArray2[2]) && doubleArray5[3].equals(doubleArray2[3]))) {
                    axes.setMargins(doubleArray5);
                }
            }
        }
    }

    public void draw(Axes axes) throws SciRendererException {
        Transformation transformation;
        Transformation transformation2;
        DrawingTools drawingTools = this.visitor.getDrawingTools();
        Dimension dimension = this.visitor.getCanvas().getDimension();
        ColorMap colorMap = this.visitor.getColorMap();
        TransformationStack transformationStack = drawingTools.getTransformationManager().getModelViewStack();
        TransformationStack transformationStack2 = drawingTools.getTransformationManager().getProjectionStack();
        Transformation transformation3 = this.computeZoneProjection(axes);
        transformationStack2.push(transformation3);
        Transformation transformation4 = this.computeBoxTransformation(axes, dimension, false);
        transformationStack.pushRightMultiply(transformation4);
        this.currentDataTransformation = transformation2 = this.computeDataTransformation(axes);
        this.currentProjection = transformation3.rightTimes(transformation4);
        this.currentProjection = this.currentProjection.rightTimes(transformation2);
        this.sceneProjectionMap.put(axes.getIdentifier(), this.currentProjection);
        Transformation transformation5 = drawingTools.getTransformationManager().getInverseWindowTransformation();
        this.currentProjection = transformation5.rightTimes(this.currentProjection);
        this.addProjection(axes.getIdentifier(), this.currentProjection);
        if (axes.getRotationAngles()[0] != 0.0 || axes.getRotationAngles()[1] != 270.0) {
            transformation = this.computeBoxTransformation(axes, dimension, true);
            this.currentProjection = transformation3.rightTimes(transformation);
            this.currentProjection = this.currentProjection.rightTimes(transformation2);
            this.currentProjection = transformation5.rightTimes(this.currentProjection);
        }
        this.addProjection2dView(axes.getIdentifier(), this.currentProjection);
        this.drawBackground(axes, drawingTools, colorMap);
        transformation = this.computeCubeMirroring(transformation4);
        transformationStack.pushRightMultiply(transformation);
        this.drawBox(axes, drawingTools, colorMap);
        transformationStack.pop();
        this.rulerDrawer.drawRuler(axes, this, colorMap, drawingTools);
        this.computeReversedBounds(axes);
        transformationStack.pushRightMultiply(transformation2);
        this.computeFaceCullingModes(axes);
        this.visitor.askAcceptVisitor(axes.getChildren());
        transformationStack.pop();
        transformationStack.pop();
        transformationStack2.pop();
    }

    private void drawBackground(Axes axes, DrawingTools drawingTools, ColorMap colorMap) throws SciRendererException {
        if (axes.getFilled().booleanValue()) {
            Appearance appearance = new Appearance();
            appearance.setFillColor(ColorFactory.createColor(colorMap, axes.getBackground()));
            drawingTools.draw(this.geometries.getCubeGeometry(), appearance, JoGLShapeDrawer.AntiAliasing.ON);
            drawingTools.clearDepthBuffer();
        }
    }

    private void drawBox(Axes axes, DrawingTools drawingTools, ColorMap colorMap) throws SciRendererException {
        Box.BoxType boxType = axes.getBox().getBox();
        if (boxType != Box.BoxType.OFF) {
            Appearance appearance = new Appearance();
            if (axes.getViewAsEnum() != Camera.ViewType.VIEW_2D) {
                appearance.setLineColor(ColorFactory.createColor(colorMap, axes.getHiddenAxisColor()));
                appearance.setLineWidth(axes.getLineThickness().floatValue());
                appearance.setLinePattern(HIDDEN_BORDER_PATTERN.asPattern());
                drawingTools.draw(this.geometries.getHiddenBoxBorderGeometry(), appearance, JoGLShapeDrawer.AntiAliasing.OFF);
            }
            if (boxType != Box.BoxType.HIDDEN_AXES) {
                appearance.setLineColor(ColorFactory.createColor(colorMap, axes.getLineColor()));
                appearance.setLineWidth(axes.getLineThickness().floatValue());
                appearance.setLinePattern(axes.getLine().getLineStyle().asPattern());
                drawingTools.draw(this.geometries.getBoxBorderGeometry(), appearance, JoGLShapeDrawer.AntiAliasing.OFF);
                if (boxType != Box.BoxType.BACK_HALF) {
                    drawingTools.draw(this.geometries.getFrontBoxBorderGeometry(), appearance, JoGLShapeDrawer.AntiAliasing.OFF);
                }
            }
        }
    }

    private Transformation computeCubeMirroring(Transformation transformation) {
        double[] dArray = transformation.getMatrix();
        try {
            return TransformationFactory.getScaleTransformation((double)(dArray[2] < 0.0 ? 1.0 : -1.0), (double)(dArray[6] < 0.0 ? 1.0 : -1.0), (double)(dArray[10] < 0.0 ? 1.0 : -1.0));
        }
        catch (DegenerateMatrixException degenerateMatrixException) {
            return TransformationFactory.getIdentity();
        }
    }

    private Rectangle2D computeZone(Axes axes) {
        Double[] doubleArray = axes.getAxesBounds();
        Double[] doubleArray2 = axes.getMargins();
        double d = (doubleArray[0] + doubleArray[2] * doubleArray2[0]) * 2.0 - 1.0;
        double d2 = (1.0 - doubleArray[1] - doubleArray[3] * (1.0 - doubleArray2[3])) * 2.0 - 1.0;
        double d3 = (1.0 - doubleArray2[0] - doubleArray2[1]) * doubleArray[2];
        double d4 = (1.0 - doubleArray2[2] - doubleArray2[3]) * doubleArray[3];
        if (axes.getIsoview().booleanValue()) {
            double d5 = Math.min(d3, d4);
            d2 += d4 - d5;
            d4 = d5;
            d += d3 - d5;
            d3 = d5;
        }
        return new Rectangle2D.Double(d, d2, d3, d4);
    }

    private Transformation computeZoneProjection(Axes axes) throws DegenerateMatrixException {
        Rectangle2D rectangle2D = this.computeZone(axes);
        Transformation transformation = TransformationFactory.getTranslateTransformation((double)rectangle2D.getMaxX(), (double)rectangle2D.getMaxY(), (double)0.0);
        Transformation transformation2 = TransformationFactory.getScaleTransformation((double)rectangle2D.getWidth(), (double)rectangle2D.getHeight(), (double)0.5);
        return transformation.rightTimes(transformation2);
    }

    private Transformation computeDataTransformation(Axes axes) throws DegenerateMatrixException {
        Transformation transformation = TransformationFactory.getScaleTransformation((double)(axes.getAxes()[0].getReverse() != false ? 1.0 : -1.0), (double)(axes.getAxes()[1].getReverse() != false ? 1.0 : -1.0), (double)(axes.getAxes()[2].getReverse() != false ? 1.0 : -1.0));
        if (axes.getZoomEnabled().booleanValue()) {
            Double[] doubleArray = axes.getCorrectedBounds();
            Transformation transformation2 = TransformationFactory.getScaleTransformation((double)(2.0 / (doubleArray[1] - doubleArray[0])), (double)(2.0 / (doubleArray[3] - doubleArray[2])), (double)(2.0 / (doubleArray[5] - doubleArray[4])));
            transformation = transformation.rightTimes(transformation2);
            Transformation transformation3 = TransformationFactory.getTranslateTransformation((double)(-(doubleArray[0] + doubleArray[1]) / 2.0), (double)(-(doubleArray[2] + doubleArray[3]) / 2.0), (double)(-(doubleArray[4] + doubleArray[5]) / 2.0));
            transformation = transformation.rightTimes(transformation3);
            return transformation;
        }
        return transformation;
    }

    private Transformation computeBoxTransformation(Axes axes, Dimension dimension, boolean bl) throws DegenerateMatrixException {
        Object[] objectArray;
        Object object;
        Object object2;
        double d;
        double d2;
        Transformation transformation;
        double d3;
        Double[] doubleArray = axes.getDisplayedBounds();
        Rectangle2D rectangle2D = this.computeZone(axes);
        double d4 = rectangle2D.getWidth() / rectangle2D.getHeight();
        Transformation transformation2 = TransformationFactory.getPreferredAspectRatioTransformation((Dimension)dimension, (double)d4);
        if (bl) {
            d3 = 540.0;
        } else {
            double d5 = -axes.getRotationAngles()[0].doubleValue();
            d3 = 270.0 + axes.getRotationAngles()[1];
            if (d5 != 0.0) {
                transformation = TransformationFactory.getRotationTransformation((double)d5, (double)1.0, (double)0.0, (double)0.0);
                transformation2 = transformation2.rightTimes(transformation);
            }
        }
        Transformation transformation3 = TransformationFactory.getRotationTransformation((double)d3, (double)0.0, (double)0.0, (double)1.0);
        transformation2 = transformation2.rightTimes(transformation3);
        if (!axes.getCubeScaling().booleanValue()) {
            d2 = doubleArray[1] - doubleArray[0];
            d = doubleArray[3] - doubleArray[2];
            object2 = doubleArray[5] - doubleArray[4];
            if (d2 != 1.0 || d != 1.0 || object2 != 1.0) {
                object = TransformationFactory.getScaleTransformation((double)d2, (double)d, (double)object2);
                transformation2 = transformation2.rightTimes((Transformation)object);
            }
        }
        object = transformation2.getMatrix();
        d2 = 1.0 / (Math.abs(object[0]) + Math.abs(object[4]) + Math.abs(object[8]));
        d = 1.0 / (Math.abs(object[1]) + Math.abs(object[5]) + Math.abs(object[9]));
        object2 = 1.0 / (Math.abs(object[2]) + Math.abs(object[6]) + Math.abs(object[10]));
        if (axes.getIsoview().booleanValue()) {
            objectArray = axes.getAxesBounds();
            Double[] doubleArray2 = axes.getMargins();
            double d6 = (1.0 - doubleArray2[0] - doubleArray2[1]) * objectArray[2];
            double d7 = (1.0 - doubleArray2[2] - doubleArray2[3]) * objectArray[3];
            double d8 = d7 > d6 ? Math.min(d2, d * (d7 / d6)) : Math.min(d2 * (d6 / d7), d);
            d2 = d8;
            d = d8;
        }
        if (axes.getView() == 1 && !bl) {
            if (axes.getAutoStretch().booleanValue()) {
                axes.setScale(d2, d, object2);
            } else {
                objectArray = axes.getScale();
                d2 = objectArray[0];
                d = objectArray[1];
                object2 = objectArray[2];
            }
        }
        transformation = TransformationFactory.getScaleTransformation((double)d2, (double)d, (double)object2);
        transformation2 = transformation2.leftTimes(transformation);
        return transformation2;
    }

    private void computeReversedBounds(Axes axes) {
        Double[] doubleArray = axes.getCorrectedBounds();
        if (axes.getAxes()[0].getReverse().booleanValue()) {
            this.reversedBounds[0] = doubleArray[1];
            this.reversedBounds[1] = doubleArray[0];
        } else {
            this.reversedBounds[0] = doubleArray[0];
            this.reversedBounds[1] = doubleArray[1];
        }
        if (axes.getAxes()[1].getReverse().booleanValue()) {
            this.reversedBounds[2] = doubleArray[3];
            this.reversedBounds[3] = doubleArray[2];
        } else {
            this.reversedBounds[2] = doubleArray[2];
            this.reversedBounds[3] = doubleArray[3];
        }
        if (axes.getAxes()[2].getReverse().booleanValue()) {
            this.reversedBounds[4] = doubleArray[5];
            this.reversedBounds[5] = doubleArray[4];
        } else {
            this.reversedBounds[4] = doubleArray[4];
            this.reversedBounds[5] = doubleArray[5];
        }
        this.reversedBoundsIntervals[0] = this.reversedBounds[1] == this.reversedBounds[0] ? 1.0 : this.reversedBounds[1] - this.reversedBounds[0];
        this.reversedBoundsIntervals[1] = this.reversedBounds[3] == this.reversedBounds[2] ? 1.0 : this.reversedBounds[3] - this.reversedBounds[2];
        this.reversedBoundsIntervals[2] = this.reversedBounds[5] == this.reversedBounds[4] ? 1.0 : this.reversedBounds[5] - this.reversedBounds[4];
    }

    private void computeFaceCullingModes(Axes axes) {
        if (axes.getAxes()[0].getReverse() ^ axes.getAxes()[1].getReverse() ^ axes.getAxes()[2].getReverse()) {
            this.frontFaceCullingMode = Geometry.FaceCullingMode.CW;
            this.backFaceCullingMode = Geometry.FaceCullingMode.CCW;
        } else {
            this.frontFaceCullingMode = Geometry.FaceCullingMode.CCW;
            this.backFaceCullingMode = Geometry.FaceCullingMode.CW;
        }
    }

    public Vector3d getBoxCoordinates(Vector3d vector3d) {
        double[] dArray = new double[]{1.0 - 2.0 * (vector3d.getX() - this.reversedBounds[0]) / this.reversedBoundsIntervals[0], 1.0 - 2.0 * (vector3d.getY() - this.reversedBounds[2]) / this.reversedBoundsIntervals[1], 1.0 - 2.0 * (vector3d.getZ() - this.reversedBounds[4]) / this.reversedBoundsIntervals[2]};
        return new Vector3d(dArray);
    }

    public Vector3d getObjectCoordinates(Vector3d vector3d) {
        double[] dArray = new double[]{0.5 * (1.0 - vector3d.getX()) * (this.reversedBounds[1] - this.reversedBounds[0]) + this.reversedBounds[0], 0.5 * (1.0 - vector3d.getY()) * (this.reversedBounds[3] - this.reversedBounds[2]) + this.reversedBounds[2], 0.5 * (1.0 - vector3d.getZ()) * (this.reversedBounds[5] - this.reversedBounds[4]) + this.reversedBounds[4]};
        return new Vector3d(dArray);
    }

    private Transformation computeProjection(Axes axes, DrawingTools drawingTools, Dimension dimension, boolean bl) {
        Transformation transformation;
        if (drawingTools == null) {
            return TransformationFactory.getIdentity();
        }
        try {
            Transformation transformation2 = this.computeZoneProjection(axes);
            Transformation transformation3 = this.computeBoxTransformation(axes, dimension, bl);
            Transformation transformation4 = this.computeDataTransformation(axes);
            transformation = transformation2.rightTimes(transformation3);
            transformation = transformation.rightTimes(transformation4);
            Transformation transformation5 = drawingTools.getTransformationManager().getWindowTransformation().getInverseTransformation();
            transformation = transformation5.rightTimes(transformation);
        }
        catch (DegenerateMatrixException degenerateMatrixException) {
            return TransformationFactory.getIdentity();
        }
        return transformation;
    }

    public Transformation getProjection() {
        return this.currentProjection;
    }

    public Transformation getDataTransformation() {
        return this.currentDataTransformation;
    }

    public synchronized void addProjection(Integer n, Transformation transformation) {
        this.projectionMap.put(n, transformation);
    }

    public Transformation getProjection(Integer n) {
        return this.projectionMap.get(n);
    }

    public void removeProjection(Integer n) {
        this.projectionMap.remove(n);
    }

    public synchronized void addProjection2dView(Integer n, Transformation transformation) {
        this.projection2dViewMap.put(n, transformation);
    }

    public Transformation getProjection2dView(Integer n) {
        return this.projection2dViewMap.get(n);
    }

    public Transformation getSceneProjection(Integer n) {
        return this.sceneProjectionMap.get(n);
    }

    public void removeProjection2dView(Integer n) {
        this.projection2dViewMap.remove(n);
    }

    public static void updateAxesTransformation(Axes axes) {
        Transformation transformation;
        DrawerVisitor drawerVisitor = DrawerVisitor.getVisitor(axes.getParentFrameOrFigure());
        AxesDrawer axesDrawer = drawerVisitor.getAxesDrawer();
        Dimension dimension = drawerVisitor.getCanvas().getDimension();
        Transformation transformation2 = axesDrawer.getProjection(axes.getIdentifier());
        if (transformation2 == null) {
            transformation = axesDrawer.computeProjection(axes, drawerVisitor.getDrawingTools(), dimension, false);
            axesDrawer.addProjection(axes.getIdentifier(), transformation);
        }
        if ((transformation = axesDrawer.getProjection2dView(axes.getIdentifier())) == null) {
            Transformation transformation3 = axesDrawer.computeProjection(axes, drawerVisitor.getDrawingTools(), dimension, true);
            axesDrawer.addProjection2dView(axes.getIdentifier(), transformation3);
        }
    }

    public static double[] compute2dViewCoordinates(Axes axes, double[] dArray) {
        DrawerVisitor drawerVisitor = DrawerVisitor.getVisitor(axes.getParentFrameOrFigure());
        double[] dArray2 = dArray;
        if (drawerVisitor != null) {
            boolean[] blArray = new boolean[]{axes.getXAxisLogFlag(), axes.getYAxisLogFlag(), axes.getZAxisLogFlag()};
            Dimension dimension = drawerVisitor.getCanvas().getDimension();
            double[][] dArray3 = axes.getScaleTranslateFactors();
            ScaleUtils.applyLogScale(dArray2, blArray);
            AxesDrawer axesDrawer = drawerVisitor.getAxesDrawer();
            dArray2[0] = dArray2[0] * dArray3[0][0] + dArray3[1][0];
            dArray2[1] = dArray2[1] * dArray3[0][1] + dArray3[1][1];
            dArray2[2] = dArray2[2] * dArray3[0][2] + dArray3[1][2];
            Transformation transformation = axesDrawer.computeProjection(axes, drawerVisitor.getDrawingTools(), dimension, false);
            Transformation transformation2 = axesDrawer.computeProjection(axes, drawerVisitor.getDrawingTools(), dimension, true);
            Vector3d vector3d = new Vector3d(dArray2);
            vector3d = transformation.project(vector3d);
            vector3d = transformation2.unproject(vector3d);
            dArray2 = vector3d.getData();
            dArray2[0] = (dArray2[0] - dArray3[1][0]) / dArray3[0][0];
            dArray2[1] = (dArray2[1] - dArray3[1][1]) / dArray3[0][1];
            dArray2[2] = (dArray2[2] - dArray3[1][2]) / dArray3[0][2];
            ScaleUtils.applyInverseLogScale(dArray2, blArray);
        }
        return dArray2;
    }

    public static double[] computePixelFrom2dViewCoordinates(Axes axes, double[] dArray) {
        DrawerVisitor drawerVisitor = DrawerVisitor.getVisitor(axes.getParentFrameOrFigure());
        double[] dArray2 = new double[]{0.0, 0.0, 0.0};
        if (drawerVisitor != null) {
            boolean[] blArray = new boolean[]{axes.getXAxisLogFlag(), axes.getYAxisLogFlag(), axes.getZAxisLogFlag()};
            double[][] dArray3 = axes.getScaleTranslateFactors();
            ScaleUtils.applyLogScale(dArray, blArray);
            AxesDrawer axesDrawer = drawerVisitor.getAxesDrawer();
            dArray2[0] = dArray[0] * dArray3[0][0] + dArray3[1][0];
            dArray2[1] = dArray[1] * dArray3[0][1] + dArray3[1][1];
            dArray2[2] = dArray[2] * dArray3[0][2] + dArray3[1][2];
            Transformation transformation = axesDrawer.getProjection2dView(axes.getIdentifier());
            if (transformation == null) {
                AxesDrawer.updateAxesTransformation(axes);
                transformation = axesDrawer.getProjection2dView(axes.getIdentifier());
            }
            Vector3d vector3d = new Vector3d(dArray2);
            vector3d = transformation.project(vector3d);
            dArray2[0] = vector3d.getX();
            dArray2[1] = (double)drawerVisitor.getCanvas().getHeight() - vector3d.getY();
            dArray2[2] = 0.0;
        }
        return dArray2;
    }

    public static double[] computePixelFrom3dCoordinates(Axes axes, double[] dArray) {
        DrawerVisitor drawerVisitor = DrawerVisitor.getVisitor(axes.getParentFrameOrFigure());
        boolean[] blArray = new boolean[]{axes.getXAxisLogFlag(), axes.getYAxisLogFlag(), axes.getZAxisLogFlag()};
        double[][] dArray2 = axes.getScaleTranslateFactors();
        Vector3d vector3d = new Vector3d(dArray);
        vector3d = ScaleUtils.applyLogScale(vector3d, blArray);
        double[] dArray3 = vector3d.getData();
        if (drawerVisitor != null) {
            AxesDrawer axesDrawer = drawerVisitor.getAxesDrawer();
            dArray3[0] = dArray3[0] * dArray2[0][0] + dArray2[1][0];
            dArray3[1] = dArray3[1] * dArray2[0][1] + dArray2[1][1];
            dArray3[2] = dArray3[2] * dArray2[0][2] + dArray2[1][2];
            Transformation transformation = axesDrawer.computeProjection(axes, drawerVisitor.getDrawingTools(), drawerVisitor.getCanvas().getDimension(), false);
            vector3d = new Vector3d(dArray3);
            vector3d = transformation.project(vector3d);
        }
        return new double[]{vector3d.getX(), (double)drawerVisitor.getCanvas().getHeight() - vector3d.getY(), vector3d.getZ()};
    }

    public static double[][] computePixelFrom3dCoordinates(Axes axes, double[] dArray, double[] dArray2, double[] dArray3) {
        DrawerVisitor drawerVisitor = DrawerVisitor.getVisitor(axes.getParentFrameOrFigure());
        if (drawerVisitor != null) {
            AxesDrawer axesDrawer = drawerVisitor.getAxesDrawer();
            Dimension dimension = drawerVisitor.getCanvas().getDimension();
            double d = dimension.getHeight();
            boolean[] blArray = new boolean[]{axes.getXAxisLogFlag(), axes.getYAxisLogFlag(), axes.getZAxisLogFlag()};
            double[][] dArray4 = axes.getScaleTranslateFactors();
            double[] dArray5 = new double[3];
            double[][] dArray6 = new double[dArray.length][2];
            Transformation transformation = axesDrawer.computeProjection(axes, drawerVisitor.getDrawingTools(), dimension, false);
            for (int i = 0; i < dArray.length; ++i) {
                dArray5[0] = dArray[i];
                dArray5[1] = dArray2[i];
                dArray5[2] = dArray3[i];
                ScaleUtils.applyLogScale(dArray5, blArray);
                dArray5[0] = dArray5[0] * dArray4[0][0] + dArray4[1][0];
                dArray5[1] = dArray5[1] * dArray4[0][1] + dArray4[1][1];
                dArray5[2] = dArray5[2] * dArray4[0][2] + dArray4[1][2];
                Vector3d vector3d = new Vector3d(dArray5);
                vector3d = transformation.project(vector3d);
                dArray6[i][0] = vector3d.getX();
                dArray6[i][1] = d - vector3d.getY();
            }
            return dArray6;
        }
        return null;
    }

    public static double[] compute3dViewCoordinates(Axes axes, double[] dArray) {
        DrawerVisitor drawerVisitor = DrawerVisitor.getVisitor(axes.getParentFrameOrFigure());
        double[] dArray2 = dArray;
        if (drawerVisitor != null) {
            if (axes.getViewAsEnum() == Camera.ViewType.VIEW_2D) {
                return new double[]{dArray2[0], dArray2[1], dArray2[2]};
            }
            boolean[] blArray = new boolean[]{axes.getXAxisLogFlag(), axes.getYAxisLogFlag(), axes.getZAxisLogFlag()};
            Dimension dimension = drawerVisitor.getCanvas().getDimension();
            double[][] dArray3 = axes.getScaleTranslateFactors();
            ScaleUtils.applyLogScale(dArray2, blArray);
            AxesDrawer axesDrawer = drawerVisitor.getAxesDrawer();
            dArray2[0] = dArray2[0] * dArray3[0][0] + dArray3[1][0];
            dArray2[1] = dArray2[1] * dArray3[0][1] + dArray3[1][1];
            dArray2[2] = dArray2[2] * dArray3[0][2] + dArray3[1][2];
            Transformation transformation = axesDrawer.computeProjection(axes, drawerVisitor.getDrawingTools(), dimension, false);
            Transformation transformation2 = axesDrawer.computeProjection(axes, drawerVisitor.getDrawingTools(), dimension, true);
            Vector3d vector3d = new Vector3d(dArray2);
            vector3d = transformation2.project(vector3d);
            vector3d = transformation.unproject(vector3d);
            dArray2 = vector3d.getData();
            dArray2[0] = (dArray2[0] - dArray3[1][0]) / dArray3[0][0];
            dArray2[1] = (dArray2[1] - dArray3[1][1]) / dArray3[0][1];
            dArray2[2] = (dArray2[2] - dArray3[1][2]) / dArray3[0][2];
            ScaleUtils.applyInverseLogScale(dArray2, blArray);
        }
        return dArray2;
    }

    public static double[] compute2dViewFromPixelCoordinates(Axes axes, double[] dArray) {
        double[] dArray2 = new double[]{0.0, 0.0, 0.0};
        DrawerVisitor drawerVisitor = DrawerVisitor.getVisitor(axes.getParentFrameOrFigure());
        if (drawerVisitor != null) {
            boolean[] blArray = new boolean[]{axes.getXAxisLogFlag(), axes.getYAxisLogFlag(), axes.getZAxisLogFlag()};
            double[][] dArray3 = axes.getScaleTranslateFactors();
            AxesDrawer axesDrawer = drawerVisitor.getAxesDrawer();
            Vector3d vector3d = new Vector3d(dArray[0], (double)drawerVisitor.getCanvas().getHeight() - dArray[1], 0.0);
            Transformation transformation = axesDrawer.getProjection2dView(axes.getIdentifier());
            if (transformation == null) {
                AxesDrawer.updateAxesTransformation(axes);
                transformation = axesDrawer.getProjection2dView(axes.getIdentifier());
            }
            vector3d = transformation.unproject(vector3d);
            dArray2 = vector3d.getData();
            dArray2[0] = (dArray2[0] - dArray3[1][0]) / dArray3[0][0];
            dArray2[1] = (dArray2[1] - dArray3[1][1]) / dArray3[0][1];
            dArray2[2] = (dArray2[2] - dArray3[1][2]) / dArray3[0][2];
            ScaleUtils.applyInverseLogScale(dArray2, blArray);
        }
        return dArray2;
    }

    public static Vector3d unProject(Axes axes, Vector3d vector3d) {
        DrawerVisitor drawerVisitor = DrawerVisitor.getVisitor(axes.getParentFrameOrFigure());
        if (drawerVisitor != null) {
            AxesDrawer axesDrawer = drawerVisitor.getAxesDrawer();
            double d = drawerVisitor.getCanvas().getHeight() - 1;
            Transformation transformation = axesDrawer.getProjection(axes.getIdentifier());
            return transformation.unproject(new Vector3d(vector3d.getX(), d - vector3d.getY(), vector3d.getZ()));
        }
        return new Vector3d(0.0, 0.0, 0.0);
    }

    public static double[] getViewingArea(Axes axes) {
        double[] dArray = new double[]{0.0, 0.0, 0.0, 0.0};
        DrawerVisitor drawerVisitor = DrawerVisitor.getVisitor(axes.getParentFrameOrFigure());
        if (drawerVisitor != null) {
            double d = drawerVisitor.getCanvas().getDimension().getWidth();
            double d2 = drawerVisitor.getCanvas().getDimension().getHeight();
            AxesDrawer axesDrawer = drawerVisitor.getAxesDrawer();
            Rectangle2D rectangle2D = axesDrawer.computeZone(axes);
            double d3 = rectangle2D.getY() + rectangle2D.getHeight() * 2.0;
            dArray[0] = (rectangle2D.getX() + 1.0) * 0.5 * d;
            dArray[1] = (1.0 - d3) * 0.5 * d2;
            dArray[2] = rectangle2D.getWidth() * d;
            dArray[3] = rectangle2D.getHeight() * d2;
        }
        return dArray;
    }

    public Geometry.FaceCullingMode getFrontFaceCullingMode() {
        return this.frontFaceCullingMode;
    }

    public Geometry.FaceCullingMode getBackFaceCullingMode() {
        return this.backFaceCullingMode;
    }

    public void enableClipping(Axes axes, ClippableProperty clippableProperty) {
        DrawingTools drawingTools = this.visitor.getDrawingTools();
        if (clippableProperty.getClipState() != ClippableProperty.ClipStateType.OFF) {
            ClippingPlane clippingPlane;
            int n;
            Transformation transformation;
            int n2 = 0;
            Vector4d[] vector4dArray = null;
            double[] dArray = new double[6];
            double[] dArray2 = new double[3];
            if (clippableProperty.getClipState() == ClippableProperty.ClipStateType.CLIPGRF) {
                n2 = 6;
                transformation = axes.getCorrectedBounds();
                for (n = 0; n < n2; ++n) {
                    dArray[n] = transformation[n];
                }
                dArray2[0] = 1.0E-5 * (transformation[1] - transformation[0]);
                dArray2[1] = 1.0E-5 * (transformation[3] - transformation[2]);
                dArray2[2] = 1.0E-5 * (transformation[5] - transformation[4]);
            } else if (clippableProperty.getClipState() == ClippableProperty.ClipStateType.ON) {
                n2 = 4;
                transformation = clippableProperty.getClipBox();
                dArray[0] = transformation[0];
                dArray[1] = transformation[0] + transformation[2];
                dArray[2] = transformation[1] - transformation[3];
                dArray[3] = transformation[1];
                double[][] dArray3 = axes.getScaleTranslateFactors();
                clippingPlane = axes.getMaximalDisplayedBounds();
                if (axes.getXAxisLogFlag().booleanValue()) {
                    dArray[0] = dArray[0] <= 0.0 ? clippingPlane[0] : Math.log10(dArray[0]);
                    dArray[1] = dArray[1] <= 0.0 ? clippingPlane[0] : Math.log10(dArray[1]);
                }
                if (axes.getYAxisLogFlag().booleanValue()) {
                    dArray[2] = dArray[2] <= 0.0 ? clippingPlane[2] : Math.log10(dArray[2]);
                    dArray[3] = dArray[3] <= 0.0 ? clippingPlane[2] : Math.log10(dArray[3]);
                }
                dArray[0] = dArray[0] * dArray3[0][0] + dArray3[1][0];
                dArray[1] = dArray[1] * dArray3[0][0] + dArray3[1][0];
                dArray[2] = dArray[2] * dArray3[0][1] + dArray3[1][1];
                dArray[3] = dArray[3] * dArray3[0][1] + dArray3[1][1];
                dArray2[0] = 1.0E-5 * (dArray[1] - dArray[0]);
                dArray2[1] = 1.0E-5 * (dArray[3] - dArray[2]);
            }
            vector4dArray = new Vector4d[n2];
            vector4dArray[0] = new Vector4d(1.0, 0.0, 0.0, -dArray[0] + dArray2[0]);
            vector4dArray[1] = new Vector4d(-1.0, 0.0, 0.0, dArray[1] + dArray2[0]);
            vector4dArray[2] = new Vector4d(0.0, 1.0, 0.0, -dArray[2] + dArray2[1]);
            vector4dArray[3] = new Vector4d(0.0, -1.0, 0.0, dArray[3] + dArray2[1]);
            if (n2 == 6) {
                vector4dArray[4] = new Vector4d(0.0, 0.0, 1.0, -dArray[4] + dArray2[2]);
                vector4dArray[5] = new Vector4d(0.0, 0.0, -1.0, dArray[5] + dArray2[2]);
            }
            transformation = drawingTools.getTransformationManager().getTransformation();
            for (n = 0; n < n2; ++n) {
                clippingPlane = drawingTools.getClippingManager().getClippingPlane(n);
                clippingPlane.setTransformation(transformation);
                clippingPlane.setEquation(vector4dArray[n]);
                clippingPlane.setEnable(true);
            }
        }
    }

    public void disableClipping(ClippableProperty clippableProperty) {
        int n = 0;
        if (clippableProperty.getClipState() == ClippableProperty.ClipStateType.CLIPGRF) {
            n = 6;
        } else if (clippableProperty.getClipState() == ClippableProperty.ClipStateType.ON) {
            n = 4;
        }
        for (int i = 0; i < n; ++i) {
            ClippingPlane clippingPlane = this.visitor.getDrawingTools().getClippingManager().getClippingPlane(i);
            clippingPlane.setEnable(false);
        }
        this.visitor.getDrawingTools().getClippingManager().disableClipping();
    }

    public AxisLabelPositioner getXAxisLabelPositioner(Axes axes) {
        AxisLabelPositioner axisLabelPositioner = this.xAxisLabelPositioner.get(axes.getIdentifier());
        if (axisLabelPositioner == null) {
            axisLabelPositioner = new AxisLabelPositioner();
            this.xAxisLabelPositioner.put(axes.getIdentifier(), axisLabelPositioner);
        }
        return axisLabelPositioner;
    }

    public AxisLabelPositioner getYAxisLabelPositioner(Axes axes) {
        AxisLabelPositioner axisLabelPositioner = this.yAxisLabelPositioner.get(axes.getIdentifier());
        if (axisLabelPositioner == null) {
            axisLabelPositioner = new YAxisLabelPositioner();
            this.yAxisLabelPositioner.put(axes.getIdentifier(), axisLabelPositioner);
        }
        return axisLabelPositioner;
    }

    public AxisLabelPositioner getZAxisLabelPositioner(Axes axes) {
        AxisLabelPositioner axisLabelPositioner = this.zAxisLabelPositioner.get(axes.getIdentifier());
        if (axisLabelPositioner == null) {
            axisLabelPositioner = new AxisLabelPositioner();
            this.zAxisLabelPositioner.put(axes.getIdentifier(), axisLabelPositioner);
        }
        return axisLabelPositioner;
    }

    public TitlePositioner getTitlePositioner(Axes axes) {
        TitlePositioner titlePositioner = this.titlePositioner.get(axes.getIdentifier());
        if (titlePositioner == null) {
            titlePositioner = new TitlePositioner();
            this.titlePositioner.put(axes.getIdentifier(), titlePositioner);
        }
        return titlePositioner;
    }

    public void disposeAll() {
        this.rulerDrawer.disposeAll();
        this.projectionMap.clear();
        this.projection2dViewMap.clear();
        this.sceneProjectionMap.clear();
        this.xAxisLabelPositioner.clear();
        this.yAxisLabelPositioner.clear();
        this.zAxisLabelPositioner.clear();
        this.titlePositioner.clear();
    }

    public void update(Integer n, int n2) {
        GraphicObject graphicObject;
        if (this.rulerDrawer.update(n, n2) && (graphicObject = GraphicController.getController().getObjectFromId(n)) instanceof Axes) {
            this.computeRulers((Axes)graphicObject);
        }
    }

    public void dispose(Integer n) {
        this.rulerDrawer.dispose(n);
        this.projectionMap.remove(n);
        this.projection2dViewMap.remove(n);
        this.sceneProjectionMap.remove(n);
        this.xAxisLabelPositioner.remove(n);
        this.yAxisLabelPositioner.remove(n);
        this.zAxisLabelPositioner.remove(n);
        this.titlePositioner.remove(n);
    }
}

