require_relative 'common_config'
require 'pry'
require 'io/console'

class Pry
  alias_method :orig_initialize, :initialize

  def initialize(options = {})
    prompt_procs = [proc { '>>' }, proc { '?>' }]
    prompt_descr = File.read(File.join(File.dirname(__FILE__), 'pry_prompt_descr.txt'))

    output = IO.open(STDOUT.to_i, 'w')
    output.sync = true

    input = IO.open(STDIN.to_i)
    input.echo = false if input.isatty

    input.instance_exec(output) { |o| @__rm_output = o }
    input.instance_eval do
      def readline(prompt)
        @__rm_output.write "#{prompt}"
        gets
      end
    end

    orig_initialize options.merge(
      {
        :input => input,
        :output => output,
        :prompt => Prompt.respond_to?(:new) ? Prompt.new('RM', prompt_descr, prompt_procs) : prompt_procs,
        :prompt_name => 'RM',
        :color => false,
        :pager => false,
        :auto_indent => false,
        :correct_indent => false,
        :completer => nil,
        :command_completions => nil,
        :file_completions => nil
      }
    )
  end
end
