require_relative 'common_config'
require 'irb'

module IRB
  class << self
    alias_method :orig_setup, :setup

    def setup(ap_path)
      orig_setup ap_path
      conf[:PROMPT][:RM] = { :PROMPT_I => '>>', :PROMPT_S => '?>', :PROMPT_C => '?>', :PROMPT_N => '?>', :RETURN => "=> %s\n" }
      conf[:PROMPT_MODE] = :RM
      conf[:AUTO_INDENT] = false
      conf[:USE_COLORIZE] = false
      conf[:USE_MULTILINE] = false
      conf[:ECHO_ON_ASSIGNMENT] = true
      conf[:USE_PAGER] = false
      conf[:USE_AUTOCOMPLETE] = false
    end
  end

  module RubyMineStdioInputMethodMixin
    def eof?
      if !IRB.const_defined?(:VERSION) || Gem::Version.new(IRB::VERSION) < Gem::Version.new("1.3.0")
        false # ignore EOF
      else
        super
      end
    end
  end

  class StdioInputMethod
    prepend RubyMineStdioInputMethodMixin
  end

  class Context
    alias_method :orig_initialize, :initialize

    def initialize(irb, workspace = nil, _in = nil, _out = nil)
      orig_initialize irb, workspace, StdioInputMethod.new
    end
  end
end
