#!/usr/bin/env sh

if [ $# -lt 1 ]; then
  echo "Usage: $0 ROOT_PATHS_FILE" 1>&2
  exit 1
fi

ROOT_PATHS_FILE="$1"

if [ ! -f "$ROOT_PATHS_FILE" ]; then
  echo "Error: ROOT_PATH doesn't exist or not a regular file: $ROOT_PATHS_FILE" 1>&2
  exit 1
fi

# N.B we are not using `find` or `stat` here, because they do not provide an option to read the list of paths from a file
# and therefore fail when used with too many/long paths.
while IFS="" read -r ROOT_PATH || [ -n "$ROOT_PATH" ]; do
  if [ -L "$ROOT_PATH" ]; then
    ROOT_PATH=$(readlink -f "$ROOT_PATH") # dereference
  fi

  if [ -d "$ROOT_PATH" ]; then
    echo "$ROOT_PATH"
  else
    continue
  fi

done < "$ROOT_PATHS_FILE"

exit 0
