#
# script for gem ruby_version_requirement collector. See: org.jetbrains.plugins.ruby.gem.gem.GemCompatibilityUtil
# based on rubygems api. See: https://guides.rubygems.org/rubygems-org-api/#gem-version-methods
#
require 'json'
require 'fileutils'

FileUtils.mkdir_p 'jsons'
almost_default = Gem::Requirement.new '> 0.0.0'
constraints = {}
%w[
  rails
].each do |gem_name|
  # get info about versions from rubygems api
  json_data = `curl https://rubygems.org/api/v1/versions/#{gem_name}.json`
  File.write("jsons/#{gem_name}.json", json_data)
  info_json = JSON.parse json_data
  constraints[gem_name] = Hash.new { |hash, key| hash[key] = { max: -1 } }
  gem_constraints = constraints[gem_name]
  # reverse and go from older to newer
  info_json.reverse.reject { _1['platform'] == 'x64-mingw-ucrt' || _1['prerelease'] }.each do |it|
    required_version = it['ruby_version']&.split(',')&.first # minitest has upper bound after comma
    gem_version = it['number']
    if required_version.nil?
      required_version = Gem::Requirement.default
    end
    gem_requirement = Gem::Requirement.new(required_version)
    if gem_requirement == almost_default
      required_version = Gem::Requirement.default
    end
    if gem_requirement.requirements[0][0] != '<' # ignore upper bounds
      gem_constraints["#{required_version}"][:max] = gem_version
    end
  end
end

constraints.select { |_, gem_constraints| gem_constraints.size != 0 }.each do |gem_name, gem_constraints|
  gem_constraints.each do |ruby_restriction, versions_range|
    begin
      op_and_version = Gem::Requirement.parse ruby_restriction
      puts "CONSTRAINTS.putValue(\"#{gem_name}\", new Constraint(\"#{op_and_version[0]}\", \"#{op_and_version[1]}\", \"#{versions_range[:max]}\"));"
    rescue Gem::Requirement::BadRequirementError => err
      STDERR.puts "Error parsing requirement for #{gem_name} #{err}"
    end
  end
end