/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.liquid.completion;

import com.intellij.codeInsight.completion.BasicInsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.lang.liquid.LiquidTagNames;
import com.intellij.lang.liquid.psi.PsiLiquidBlock;
import com.intellij.lang.liquid.psi.PsiLiquidTag;
import com.intellij.lang.liquid.psi.tree.LiquidElementTypesGenerated;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.DocumentUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class LiquidTagNameInsertHandler
extends BasicInsertHandler<LookupElement> {
    static final LiquidTagNameInsertHandler INSTANCE = new LiquidTagNameInsertHandler();
    private static final Logger LOG = Logger.getInstance(LiquidTagNameInsertHandler.class);

    LiquidTagNameInsertHandler() {
    }

    public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
        boolean noTagCloserRightNextToInsertion;
        int startOffset;
        PsiFile file;
        PsiElement tagNameElement;
        PsiLiquidTag tag;
        if (context == null) {
            LiquidTagNameInsertHandler.$$$reportNull$$$0(0);
        }
        if (item == null) {
            LiquidTagNameInsertHandler.$$$reportNull$$$0(1);
        }
        if ((tag = (PsiLiquidTag)PsiTreeUtil.getParentOfType((PsiElement)(tagNameElement = (file = context.getFile()).findElementAt(startOffset = context.getStartOffset())), PsiLiquidTag.class)) == null) {
            return;
        }
        String lookupString = item.getLookupString();
        boolean withDelimiters = tag.hasVisibleTagOpener();
        boolean withArguments = !LiquidTagNames.BLOCK_OPENING_TAGS_WITHOUT_ARGUMENTS.contains(lookupString);
        boolean bl = noTagCloserRightNextToInsertion = tag.getTagCloser() == null || LiquidTagNameInsertHandler.getTypeOfNextVisibleElement(tagNameElement, withArguments) != LiquidElementTypesGenerated.TAG_CLOSER;
        if (withDelimiters && noTagCloserRightNextToInsertion) {
            return;
        }
        PsiLiquidBlock block = (PsiLiquidBlock)PsiTreeUtil.getParentOfType((PsiElement)file.findElementAt(startOffset), PsiLiquidBlock.class);
        if (block == null) {
            LOG.debug("No PsiLiquidBlock found");
            return;
        }
        Document document = context.getDocument();
        StringBuilder sbToInsert = new StringBuilder();
        CaretModel caret = context.getEditor().getCaretModel();
        int nextLineNumber = caret.getLogicalPosition().line + 1;
        if (block.getClosingTag() == null) {
            sbToInsert.append(LiquidTagNameInsertHandler.buildBlockClosingTagString(tag, lookupString, withDelimiters));
        } else if (nextLineNumber >= document.getLineCount() || !DocumentUtil.isLineEmpty((Document)document, (int)nextLineNumber)) {
            sbToInsert.append("\n");
        }
        String stringToInsert = sbToInsert.toString();
        if (!stringToInsert.isEmpty()) {
            document.insertString(tag.getTextRange().getEndOffset(), (CharSequence)stringToInsert);
            context.commitDocument();
        }
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)context.getProject());
        codeStyleManager.reformat((PsiElement)block);
        int indentOffset = codeStyleManager.adjustLineIndent(file, document.getLineStartOffset(nextLineNumber));
        if (!withArguments) {
            caret.moveToOffset(indentOffset);
            return;
        }
        EditorModificationUtil.insertStringAtCaret((Editor)context.getEditor(), (String)" ", (boolean)false, (int)1);
    }

    @Nullable
    private static IElementType getTypeOfNextVisibleElement(@NotNull PsiElement tagNameElement, boolean withArguments) {
        if (tagNameElement == null) {
            LiquidTagNameInsertHandler.$$$reportNull$$$0(2);
        }
        PsiElement nextVisibleElement = PsiTreeUtil.skipWhitespacesForward((PsiElement)tagNameElement);
        if (withArguments && nextVisibleElement instanceof PsiErrorElement) {
            nextVisibleElement = PsiTreeUtil.skipWhitespacesForward((PsiElement)nextVisibleElement);
        }
        return PsiUtilCore.getElementType((PsiElement)nextVisibleElement);
    }

    @NotNull
    private static String buildBlockClosingTagString(@NotNull PsiLiquidTag openingTag, @NotNull String openingTagName, boolean withDelimiters) {
        if (openingTag == null) {
            LiquidTagNameInsertHandler.$$$reportNull$$$0(3);
        }
        if (openingTagName == null) {
            LiquidTagNameInsertHandler.$$$reportNull$$$0(4);
        }
        StringBuilder blockClosingTag = new StringBuilder("\n\n");
        blockClosingTag.append("end").append(openingTagName);
        if (withDelimiters) {
            blockClosingTag.insert(2, openingTag.hasTrimmingCloser() ? "{%-" : "{%");
            blockClosingTag.append(openingTag.hasTrimmingOpener() ? "-%}" : "%}");
        }
        String string = blockClosingTag.toString();
        if (string == null) {
            LiquidTagNameInsertHandler.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagNameElement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "openingTag";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "openingTagName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/liquid/completion/LiquidTagNameInsertHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/liquid/completion/LiquidTagNameInsertHandler";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "buildBlockClosingTagString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "handleInsert";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getTypeOfNextVisibleElement";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "buildBlockClosingTagString";
                break;
            }
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }
}

