/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.liquid.codeInsight.template;

import com.intellij.codeInsight.template.TemplateActionContext;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.lang.Language;
import com.intellij.lang.liquid.LiquidBundle;
import com.intellij.lang.liquid.LiquidFileViewProvider;
import com.intellij.lang.liquid.LiquidLanguage;
import com.intellij.lang.liquid.psi.LiquidPsiUtil;
import com.intellij.lang.liquid.psi.tree.LiquidElementTypes;
import com.intellij.lang.liquid.psi.tree.LiquidElementTypesGenerated;
import com.intellij.lang.liquid.psi.tree.LiquidTokenSets;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.text.CharArrayUtil;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LiquidLiveTemplateContext
extends TemplateContextType {
    protected LiquidLiveTemplateContext(@NlsContexts.Label @NotNull String presentableName) {
        if (presentableName == null) {
            LiquidLiveTemplateContext.$$$reportNull$$$0(0);
        }
        super(presentableName);
    }

    public boolean isInContext(@NotNull TemplateActionContext templateActionContext) {
        PsiFile file;
        FileViewProvider viewProvider;
        if (templateActionContext == null) {
            LiquidLiveTemplateContext.$$$reportNull$$$0(1);
        }
        if (!((viewProvider = (file = templateActionContext.getFile().getOriginalFile()).getViewProvider()) instanceof LiquidFileViewProvider)) {
            return false;
        }
        PsiElement startPsiElement = this.getValidContextElementAtOffset(templateActionContext, viewProvider, templateActionContext.getStartOffset());
        if (startPsiElement == null) {
            return false;
        }
        if (!templateActionContext.isSurrounding()) {
            return true;
        }
        PsiElement endPsiElement = this.getValidContextElementAtOffset(templateActionContext, viewProvider, templateActionContext.getEndOffset());
        if (endPsiElement == null) {
            return false;
        }
        PsiElement startingContainingStructuralElement = LiquidPsiUtil.getClosestStructuralElement(startPsiElement);
        PsiElement endingContainingStructuralElement = LiquidPsiUtil.getClosestStructuralElement(endPsiElement);
        return startingContainingStructuralElement != null && Objects.equals(startingContainingStructuralElement, endingContainingStructuralElement);
    }

    @Nullable
    private PsiElement getValidContextElementAtOffset(@NotNull TemplateActionContext templateActionContext, @NotNull FileViewProvider viewProvider, int offset) {
        PsiElement psiElement;
        if (templateActionContext == null) {
            LiquidLiveTemplateContext.$$$reportNull$$$0(2);
        }
        if (viewProvider == null) {
            LiquidLiveTemplateContext.$$$reportNull$$$0(3);
        }
        if (this.isValidElement(templateActionContext, psiElement = viewProvider.findElementAt(offset, LiquidLanguage.getInstance()), offset)) {
            return psiElement;
        }
        if (--offset < 0) {
            return null;
        }
        psiElement = viewProvider.findElementAt(offset, LiquidLanguage.getInstance());
        return this.isValidElement(templateActionContext, psiElement, offset) ? psiElement : null;
    }

    @Contract(value="_, null, _ -> false")
    protected boolean isValidElement(@NotNull TemplateActionContext templateActionContext, @Nullable PsiElement elementAtOffset, int offset) {
        if (templateActionContext == null) {
            LiquidLiveTemplateContext.$$$reportNull$$$0(4);
        }
        return elementAtOffset != null;
    }

    @Nullable
    public SyntaxHighlighter createHighlighter() {
        return SyntaxHighlighterFactory.getSyntaxHighlighter((Language)LiquidLanguage.getInstance(), null, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentableName";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateActionContext";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewProvider";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/liquid/codeInsight/template/LiquidLiveTemplateContext";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isInContext";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getValidContextElementAtOffset";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isValidElement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static final class ForBlock
    extends Generic {
        public ForBlock() {
            super(LiquidBundle.message("template.label.for", new Object[0]));
        }

        @Override
        protected boolean isValidElement(@NotNull TemplateActionContext templateActionContext, @Nullable PsiElement elementAtOffset, int offset) {
            if (templateActionContext == null) {
                ForBlock.$$$reportNull$$$0(0);
            }
            if (!super.isValidElement(templateActionContext, elementAtOffset, offset)) {
                return false;
            }
            return PsiUtilCore.getElementType((PsiElement)elementAtOffset.getParent()) == LiquidElementTypesGenerated.FOR_BRANCH;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "templateActionContext", "com/intellij/lang/liquid/codeInsight/template/LiquidLiveTemplateContext$ForBlock", "isValidElement"));
        }
    }

    public static final class CaseWhen
    extends Generic {
        public CaseWhen() {
            super(LiquidBundle.message("template.label.case.when", new Object[0]));
        }

        @Override
        protected boolean isValidElement(@NotNull TemplateActionContext templateActionContext, @Nullable PsiElement elementAtOffset, int offset) {
            if (templateActionContext == null) {
                CaseWhen.$$$reportNull$$$0(0);
            }
            if (!super.isValidElement(templateActionContext, elementAtOffset, offset)) {
                return false;
            }
            IElementType parentElementType = PsiUtilCore.getElementType((PsiElement)elementAtOffset.getParent());
            return parentElementType == LiquidElementTypesGenerated.CASE_BLOCK || parentElementType == LiquidElementTypesGenerated.WHEN_BRANCH;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "templateActionContext", "com/intellij/lang/liquid/codeInsight/template/LiquidLiveTemplateContext$CaseWhen", "isValidElement"));
        }
    }

    public static final class IfUnless
    extends Generic {
        public IfUnless() {
            super(LiquidBundle.message("template.label.if.unless", new Object[0]));
        }

        @Override
        protected boolean isValidElement(@NotNull TemplateActionContext templateActionContext, @Nullable PsiElement elementAtOffset, int offset) {
            if (templateActionContext == null) {
                IfUnless.$$$reportNull$$$0(0);
            }
            if (!super.isValidElement(templateActionContext, elementAtOffset, offset)) {
                return false;
            }
            IElementType parentElementType = PsiUtilCore.getElementType((PsiElement)elementAtOffset.getParent());
            return parentElementType != LiquidElementTypesGenerated.ELSE_BRANCH && LiquidTokenSets.IF_UNLESS_BRANCHES_AND_BLOCKS.contains(parentElementType);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "templateActionContext", "com/intellij/lang/liquid/codeInsight/template/LiquidLiveTemplateContext$IfUnless", "isValidElement"));
        }
    }

    public static class Generic
    extends LiquidLiveTemplateContext {
        public Generic() {
            this(LiquidLanguage.getInstance().getDisplayName());
        }

        protected Generic(@NlsContexts.Label @NotNull String presentableName) {
            if (presentableName == null) {
                Generic.$$$reportNull$$$0(0);
            }
            super(presentableName);
        }

        @Override
        @Contract(value="_, null, _ -> false")
        protected boolean isValidElement(@NotNull TemplateActionContext templateActionContext, @Nullable PsiElement elementAtOffset, int offset) {
            if (templateActionContext == null) {
                Generic.$$$reportNull$$$0(1);
            }
            return PsiUtilCore.getElementType((PsiElement)elementAtOffset) == LiquidElementTypes.LIQUID_TEMPLATE_BLOCK || Generic.isAvailableInLiquidTag(templateActionContext, elementAtOffset, offset);
        }

        private static boolean isAvailableInLiquidTag(@NotNull TemplateActionContext templateActionContext, @Nullable PsiElement elementAtOffset, int offset) {
            if (templateActionContext == null) {
                Generic.$$$reportNull$$$0(2);
            }
            if (!LiquidPsiUtil.isInsideLiquidTag(elementAtOffset)) {
                return false;
            }
            CharSequence fileChars = templateActionContext.isSurrounding() ? templateActionContext.getFile().getNode().getChars() : templateActionContext.getFile().getOriginalFile().getNode().getChars();
            int endOffset = CharArrayUtil.shiftForward((CharSequence)fileChars, (int)offset, (String)" \t");
            if (endOffset == fileChars.length() || endOffset < fileChars.length() && fileChars.charAt(endOffset) == '\n') {
                return true;
            }
            int startOffset = CharArrayUtil.shiftBackward((CharSequence)fileChars, (int)offset, (String)" \t");
            return startOffset > -1 && fileChars.charAt(startOffset) == '\n';
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentableName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "templateActionContext";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/liquid/codeInsight/template/LiquidLiveTemplateContext$Generic";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isValidElement";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isAvailableInLiquidTag";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

