/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.liquid.codeInsight.editorActions;

import com.intellij.lang.ASTNode;
import com.intellij.lang.folding.FoldingBuilder;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.lang.liquid.codeInsight.editorActions.LiquidCommenter;
import com.intellij.lang.liquid.psi.LiquidRecursiveVisitor;
import com.intellij.lang.liquid.psi.PsiLiquidBlock;
import com.intellij.lang.liquid.psi.PsiLiquidTag;
import com.intellij.lang.liquid.psi.tree.LiquidElementTypesGenerated;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.text.CharArrayUtil;
import java.util.ArrayList;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LiquidFoldingBuilder
implements FoldingBuilder,
DumbAware {
    private static final int MAX_COMMENT_LENGTH = 60;

    public FoldingDescriptor @NotNull [] buildFoldRegions(@NotNull ASTNode node, @NotNull Document document) {
        if (node == null) {
            LiquidFoldingBuilder.$$$reportNull$$$0(0);
        }
        if (document == null) {
            LiquidFoldingBuilder.$$$reportNull$$$0(1);
        }
        final ArrayList result = new ArrayList();
        node.getPsi().accept((PsiElementVisitor)new LiquidRecursiveVisitor(){

            @Override
            public void visitElement(@NotNull PsiElement o) {
                TextRange commentRange;
                if (o == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (PsiUtilCore.getElementType((PsiElement)o) == LiquidElementTypesGenerated.COMMENT && !(commentRange = LiquidFoldingBuilder.computeCommentRange(o)).isEmpty()) {
                    result.add(new FoldingDescriptor(o.getNode(), commentRange, null, LiquidFoldingBuilder.computeCommentPlaceholderText(o), Boolean.valueOf(false), Collections.emptySet()));
                }
                super.visitElement(o);
            }

            @Override
            public void visitBlock(@NotNull PsiLiquidBlock o) {
                TextRange blockRange;
                if (o == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (!(blockRange = TextRange.create((int)LiquidFoldingBuilder.computeStartOffset(o), (int)LiquidFoldingBuilder.computeEndOffset(o))).isEmpty()) {
                    result.add(new FoldingDescriptor(o.getNode(), blockRange, null, " ... ", Boolean.valueOf(false), Collections.emptySet()));
                }
                super.visitBlock(o);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "o";
                objectArray2[1] = "com/intellij/lang/liquid/codeInsight/editorActions/LiquidFoldingBuilder$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitElement";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitBlock";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        FoldingDescriptor[] foldingDescriptorArray = result.toArray(FoldingDescriptor.EMPTY_ARRAY);
        if (foldingDescriptorArray == null) {
            LiquidFoldingBuilder.$$$reportNull$$$0(2);
        }
        return foldingDescriptorArray;
    }

    public boolean isCollapsedByDefault(@NotNull ASTNode node) {
        if (node == null) {
            LiquidFoldingBuilder.$$$reportNull$$$0(3);
        }
        return false;
    }

    @Nullable
    public String getPlaceholderText(@NotNull ASTNode node) {
        if (node == null) {
            LiquidFoldingBuilder.$$$reportNull$$$0(4);
        }
        return null;
    }

    @NotNull
    private static TextRange computeCommentRange(@NotNull PsiElement commentElement) {
        if (commentElement == null) {
            LiquidFoldingBuilder.$$$reportNull$$$0(5);
        }
        String commentElementText = commentElement.getText();
        int commentStart = commentElementText.indexOf("comment");
        TextRange commentTextRange = commentElement.getTextRange();
        if (commentStart < 0) {
            TextRange textRange = commentTextRange;
            if (textRange == null) {
                LiquidFoldingBuilder.$$$reportNull$$$0(6);
            }
            return textRange;
        }
        int startOffset = commentTextRange.getStartOffset() + commentStart + "comment".length();
        int endOffset = commentTextRange.getEndOffset();
        if (commentElementText.endsWith("%}")) {
            endOffset -= "%}".length();
        }
        TextRange textRange = TextRange.create((int)startOffset, (int)endOffset);
        if (textRange == null) {
            LiquidFoldingBuilder.$$$reportNull$$$0(7);
        }
        return textRange;
    }

    @NotNull
    private static String computeCommentPlaceholderText(@NotNull PsiElement o) {
        if (o == null) {
            LiquidFoldingBuilder.$$$reportNull$$$0(8);
        }
        String commentText = LiquidCommenter.getCommentText(o).trim();
        String string = " " + StringUtil.shortenTextWithEllipsis((String)commentText, (int)60, (int)0) + " ";
        if (string == null) {
            LiquidFoldingBuilder.$$$reportNull$$$0(9);
        }
        return string;
    }

    private static int computeStartOffset(@NotNull PsiLiquidBlock liquidBlock) {
        if (liquidBlock == null) {
            LiquidFoldingBuilder.$$$reportNull$$$0(10);
        }
        PsiLiquidTag openingTag = liquidBlock.getOpeningTag();
        TextRange openingTagTextRange = openingTag.getTextRange();
        if (openingTag.hasVisibleTagOpener()) {
            PsiElement openingTagCloseBrace = openingTag.getTagCloser();
            int endOffset = openingTagCloseBrace == null ? openingTagTextRange.getEndOffset() : openingTagCloseBrace.getTextOffset();
            return CharArrayUtil.shiftBackward((CharSequence)liquidBlock.getContainingFile().getNode().getChars(), (int)(endOffset - 1), (String)" \n") + 1;
        }
        return openingTagTextRange.getEndOffset();
    }

    private static int computeEndOffset(@NotNull PsiLiquidBlock liquidBlock) {
        PsiLiquidTag closingTag;
        if (liquidBlock == null) {
            LiquidFoldingBuilder.$$$reportNull$$$0(11);
        }
        if ((closingTag = liquidBlock.getClosingTag()) == null) {
            return liquidBlock.getTextRange().getEndOffset();
        }
        TextRange closingTagTextRange = closingTag.getTextRange();
        if (!closingTag.hasVisibleTagOpener()) {
            return closingTagTextRange.getStartOffset();
        }
        PsiElement closingTagCloseBrace = closingTag.getTagCloser();
        return closingTagCloseBrace == null ? closingTagTextRange.getEndOffset() : closingTagCloseBrace.getTextOffset();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 6, 7, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/liquid/codeInsight/editorActions/LiquidFoldingBuilder";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commentElement";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "liquidBlock";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/liquid/codeInsight/editorActions/LiquidFoldingBuilder";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFoldRegions";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "computeCommentRange";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "computeCommentPlaceholderText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildFoldRegions";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 9: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isCollapsedByDefault";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPlaceholderText";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "computeCommentRange";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "computeCommentPlaceholderText";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "computeStartOffset";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "computeEndOffset";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 6, 7, 9 -> new IllegalStateException(string);
        };
    }
}

