/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.liquid.codeInsight.editorActions;

import com.intellij.codeInsight.generation.CommenterDataHolder;
import com.intellij.codeInsight.generation.SelfManagingCommenter;
import com.intellij.codeInsight.generation.SelfManagingCommenterUtil;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.lang.Commenter;
import com.intellij.lang.liquid.LiquidBundle;
import com.intellij.lang.liquid.LiquidLanguage;
import com.intellij.lang.liquid.psi.LiquidPsiUtil;
import com.intellij.lang.liquid.psi.LiquidSyntax;
import com.intellij.lang.liquid.psi.tree.LiquidElementTypes;
import com.intellij.lang.liquid.psi.tree.LiquidElementTypesGenerated;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.text.CharArrayUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

public final class LiquidCommenter
implements Commenter,
SelfManagingCommenter<DataHolder> {
    private static final Logger LOG = Logger.getInstance(LiquidCommenter.class);
    private static final String COMMENT_OPENER = String.join((CharSequence)" ", "{%", "comment", "%}");
    private static final String COMMENT_CLOSER = String.join((CharSequence)" ", "{%", "endcomment", "%}");
    private static final Pattern COMMENT_OPENER_PATTERN = Pattern.compile(LiquidSyntax.TAG_OPENER_PATTERN + "comment" + LiquidSyntax.TAG_CLOSER_PATTERN);
    private static final Pattern COMMENT_CLOSER_PATTERN = Pattern.compile(LiquidSyntax.TAG_OPENER_PATTERN + "endcomment" + LiquidSyntax.TAG_CLOSER_PATTERN);
    private static final Pattern COMMENT_CONTENT_PATTERN = Pattern.compile("^(\\s*)" + String.valueOf(COMMENT_OPENER_PATTERN) + "(.*?)(?:" + String.valueOf(COMMENT_CLOSER_PATTERN) + ")?(\\s*)$", 32);
    private static final Pattern LINE_COMMENT_CONTENT_PATTERN = Pattern.compile("^(\\s*)" + String.valueOf(COMMENT_OPENER_PATTERN) + "(.*?)" + String.valueOf(COMMENT_CLOSER_PATTERN) + "(\\s*)$", 32);

    @Nullable
    public String getLineCommentPrefix() {
        return this.getBlockCommentPrefix();
    }

    @Nullable
    public String getBlockCommentPrefix() {
        return COMMENT_OPENER;
    }

    @NotNull
    public String getBlockCommentSuffix() {
        String string = COMMENT_CLOSER;
        if (string == null) {
            LiquidCommenter.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nullable
    public String getCommentedBlockCommentPrefix() {
        return this.getBlockCommentPrefix();
    }

    @Nullable
    public String getCommentedBlockCommentSuffix() {
        return this.getBlockCommentSuffix();
    }

    @Nullable
    public DataHolder createLineCommentingState(int startLine, int endLine, @NotNull Document document, @NotNull PsiFile file) {
        if (document == null) {
            LiquidCommenter.$$$reportNull$$$0(1);
        }
        if (file == null) {
            LiquidCommenter.$$$reportNull$$$0(2);
        }
        return new DataHolder(file);
    }

    @Nullable
    public DataHolder createBlockCommentingState(int selectionStart, int selectionEnd, @NotNull Document document, @NotNull PsiFile file) {
        if (document == null) {
            LiquidCommenter.$$$reportNull$$$0(3);
        }
        if (file == null) {
            LiquidCommenter.$$$reportNull$$$0(4);
        }
        return new DataHolder(file);
    }

    public void commentLine(int line, int offset, @NotNull Document document, @NotNull DataHolder data) {
        if (document == null) {
            LiquidCommenter.$$$reportNull$$$0(5);
        }
        if (data == null) {
            LiquidCommenter.$$$reportNull$$$0(6);
        }
        int lineStartOffset = document.getLineStartOffset(line);
        int lineEndOffset = document.getLineEndOffset(line);
        CharSequence lineContent = document.getCharsSequence().subSequence(lineStartOffset, lineEndOffset);
        int contentStartOffset = lineStartOffset + CharArrayUtil.shiftForward((CharSequence)lineContent, (int)0, (String)" \t");
        int contentEndOffset = lineStartOffset + CharArrayUtil.shiftBackward((CharSequence)lineContent, (int)lineContent.length(), (String)" \t");
        FileViewProvider viewProvider = data.getFile().getViewProvider();
        if (!LiquidCommenter.isCommentableInTemplate(viewProvider.findElementAt(contentEndOffset, LiquidLanguage.getInstance())) || !LiquidCommenter.isCommentableInTemplate(viewProvider.findElementAt(contentStartOffset, LiquidLanguage.getInstance()))) {
            LiquidCommenter.tryToShowErrorHint(lineStartOffset, lineStartOffset, document, data, "editor.error.unable.comment.line");
            return;
        }
        document.insertString(contentEndOffset, (CharSequence)COMMENT_CLOSER);
        document.insertString(contentStartOffset, (CharSequence)COMMENT_OPENER);
    }

    @Contract(value="null -> false")
    private static boolean isCommentableInTemplate(@Nullable PsiElement psiElement) {
        IElementType elementType = PsiUtilCore.getElementType((PsiElement)psiElement);
        return elementType == LiquidElementTypes.LIQUID_TEMPLATE_BLOCK || elementType == LiquidElementTypesGenerated.TAG_OPENER || elementType == LiquidElementTypesGenerated.VALUE_OPENER || elementType == LiquidElementTypesGenerated.COMMENT && !LiquidPsiUtil.isInsideLiquidTag(psiElement);
    }

    public void uncommentLine(int line, int offset, @NotNull Document document, @NotNull DataHolder data) {
        if (document == null) {
            LiquidCommenter.$$$reportNull$$$0(7);
        }
        if (data == null) {
            LiquidCommenter.$$$reportNull$$$0(8);
        }
        LiquidCommenter.uncommentBlock(document, document.getLineStartOffset(line), document.getLineEndOffset(line));
    }

    private static void uncommentBlock(@NotNull Document document, int lineStartOffset, int lineEndOffset) {
        if (document == null) {
            LiquidCommenter.$$$reportNull$$$0(9);
        }
        if (lineEndOffset - lineStartOffset < LiquidCommenter.getMinimalCommentedLength()) {
            return;
        }
        CharSequence lineContent = document.getCharsSequence().subSequence(lineStartOffset, lineEndOffset);
        Matcher matcher = COMMENT_CONTENT_PATTERN.matcher(lineContent);
        if (!matcher.matches()) {
            LOG.warn("Trying to uncomment non-commented:" + String.valueOf(lineContent));
            return;
        }
        document.deleteString(lineStartOffset + matcher.end(2), lineStartOffset + matcher.start(3));
        document.deleteString(lineStartOffset + matcher.end(1), lineStartOffset + matcher.start(2));
    }

    public boolean isLineCommented(int line, int offset, @NotNull Document document, @NotNull DataHolder data) {
        if (document == null) {
            LiquidCommenter.$$$reportNull$$$0(10);
        }
        if (data == null) {
            LiquidCommenter.$$$reportNull$$$0(11);
        }
        int lineStartOffset = document.getLineStartOffset(line);
        int lineEndOffset = document.getLineEndOffset(line);
        if (lineEndOffset - lineStartOffset < LiquidCommenter.getMinimalCommentedLength()) {
            return false;
        }
        return LINE_COMMENT_CONTENT_PATTERN.matcher(document.getCharsSequence().subSequence(lineStartOffset, lineEndOffset)).matches();
    }

    private static int getMinimalCommentedLength() {
        return "comment".length() + "endcomment".length();
    }

    @Nullable
    public String getCommentPrefix(int line, @NotNull Document document, @NotNull DataHolder data) {
        if (document == null) {
            LiquidCommenter.$$$reportNull$$$0(12);
        }
        if (data == null) {
            LiquidCommenter.$$$reportNull$$$0(13);
        }
        return this.getLineCommentPrefix();
    }

    @Nullable
    public TextRange getBlockCommentRange(int selectionStart, int selectionEnd, @NotNull Document document, @NotNull DataHolder data) {
        if (document == null) {
            LiquidCommenter.$$$reportNull$$$0(14);
        }
        if (data == null) {
            LiquidCommenter.$$$reportNull$$$0(15);
        }
        CharSequence sequence = document.getCharsSequence();
        selectionStart = CharArrayUtil.shiftForward((CharSequence)sequence, (int)selectionStart, (String)" \t\n");
        FileViewProvider fileViewProvider = data.getFile().getViewProvider();
        PsiElement commentElement = fileViewProvider.findElementAt(selectionStart, LiquidLanguage.getInstance());
        if (PsiUtilCore.getElementType((PsiElement)commentElement) != LiquidElementTypesGenerated.COMMENT) {
            return null;
        }
        if (commentElement != fileViewProvider.findElementAt(CharArrayUtil.shiftBackward((CharSequence)sequence, (int)(selectionEnd - 1), (String)" \t\n"))) {
            return null;
        }
        TextRange commentTextRange = commentElement.getTextRange();
        CharSequence commentChars = commentElement.getNode().getChars();
        if (LiquidCommenter.isBlockCommentInLiquidTag(commentChars) || COMMENT_CONTENT_PATTERN.matcher(commentTextRange.subSequence(sequence)).matches()) {
            return TextRange.create((int)commentTextRange.getStartOffset(), (int)commentTextRange.getEndOffset());
        }
        return null;
    }

    private static boolean isBlockCommentInLiquidTag(CharSequence commentChars) {
        return StringUtil.startsWith((CharSequence)commentChars, (CharSequence)"comment") && StringUtil.endsWith((CharSequence)commentChars, (CharSequence)"endcomment");
    }

    @Nullable
    public String getBlockCommentPrefix(int selectionStart, @NotNull Document document, @NotNull DataHolder data) {
        if (document == null) {
            LiquidCommenter.$$$reportNull$$$0(16);
        }
        if (data == null) {
            LiquidCommenter.$$$reportNull$$$0(17);
        }
        return this.getBlockCommentPrefix();
    }

    @Nullable
    public String getBlockCommentSuffix(int selectionEnd, @NotNull Document document, @NotNull DataHolder data) {
        if (document == null) {
            LiquidCommenter.$$$reportNull$$$0(18);
        }
        if (data == null) {
            LiquidCommenter.$$$reportNull$$$0(19);
        }
        return this.getBlockCommentSuffix();
    }

    public void uncommentBlockComment(int startOffset, int endOffset, Document document, DataHolder data) {
        CharSequence commentSequence = document.getCharsSequence().subSequence(startOffset, endOffset);
        if (LiquidCommenter.isBlockCommentInLiquidTag(commentSequence)) {
            LiquidCommenter.removeLineOrPrefix(document, endOffset, "endcomment", false);
            LiquidCommenter.removeLineOrPrefix(document, startOffset, "comment", true);
        } else {
            LiquidCommenter.uncommentBlock(document, startOffset, endOffset);
        }
    }

    private static void removeLineOrPrefix(Document document, int offset, String tagToRemove, boolean mayHaveTextBeforeOffset) {
        int lineNumber = document.getLineNumber(offset);
        int lineStartOffset = document.getLineStartOffset(lineNumber);
        int lineEndOffset = document.getLineEndOffset(lineNumber);
        CharSequence documentCharsSequence = document.getCharsSequence();
        CharSequence lineContent = documentCharsSequence.subSequence(lineStartOffset, lineEndOffset);
        String trimmedLineContent = lineContent.toString().trim();
        if (tagToRemove.equals(trimmedLineContent)) {
            document.deleteString(lineStartOffset - 1, lineEndOffset);
        } else if (!mayHaveTextBeforeOffset) {
            LOG.assertTrue(trimmedLineContent.startsWith(tagToRemove), (Object)("Wrong formatted comment" + trimmedLineContent));
            int tagStartOffset = CharArrayUtil.shiftForward((CharSequence)documentCharsSequence, (int)lineStartOffset, (String)" \t");
            document.deleteString(tagStartOffset, tagStartOffset + tagToRemove.length());
        } else {
            int tagStartOffset = CharArrayUtil.shiftForward((CharSequence)documentCharsSequence, (int)offset, (String)" \t");
            LOG.assertTrue(StringUtil.startsWith((CharSequence)documentCharsSequence, (int)tagStartOffset, (CharSequence)tagToRemove), (Object)("Wrong formatted comment with prefix: " + String.valueOf(lineContent) + "; offset offset in line: " + (offset - lineStartOffset)));
            document.deleteString(tagStartOffset, tagStartOffset + tagToRemove.length());
        }
    }

    @Nullable
    public TextRange insertBlockComment(int startOffset, int endOffset, Document document, DataHolder data) {
        FileViewProvider viewProvider = data.getFile().getViewProvider();
        PsiElement startingElement = viewProvider.findElementAt(startOffset, LiquidLanguage.getInstance());
        PsiElement endingElement = viewProvider.findElementAt(endOffset, LiquidLanguage.getInstance());
        if (LiquidCommenter.isCommentableInTemplate(startingElement) && LiquidCommenter.isCommentableInTemplate(endingElement)) {
            return SelfManagingCommenterUtil.insertBlockComment((int)startOffset, (int)endOffset, (Document)document, (String)COMMENT_OPENER, (String)COMMENT_CLOSER);
        }
        TextRange range = LiquidCommenter.tryToCommentInLiquidBlock(startingElement, endingElement, document, startOffset, endOffset);
        if (range == null) {
            LiquidCommenter.tryToShowErrorHint(startOffset, endOffset, document, data, "editor.error.unable.comment.range");
        }
        return range;
    }

    private static void tryToShowErrorHint(int startOffset, int endOffset, @NotNull Document document, @NotNull DataHolder data, @NotNull @PropertyKey(resourceBundle="messages.LiquidBundle") @NotNull @PropertyKey(resourceBundle="messages.LiquidBundle") String errorMessageKey) {
        if (document == null) {
            LiquidCommenter.$$$reportNull$$$0(20);
        }
        if (data == null) {
            LiquidCommenter.$$$reportNull$$$0(21);
        }
        if (errorMessageKey == null) {
            LiquidCommenter.$$$reportNull$$$0(22);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        Editor editor = FileEditorManager.getInstance((Project)data.getFile().getProject()).getSelectedTextEditor();
        if (editor != null && editor.getDocument() == document) {
            HintManager.getInstance().showErrorHint(editor, LiquidBundle.message(errorMessageKey, new Object[0]), startOffset, endOffset, (short)1, 33, 1500);
        }
    }

    @Contract(value="_,null,_,_,_->null;null,_,_,_,_->null")
    @Nullable
    private static TextRange tryToCommentInLiquidBlock(@Nullable PsiElement startingElement, @Nullable PsiElement endingElement, @NotNull Document document, int startOffset, int endOffset) {
        if (document == null) {
            LiquidCommenter.$$$reportNull$$$0(23);
        }
        if (startingElement == null || endingElement == null) {
            return null;
        }
        if (!LiquidPsiUtil.isInsideLiquidTag(startingElement) || !LiquidPsiUtil.isInsideLiquidTag(endingElement)) {
            return null;
        }
        CharSequence documentCharsSequence = document.getCharsSequence();
        int endInsertionOffset = LiquidCommenter.findNewLineOffsetAround(endOffset, documentCharsSequence);
        if (endInsertionOffset == -1) {
            return null;
        }
        int startInsertionOffset = LiquidCommenter.findNewLineOffsetAround(startOffset, documentCharsSequence);
        if (startInsertionOffset == -1) {
            return null;
        }
        CharSequence tabChars = LiquidCommenter.getSpacesAtOffset(startInsertionOffset + 1, documentCharsSequence);
        String tagPrefix = "\n" + String.valueOf(tabChars);
        String endInsertionString = tagPrefix + "endcomment";
        String startInsertionString = tagPrefix + "comment";
        document.insertString(endInsertionOffset, (CharSequence)endInsertionString);
        document.insertString(startInsertionOffset, (CharSequence)startInsertionString);
        return TextRange.create((int)(startInsertionOffset + tagPrefix.length()), (int)(endInsertionOffset + startInsertionString.length() + endInsertionString.length()));
    }

    private static CharSequence getSpacesAtOffset(int offset, @NotNull CharSequence charSequence) {
        if (charSequence == null) {
            LiquidCommenter.$$$reportNull$$$0(24);
        }
        return charSequence.subSequence(offset, CharArrayUtil.shiftForward((CharSequence)charSequence, (int)offset, (String)" \t"));
    }

    private static int findNewLineOffsetAround(int offset, @NotNull CharSequence documentCharsSequence) {
        int maxOffset;
        if (documentCharsSequence == null) {
            LiquidCommenter.$$$reportNull$$$0(25);
        }
        if (documentCharsSequence.charAt(maxOffset = CharArrayUtil.shiftForward((CharSequence)documentCharsSequence, (int)offset, (String)" \t")) == '\n') {
            return maxOffset;
        }
        int minOffset = CharArrayUtil.shiftBackward((CharSequence)documentCharsSequence, (int)(offset - 1), (String)" \t");
        if (minOffset > 0 && documentCharsSequence.charAt(minOffset) == '\n') {
            return minOffset;
        }
        return -1;
    }

    @NotNull
    public static String getCommentText(@NotNull PsiElement element) {
        String elementText;
        if (element == null) {
            LiquidCommenter.$$$reportNull$$$0(26);
        }
        if ((elementText = element.getText()).startsWith("comment")) {
            int startOffset = "comment".length();
            int endOffset = elementText.endsWith("endcomment") ? elementText.length() - "endcomment".length() : elementText.length();
            String string = elementText.substring(startOffset, endOffset);
            if (string == null) {
                LiquidCommenter.$$$reportNull$$$0(27);
            }
            return string;
        }
        Matcher matcher = COMMENT_CONTENT_PATTERN.matcher(elementText);
        if (!matcher.matches()) {
            LOG.warn("Unable to parse comment content: " + elementText);
            return "";
        }
        String string = matcher.group(2);
        if (string == null) {
            LiquidCommenter.$$$reportNull$$$0(28);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/liquid/codeInsight/editorActions/LiquidCommenter";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: 
            case 8: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorMessageKey";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charSequence";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "documentCharsSequence";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getBlockCommentSuffix";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/liquid/codeInsight/editorActions/LiquidCommenter";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommentText";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createLineCommentingState";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createBlockCommentingState";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "commentLine";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "uncommentLine";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "uncommentBlock";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isLineCommented";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getCommentPrefix";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getBlockCommentRange";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getBlockCommentPrefix";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getBlockCommentSuffix";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "tryToShowErrorHint";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "tryToCommentInLiquidBlock";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getSpacesAtOffset";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "findNewLineOffsetAround";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getCommentText";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26 -> new IllegalArgumentException(string);
        };
    }

    static final class DataHolder
    extends CommenterDataHolder {
        @NotNull
        private final PsiFile myFile;

        DataHolder(@NotNull PsiFile file) {
            if (file == null) {
                DataHolder.$$$reportNull$$$0(0);
            }
            this.myFile = file;
        }

        @NotNull
        PsiFile getFile() {
            PsiFile psiFile = this.myFile;
            if (psiFile == null) {
                DataHolder.$$$reportNull$$$0(1);
            }
            return psiFile;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/liquid/codeInsight/editorActions/LiquidCommenter$DataHolder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/liquid/codeInsight/editorActions/LiquidCommenter$DataHolder";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFile";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

