/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.microservices.url.inlay;

import com.intellij.codeInsight.hints.InlayPresentationFactory;
import com.intellij.codeInsight.hints.presentation.InlayPresentation;
import com.intellij.codeInsight.hints.presentation.InsetPresentation;
import com.intellij.codeInsight.hints.presentation.PresentationFactory;
import com.intellij.codeInsight.hints.presentation.ScaleAwarePresentationFactory;
import com.intellij.icons.AllIcons;
import com.intellij.microservices.url.UrlPath;
import com.intellij.microservices.url.inlay.FindUsagesUrlPathInlayAction;
import com.intellij.microservices.url.inlay.UrlPathInlayAction;
import com.intellij.microservices.url.inlay.UrlPathInlayHint;
import com.intellij.microservices.url.references.UrlPathContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.rails.microservices.url.RailsRouteUrlTargetInfo;
import org.jetbrains.plugins.ruby.rails.routes.RailsRoute;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;

public final class RailsUrlPathInlayHint
implements UrlPathInlayHint {
    public static final UrlPath.PathSegmentRenderer PATH_SEGMENT_RENDERER = new UrlPath.PathSegmentRenderer(){

        @NotNull
        public String visitUndefined() {
            return "\u2026";
        }

        @NotNull
        public String visitVariable(@NotNull UrlPath.PathSegment.Variable variable) {
            if (variable == null) {
                1.$$$reportNull$$$0(0);
            }
            String string = String.format(":%s", variable.getVariableName());
            if (string == null) {
                1.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variable";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/rails/microservices/url/inlay/RailsUrlPathInlayHint$1";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/rails/microservices/url/inlay/RailsUrlPathInlayHint$1";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "visitVariable";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "visitVariable";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    };
    private final RMethod myMethod;
    private final PsiElement myIdentifier;
    private final List<RailsRoute> myRoutes;

    public RailsUrlPathInlayHint(@NotNull RMethod method, @NotNull PsiElement identifier, @NotNull List<RailsRoute> routes) {
        if (method == null) {
            RailsUrlPathInlayHint.$$$reportNull$$$0(0);
        }
        if (identifier == null) {
            RailsUrlPathInlayHint.$$$reportNull$$$0(1);
        }
        if (routes == null) {
            RailsUrlPathInlayHint.$$$reportNull$$$0(2);
        }
        this.myMethod = method;
        this.myIdentifier = identifier;
        this.myRoutes = List.copyOf(routes);
    }

    @NotNull
    public SmartPsiElementPointer<PsiElement> getAttachedTo() {
        SmartPsiElementPointer smartPsiElementPointer = SmartPointerManager.createPointer((PsiElement)this.myIdentifier);
        if (smartPsiElementPointer == null) {
            RailsUrlPathInlayHint.$$$reportNull$$$0(3);
        }
        return smartPsiElementPointer;
    }

    @NotNull
    public List<UrlPathInlayAction> getAvailableActions(@NotNull PsiFile file) {
        if (file == null) {
            RailsUrlPathInlayHint.$$$reportNull$$$0(4);
        }
        List list = ContainerUtil.filter((Collection)super.getAvailableActions(file), it -> !(it instanceof FindUsagesUrlPathInlayAction));
        if (list == null) {
            RailsUrlPathInlayHint.$$$reportNull$$$0(5);
        }
        return list;
    }

    @NotNull
    public UrlPathContext getContext() {
        UrlPath path = Objects.requireNonNull((RailsRoute)ContainerUtil.find(this.myRoutes, it -> it.getPath() != null)).getPath();
        List methods = ContainerUtil.mapNotNull(this.myRoutes, it -> Objects.equals(it.getPath(), path) ? it.getVerb() : null);
        UrlPathContext urlPathContext = UrlPathContext.supportingSchemes(RailsRouteUrlTargetInfo.DEFAULT_SCHEMES).withPaths(ContainerUtil.createMaybeSingletonList((Object)((UrlPath)ObjectUtils.doIfNotNull((Object)path, it -> new UrlPath(it.getSegments()))))).withMethods((Collection)methods);
        if (urlPathContext == null) {
            RailsUrlPathInlayHint.$$$reportNull$$$0(6);
        }
        return urlPathContext;
    }

    public int getOffset() {
        return this.myMethod.getTextRange().getStartOffset();
    }

    @NotNull
    public InlayPresentation getPresentation(@NotNull Editor editor, @NotNull InlayPresentationFactory inlayPresentationFactory) {
        if (editor == null) {
            RailsUrlPathInlayHint.$$$reportNull$$$0(7);
        }
        if (inlayPresentationFactory == null) {
            RailsUrlPathInlayHint.$$$reportNull$$$0(8);
        }
        PresentationFactory factory = (PresentationFactory)inlayPresentationFactory;
        ScaleAwarePresentationFactory scaleAwareFactory = new ScaleAwarePresentationFactory(editor, factory);
        InlayPresentation iconPresentation = RailsUrlPathInlayHint.getIconPresentation(scaleAwareFactory);
        InlayPresentation pathPresentation = this.getPathPresentation(factory);
        InlayPresentation presentation = scaleAwareFactory.lineCentered(factory.seq(new InlayPresentation[]{iconPresentation, pathPresentation}));
        return this.getLineOffsetAwarePresentation(editor, factory, factory.roundWithBackground(presentation));
    }

    public int getPriority() {
        return 50;
    }

    @NotNull
    public List<RailsRoute> getRoutes() {
        List<RailsRoute> list = this.myRoutes;
        if (list == null) {
            RailsUrlPathInlayHint.$$$reportNull$$$0(9);
        }
        return list;
    }

    @NotNull
    public UrlPathInlayHint.Style getStyle() {
        UrlPathInlayHint.Style style = UrlPathInlayHint.Style.BLOCK;
        if (style == null) {
            RailsUrlPathInlayHint.$$$reportNull$$$0(10);
        }
        return style;
    }

    @NotNull
    private InlayPresentation getLineOffsetAwarePresentation(@NotNull Editor editor, @NotNull PresentationFactory factory, @NotNull InlayPresentation presentation) {
        if (editor == null) {
            RailsUrlPathInlayHint.$$$reportNull$$$0(11);
        }
        if (factory == null) {
            RailsUrlPathInlayHint.$$$reportNull$$$0(12);
        }
        if (presentation == null) {
            RailsUrlPathInlayHint.$$$reportNull$$$0(13);
        }
        Document document = editor.getDocument();
        int offset = this.getOffset();
        int startOffset = document.getLineStartOffset(document.getLineNumber(offset));
        int column = offset - startOffset;
        int width = EditorUtil.getPlainSpaceWidth((Editor)editor);
        InsetPresentation insetPresentation = factory.inset(presentation, column * width, 0, 0, 0);
        if (insetPresentation == null) {
            RailsUrlPathInlayHint.$$$reportNull$$$0(14);
        }
        return insetPresentation;
    }

    @NotNull
    private InlayPresentation getPathPresentation(@NotNull PresentationFactory factory) {
        if (factory == null) {
            RailsUrlPathInlayHint.$$$reportNull$$$0(15);
        }
        LinkedHashSet paths = new LinkedHashSet(ContainerUtil.mapNotNull(this.myRoutes, RailsRoute::getPath));
        UrlPath path = Objects.requireNonNull((UrlPath)ContainerUtil.getFirstItem(paths));
        InlayPresentation inlayPresentation = factory.smallTextWithoutBackground(" /" + path.getPresentation(PATH_SEGMENT_RENDERER) + (paths.size() > 1 ? ", \u2026" : ""));
        if (inlayPresentation == null) {
            RailsUrlPathInlayHint.$$$reportNull$$$0(16);
        }
        return inlayPresentation;
    }

    @NotNull
    private static InlayPresentation getIconPresentation(@NotNull ScaleAwarePresentationFactory factory) {
        if (factory == null) {
            RailsUrlPathInlayHint.$$$reportNull$$$0(17);
        }
        InlayPresentation inlayPresentation = factory.icon(AllIcons.Actions.InlayGlobe, "InlayGlobe", 1);
        if (inlayPresentation == null) {
            RailsUrlPathInlayHint.$$$reportNull$$$0(18);
        }
        return inlayPresentation;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5, 6, 9, 10, 14, 16, 18 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "routes";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 14: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/microservices/url/inlay/RailsUrlPathInlayHint";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inlayPresentationFactory";
                break;
            }
            case 12: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/microservices/url/inlay/RailsUrlPathInlayHint";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttachedTo";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableActions";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getContext";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoutes";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getStyle";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getLineOffsetAwarePresentation";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathPresentation";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getIconPresentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 14: 
            case 16: 
            case 18: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getAvailableActions";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getPresentation";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getLineOffsetAwarePresentation";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getPathPresentation";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getIconPresentation";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 5, 6, 9, 10, 14, 16, 18 -> new IllegalStateException(string);
        };
    }
}

