/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.microservices.url;

import com.intellij.microservices.url.HttpUrlResolver;
import com.intellij.microservices.url.UrlPath;
import com.intellij.microservices.url.UrlResolveRequest;
import com.intellij.microservices.url.UrlTargetInfo;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.rails.microservices.url.RailsRouteUrlTargetInfo;
import org.jetbrains.plugins.ruby.rails.routes.RoutesParser;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0011\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/plugins/ruby/rails/microservices/url/RailsRouteUrlResolver;", "Lcom/intellij/microservices/url/HttpUrlResolver;", "myProject", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getVariants", "", "Lcom/intellij/microservices/url/UrlTargetInfo;", "resolve", "request", "Lcom/intellij/microservices/url/UrlResolveRequest;", "intellij.ruby.rails.microservices"})
@SourceDebugExtension(value={"SMAP\nRailsRouteUrlResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RailsRouteUrlResolver.kt\norg/jetbrains/plugins/ruby/rails/microservices/url/RailsRouteUrlResolver\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,26:1\n774#2:27\n865#2,2:28\n*S KotlinDebug\n*F\n+ 1 RailsRouteUrlResolver.kt\norg/jetbrains/plugins/ruby/rails/microservices/url/RailsRouteUrlResolver\n*L\n21#1:27\n21#1:28,2\n*E\n"})
public final class RailsRouteUrlResolver
extends HttpUrlResolver {
    @NotNull
    private final Project myProject;

    public RailsRouteUrlResolver(@NotNull Project myProject) {
        Intrinsics.checkNotNullParameter((Object)myProject, (String)"myProject");
        this.myProject = myProject;
    }

    @NotNull
    public Iterable<UrlTargetInfo> getVariants() {
        Module[] moduleArray = RModuleUtil.getInstance().getAllModulesWithRubySupport(this.myProject);
        Intrinsics.checkNotNullExpressionValue((Object)moduleArray, (String)"getAllModulesWithRubySupport(...)");
        return SequencesKt.asIterable((Sequence)SequencesKt.flatMapIterable((Sequence)SequencesKt.map((Sequence)ArraysKt.asSequence((Object[])moduleArray), RailsRouteUrlResolver::getVariants$lambda$0), RailsRouteUrlResolver::getVariants$lambda$1));
    }

    @NotNull
    public Iterable<UrlTargetInfo> resolve(@NotNull UrlResolveRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return SequencesKt.asIterable((Sequence)SequencesKt.flatMapIterable((Sequence)UrlPath.Companion.combinations(request.getPath()), arg_0 -> RailsRouteUrlResolver.resolve$lambda$3(this, request, arg_0)));
    }

    private static final RoutesParser getVariants$lambda$0(Module it) {
        return RoutesParser.getInstance((Module)it);
    }

    private static final Iterable getVariants$lambda$1(RoutesParser it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Collection<RailsRouteUrlTargetInfo> collection = RailsRouteUrlTargetInfo.createFromRoutes(it.getRoutes());
        Intrinsics.checkNotNullExpressionValue(collection, (String)"createFromRoutes(...)");
        return collection;
    }

    /*
     * WARNING - void declaration
     */
    private static final Iterable resolve$lambda$3(RailsRouteUrlResolver this$0, UrlResolveRequest $request, UrlPath urlPath) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)urlPath, (String)"urlPath");
        Iterable<UrlTargetInfo> $this$filter$iv = this$0.getVariants();
        boolean $i$f$filter = false;
        Iterable<UrlTargetInfo> iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            UrlTargetInfo it = (UrlTargetInfo)element$iv$iv;
            boolean bl = false;
            if (!(($request.getMethod() == null || CollectionsKt.contains((Iterable)it.getMethods(), (Object)$request.getMethod())) && it.getPath().isCompatibleWith(urlPath))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }
}

