/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ruby.frontend.ruby;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.rd.ide.model.HighlighterModel;
import com.jetbrains.rdclient.daemon.FrontendHighlighterSuppressionHandler;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.ruby.lang.RubyFileType;
import org.jetbrains.plugins.ruby.ruby.lang.highlighter.RubyHighlighter;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u001c\u0010\u0004\u001a\u0010\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/ruby/frontend/ruby/RubyFrontendHighlighterSuppressionHandler;", "Lcom/jetbrains/rdclient/daemon/FrontendHighlighterSuppressionHandler;", "<init>", "()V", "NON_SUPPRESSED", "", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "kotlin.jvm.PlatformType", "shouldSuppress", "", "highlighterModel", "Lcom/jetbrains/rd/ide/model/HighlighterModel;", "document", "Lcom/intellij/openapi/editor/Document;", "intellij.ruby.frontend.split"})
@SourceDebugExtension(value={"SMAP\nRubyFrontendHighlighterSuppressionHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RubyFrontendHighlighterSuppressionHandler.kt\ncom/intellij/ruby/frontend/ruby/RubyFrontendHighlighterSuppressionHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,33:1\n1761#2,3:34\n*S KotlinDebug\n*F\n+ 1 RubyFrontendHighlighterSuppressionHandler.kt\ncom/intellij/ruby/frontend/ruby/RubyFrontendHighlighterSuppressionHandler\n*L\n24#1:34,3\n*E\n"})
public final class RubyFrontendHighlighterSuppressionHandler
implements FrontendHighlighterSuppressionHandler {
    @NotNull
    private final Set<TextAttributesKey> NON_SUPPRESSED;

    public RubyFrontendHighlighterSuppressionHandler() {
        Object[] objectArray = new TextAttributesKey[]{RubyHighlighter.HASH_KEY, RubyHighlighter.CONSTANT_DECLARATION, RubyHighlighter.METHOD_NAME, RubyHighlighter.PARAMETER, RubyHighlighter.LOCAL_VARIABLE, RubyHighlighter.RUBY_SPECIFIC_CALL, RubyHighlighter.RUBY_PARAMDEF_CALL};
        this.NON_SUPPRESSED = SetsKt.setOf((Object[])objectArray);
    }

    public boolean shouldSuppress(@NotNull HighlighterModel highlighterModel, @NotNull Document document) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)highlighterModel, (String)"highlighterModel");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document);
        if (virtualFile == null) {
            return false;
        }
        VirtualFile vFile = virtualFile;
        if (!Intrinsics.areEqual((Object)vFile.getFileType(), (Object)RubyFileType.RUBY)) {
            return false;
        }
        String attributeId = highlighterModel.getProperties().getAttributeId();
        if (StringsKt.startsWith$default((String)attributeId, (String)"IJ.RUBY_", (boolean)false, (int)2, null)) {
            boolean bl;
            block8: {
                Iterable $this$any$iv = this.NON_SUPPRESSED;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        TextAttributesKey it = (TextAttributesKey)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)it.getExternalName(), (Object)StringsKt.substringAfter$default((String)attributeId, (String)"IJ.", null, (int)2, null))) continue;
                        bl = true;
                        break block8;
                    }
                    bl = false;
                }
            }
            if (!bl) {
                return true;
            }
        }
        if ((object = highlighterModel.getTextAttributesKey()) == null || (object = object.getExternalName()) == null) {
            return false;
        }
        Object attributeName = object;
        return Intrinsics.areEqual((Object)attributeName, (Object)CodeInsightColors.MATCHED_BRACE_ATTRIBUTES.getExternalName()) || Intrinsics.areEqual((Object)attributeName, (Object)CodeInsightColors.UNMATCHED_BRACE_ATTRIBUTES.getExternalName());
    }
}

