/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.css;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.css.resolve.CssInclusionContext;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceHelper;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceHelperRegistrar;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.rails.codeInsight.sprockets.SprocketsUtil;
import org.jetbrains.plugins.ruby.rails.model.RailsApp;

final class RailsInclusionContext
extends CssInclusionContext {
    RailsInclusionContext() {
    }

    public PsiFile @NotNull [] getContextFiles(@NotNull PsiFile current) {
        RailsApp app;
        if (current == null) {
            RailsInclusionContext.$$$reportNull$$$0(0);
        }
        if ((app = RailsApp.fromPsiElement((PsiElement)current)) == null) {
            if (PsiFile.EMPTY_ARRAY == null) {
                RailsInclusionContext.$$$reportNull$$$0(1);
            }
            return PsiFile.EMPTY_ARRAY;
        }
        Collection<PsiFileSystemItem> contexts = RailsInclusionContext.getContexts(current);
        HashSet files = new HashSet();
        for (PsiFileSystemItem context : contexts) {
            VirtualFile stylesheets;
            VirtualFile virtualFile = context.getVirtualFile();
            if (virtualFile == null || (stylesheets = virtualFile.findChild("stylesheets")) == null) continue;
            ModuleRootManager manager = ModuleRootManager.getInstance((Module)app.getModule());
            PsiManager psiManager = current.getManager();
            manager.getFileIndex().iterateContentUnderDirectory(stylesheets, fileOrDir -> {
                PsiFile psiFile = psiManager.findFile(fileOrDir);
                if (psiFile != null && SprocketsUtil.isStylesheet((PsiElement)psiFile)) {
                    files.add(psiFile);
                }
                return true;
            });
        }
        PsiFile[] psiFileArray = files.isEmpty() ? PsiFile.EMPTY_ARRAY : files.toArray(PsiFile.EMPTY_ARRAY);
        if (psiFileArray == null) {
            RailsInclusionContext.$$$reportNull$$$0(2);
        }
        return psiFileArray;
    }

    private static Collection<PsiFileSystemItem> getContexts(@NotNull PsiFile file) {
        VirtualFile virtualFile;
        if (file == null) {
            RailsInclusionContext.$$$reportNull$$$0(3);
        }
        if ((virtualFile = file.getOriginalFile().getVirtualFile()) != null) {
            PsiDirectory directory;
            FileReferenceHelper[] helpers = FileReferenceHelperRegistrar.getHelpers();
            ArrayList<PsiFileSystemItem> list = new ArrayList<PsiFileSystemItem>();
            Project project = file.getProject();
            for (FileReferenceHelper helper : helpers) {
                if (!helper.isMine(project, virtualFile)) continue;
                list.addAll(helper.getContexts(project, virtualFile));
            }
            if (!list.isEmpty()) {
                return list;
            }
            VirtualFile parent = virtualFile.getParent();
            if (parent != null && (directory = file.getManager().findDirectory(parent)) != null) {
                return Collections.singleton(directory);
            }
        }
        return Collections.emptyList();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "current";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/css/RailsInclusionContext";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/css/RailsInclusionContext";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getContextFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getContextFiles";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getContexts";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

