/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.templates;

import com.intellij.lang.Language;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RCompoundStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RExpression;
import org.jetbrains.plugins.ruby.templates.TemplateIntegration;

public final class TemplateIntegrationUtils {
    private static final TemplateIntegrationUtils INSTANCE = new TemplateIntegrationUtils();

    private TemplateIntegrationUtils() {
    }

    @Nullable
    public String getFileTemplateName(@NotNull String fileName) {
        FileType fileType;
        if (fileName == null) {
            TemplateIntegrationUtils.$$$reportNull$$$0(0);
        }
        if ((fileType = FileTypeRegistry.getInstance().getFileTypeByFileName(fileName)) == FileTypes.UNKNOWN) {
            return null;
        }
        for (TemplateIntegration integration : TemplateIntegration.EP_NAME.getExtensionList()) {
            if (integration.getFileType() != fileType) continue;
            return integration.getFileTemplateName();
        }
        return null;
    }

    public boolean isTemplateFile(@Nullable FileType type) {
        if (type == null) {
            return false;
        }
        for (TemplateIntegration integration : TemplateIntegration.EP_NAME.getExtensionList()) {
            if (!integration.getFileType().equals(type)) continue;
            return true;
        }
        return false;
    }

    public static boolean mustCloseRubyBlock(@NotNull PsiElement context) {
        PsiFile file;
        Language fileLanguage;
        if (context == null) {
            TemplateIntegrationUtils.$$$reportNull$$$0(1);
        }
        Language language = fileLanguage = (file = context.getContainingFile()) != null ? file.getLanguage() : null;
        if (fileLanguage != null) {
            for (TemplateIntegration integration : TemplateIntegration.EP_NAME.getExtensionList()) {
                if (!integration.getLanguage().equals(fileLanguage)) continue;
                return integration.mustCloseRubyBlock();
            }
        }
        return true;
    }

    @Nullable
    public PsiElement addRubyStatement(@NotNull FileViewProvider provider, @NotNull RCompoundStatement parent, @NotNull PsiElement elementToAdd, @Nullable PsiElement anchor, boolean before) {
        if (provider == null) {
            TemplateIntegrationUtils.$$$reportNull$$$0(2);
        }
        if (parent == null) {
            TemplateIntegrationUtils.$$$reportNull$$$0(3);
        }
        if (elementToAdd == null) {
            TemplateIntegrationUtils.$$$reportNull$$$0(4);
        }
        for (TemplateIntegration integration : TemplateIntegration.EP_NAME.getExtensionList()) {
            if (!integration.canModifyPsiInsert(provider)) continue;
            return integration.addRubyStatement(provider, parent, elementToAdd, anchor, before);
        }
        return null;
    }

    public FileType[] allKnownFileTypes(FileType ... defaultTypes) {
        HashSet types = ContainerUtil.newHashSet((Object[])defaultTypes);
        for (TemplateIntegration integration : TemplateIntegration.EP_NAME.getExtensionList()) {
            types.add(integration.getFileType());
        }
        return types.toArray(FileType.EMPTY_ARRAY);
    }

    @Nullable
    public String getTextForI18n(@NotNull Editor editor, @NotNull PsiFile file) {
        if (editor == null) {
            TemplateIntegrationUtils.$$$reportNull$$$0(5);
        }
        if (file == null) {
            TemplateIntegrationUtils.$$$reportNull$$$0(6);
        }
        for (TemplateIntegration integration : TemplateIntegration.EP_NAME.getExtensionList()) {
            String text = integration.getTextForI18n(editor, file);
            if (text == null) continue;
            return text;
        }
        return null;
    }

    public void replaceTextWithI18n(@NotNull Editor editor, @NotNull PsiFile file, @NotNull RExpression expression) {
        if (editor == null) {
            TemplateIntegrationUtils.$$$reportNull$$$0(7);
        }
        if (file == null) {
            TemplateIntegrationUtils.$$$reportNull$$$0(8);
        }
        if (expression == null) {
            TemplateIntegrationUtils.$$$reportNull$$$0(9);
        }
        for (TemplateIntegration integration : TemplateIntegration.EP_NAME.getExtensionList()) {
            if (!integration.replaceTextWithI18n(editor, file, expression)) continue;
            return;
        }
    }

    public static TemplateIntegrationUtils getInstance() {
        return INSTANCE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToAdd";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/templates/TemplateIntegrationUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getFileTemplateName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "mustCloseRubyBlock";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "addRubyStatement";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getTextForI18n";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "replaceTextWithI18n";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

