/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.presentation;

import com.intellij.icons.AllIcons;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.ui.LayeredIcon;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.lang.TextUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RArgumentList;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RSingletonMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.controlStructures.methods.RCommandArgumentListImpl;
import org.jetbrains.plugins.ruby.ruby.presentation.RContainerPresentationUtil;
import org.jetbrains.plugins.ruby.ruby.presentation.RContainerPresentationUtilCore;

public final class RMethodPresentationUtil {
    public static Icon getIcon(RMethod rMethod) {
        if (rMethod instanceof RSingletonMethod) {
            return RMethodPresentationUtil.createStaticIcon(AllIcons.Nodes.Method);
        }
        return AllIcons.Nodes.Method;
    }

    public static Icon createStaticIcon(Icon baseIcon) {
        return IconLoader.createLazy(() -> {
            LayeredIcon icon = new LayeredIcon(2);
            icon.setIcon(baseIcon, 0);
            icon.setIcon(AllIcons.Nodes.StaticMark, 1);
            return icon;
        });
    }

    public static Icon getIcon(RMethod rMethod, int flags) {
        if ((flags & 1) == 1) {
            return RContainerPresentationUtilCore.getIconWithModifiers((RContainer)rMethod);
        }
        return RMethodPresentationUtil.getIcon(rMethod);
    }

    @NotNull
    public static ItemPresentation getPresentation(final RMethod rMethod) {
        return new ItemPresentation(){

            public String getPresentableText() {
                return rMethod.getPresentableName(false);
            }

            public String getLocationString() {
                return TextUtil.wrapInParens(RContainerPresentationUtil.getLocation((RPsiElement)rMethod));
            }

            public Icon getIcon(boolean open) {
                return RMethodPresentationUtil.getIcon(rMethod, 1);
            }
        };
    }

    @NotNull
    @NlsSafe
    public static String formatName(@NotNull RMethod method, int options) {
        ItemPresentation presentation;
        RContainer parent;
        List argumentInfos;
        if (method == null) {
            RMethodPresentationUtil.$$$reportNull$$$0(0);
        }
        StringBuilder buffer = new StringBuilder();
        if ((options & 1) != 0) {
            buffer.append(method.getName());
        } else if ((options & 0x200) != 0) {
            buffer.append(RContainerPresentationUtil.getHumanizedFQN(method.getFQN()));
        }
        if ((options & 0x100) != 0 && !(argumentInfos = method.getArgumentInfos()).isEmpty()) {
            boolean includeDefaultValues;
            buffer.append("(");
            boolean bl = includeDefaultValues = (options & 0x80) != 0;
            if (includeDefaultValues) {
                RArgumentList argumentList = method.getArgumentList();
                assert (argumentList != null);
                buffer.append(argumentList.getPresentableName(true));
            } else {
                buffer.append(RCommandArgumentListImpl.getPresentableName(argumentInfos));
            }
            buffer.append(")");
        }
        if ((options & 0x1000) != 0 && (parent = method.getParentContainer()) instanceof RClass && (presentation = parent.getPresentation()) != null) {
            buffer.append(" ").append(RBundle.message((String)"text.fragment.of.class.name", (Object[])new Object[]{presentation.getPresentableText()}));
        }
        String string = buffer.toString();
        if (string == null) {
            RMethodPresentationUtil.$$$reportNull$$$0(1);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/presentation/RMethodPresentationUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/presentation/RMethodPresentationUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "formatName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "formatName";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

