/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.presentation;

import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.navigation.ItemPresentation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.LayeredIcon;
import icons.RubyIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.lang.TextUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RFieldHolder;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.fields.FieldType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.fields.RField;
import org.jetbrains.plugins.ruby.ruby.presentation.RContainerPresentationUtil;

public final class RFieldPresentationUtil {
    private RFieldPresentationUtil() {
    }

    public static Icon getIcon(@NotNull RField rField) {
        if (rField == null) {
            RFieldPresentationUtil.$$$reportNull$$$0(0);
        }
        return RFieldPresentationUtil.getIconByRField(rField);
    }

    public static Icon getIcon(@NotNull RField rField, int flags) {
        if (rField == null) {
            RFieldPresentationUtil.$$$reportNull$$$0(1);
        }
        if ((flags & 1) == 1) {
            return RFieldPresentationUtil.getIconByRField(rField);
        }
        return RubyIcons.Ruby.Nodes.Variable;
    }

    public static ItemPresentation getPresentation(@NotNull RField rField) {
        if (rField == null) {
            RFieldPresentationUtil.$$$reportNull$$$0(2);
        }
        Icon icon = RFieldPresentationUtil.getIcon(rField, 1);
        return new PresentationData(rField.getName(), TextUtil.wrapInParens(RFieldPresentationUtil.getLocation(rField)), icon, null);
    }

    @NotNull
    public static String getLocation(@NotNull RField field) {
        if (field == null) {
            RFieldPresentationUtil.$$$reportNull$$$0(3);
        }
        RMethod method = (RMethod)PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)field, RMethod.class);
        RFieldHolder holder = field.getHolder();
        assert (holder != null);
        if (PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)method, RFieldHolder.class) == holder) {
            holder = method;
        }
        String string = RContainerPresentationUtil.getContainerNameWithLocation((RContainer)holder, true);
        if (string == null) {
            RFieldPresentationUtil.$$$reportNull$$$0(4);
        }
        return string;
    }

    public static Icon getIconByRField(RField field) {
        return RFieldPresentationUtil.createIconForField(field.getFieldType());
    }

    public static Icon createIconForField(FieldType type) {
        Icon attrIcon = RFieldPresentationUtil.getIconType(type);
        if (attrIcon != null) {
            LayeredIcon icon = new LayeredIcon(2);
            icon.setIcon(RubyIcons.Ruby.Nodes.Variable, 0);
            icon.setIcon(attrIcon, 1);
            return icon;
        }
        return RubyIcons.Ruby.Nodes.Variable;
    }

    @Nullable
    private static Icon getIconType(FieldType type) {
        if (type == FieldType.CLASS_VARIABLE) {
            return AllIcons.Nodes.StaticMark;
        }
        return null;
    }

    public static String getFieldName(@NotNull RField field) {
        if (field == null) {
            RFieldPresentationUtil.$$$reportNull$$$0(5);
        }
        return field.getPrefix() + field.getName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rField";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/presentation/RFieldPresentationUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/presentation/RFieldPresentationUtil";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getIcon";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getPresentation";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getLocation";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getFieldName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

