/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.presentation;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.RElementWithFQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.PresentableLegacySymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.RubySymbolUtilService;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypes;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;

public final class RContainerPresentationUtil {
    private RContainerPresentationUtil() {
    }

    @NotNull
    @NlsSafe
    public static String getContainerNameWithLocation(@NotNull RContainer container, boolean includeFile) {
        if (container == null) {
            RContainerPresentationUtil.$$$reportNull$$$0(0);
        }
        if (container instanceof RFile) {
            String string = StringUtil.notNullize((String)((RFile)container).getPresentableLocation());
            if (string == null) {
                RContainerPresentationUtil.$$$reportNull$$$0(1);
            }
            return string;
        }
        FQN nesting = container.getFQNWithNesting();
        String humanized = nesting.getFullPath().contains("$$ANON") ? RContainerPresentationUtil.getPresentationForContainerInAnonymousStruct(container, nesting) : RContainerPresentationUtil.getHumanizedFQN(nesting);
        if (!includeFile) {
            String string = humanized;
            if (string == null) {
                RContainerPresentationUtil.$$$reportNull$$$0(2);
            }
            return string;
        }
        PsiFile file = container.getContainingFile();
        if (file instanceof RFile) {
            String fileLocation = StringUtil.notNullize((String)((RFile)file).getPresentableLocation());
            Object object = humanized.isEmpty() ? fileLocation : humanized + " in " + fileLocation;
            if (object == null) {
                RContainerPresentationUtil.$$$reportNull$$$0(3);
            }
            return object;
        }
        String string = humanized;
        if (string == null) {
            RContainerPresentationUtil.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public static String getHumanizedFQN(@NotNull FQN fqn, @Nullable Symbol anchorSymbol, @Nullable PsiElement anchorPsiElement) {
        if (fqn == null) {
            RContainerPresentationUtil.$$$reportNull$$$0(5);
        }
        if (fqn == FQN.INVALID) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        List fqnParts = fqn.asList();
        int lastNormalPart = -1;
        for (int i = fqnParts.size() - 1; i >= 0; --i) {
            if (((String)fqnParts.get(i)).startsWith("$$")) continue;
            lastNormalPart = i;
            break;
        }
        boolean isMethodFQN = fqn.getFullPath().contains(".");
        for (int i = 0; i < fqnParts.size(); ++i) {
            String fqnPart = (String)fqnParts.get(i);
            if (!(i <= 0 || fqnPart.contains("$$") && i >= lastNormalPart)) {
                sb.append(isMethodFQN && i + 1 == fqnParts.size() ? "." : "::");
            }
            if (fqnPart.contains("$$")) {
                String suffix;
                String entityName;
                if ("$$SINGLETON$$".equals(fqnPart)) {
                    entityName = "singleton class";
                    suffix = " of ";
                } else {
                    String string;
                    if (!fqnPart.startsWith("$$ANON")) continue;
                    String partialFQN = StringUtil.join(fqnParts.subList(0, i + 1), (String)"::");
                    while (anchorSymbol != null && !FQN.same((FQN)anchorSymbol.getFQNWithNesting(), (String)partialFQN)) {
                        anchorSymbol = anchorSymbol.getParentSymbol();
                    }
                    if (anchorSymbol instanceof PresentableLegacySymbol) {
                        PresentableLegacySymbol presentableLegacySymbol = (PresentableLegacySymbol)anchorSymbol;
                        string = presentableLegacySymbol.getPresentableName(anchorPsiElement);
                    } else {
                        string = "anonymous";
                    }
                    entityName = string;
                    suffix = " in ";
                }
                if (i < lastNormalPart) {
                    sb.append('<').append(entityName).append('>');
                    continue;
                }
                sb.insert(0, entityName + (i == 0 ? "" : suffix));
                continue;
            }
            sb.append(fqnPart);
        }
        String string = sb.toString();
        if (string == null) {
            RContainerPresentationUtil.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public static String getHumanizedFQN(@NotNull FQN fqn) {
        if (fqn == null) {
            RContainerPresentationUtil.$$$reportNull$$$0(7);
        }
        return RContainerPresentationUtil.getHumanizedFQN(fqn, null, null);
    }

    @NotNull
    public static String getLocation(@NotNull RPsiElement element) {
        RContainer container;
        if (element == null) {
            RContainerPresentationUtil.$$$reportNull$$$0(8);
        }
        if (!element.isValid()) {
            String string = RBundle.message((String)"ruby.presentation.invalid");
            if (string == null) {
                RContainerPresentationUtil.$$$reportNull$$$0(9);
            }
            return string;
        }
        RContainer rContainer = container = element instanceof RContainer ? (RContainer)element : element.getParentContainer();
        assert (container != null);
        String location = RContainerPresentationUtil.getContainerNameWithLocation(container, true);
        if (element instanceof RContainer) {
            int index = location.indexOf(" in ");
            if (index == -1) {
                String string = location;
                if (string == null) {
                    RContainerPresentationUtil.$$$reportNull$$$0(10);
                }
                return string;
            }
            String fqn = location.substring(0, index);
            int sepIndex = fqn.lastIndexOf(".");
            if (sepIndex != -1) {
                fqn = fqn.substring(0, sepIndex);
                String string = fqn + location.substring(index);
                if (string == null) {
                    RContainerPresentationUtil.$$$reportNull$$$0(11);
                }
                return string;
            }
            String string = location.substring(index + 4);
            if (string == null) {
                RContainerPresentationUtil.$$$reportNull$$$0(12);
            }
            return string;
        }
        String string = location;
        if (string == null) {
            RContainerPresentationUtil.$$$reportNull$$$0(13);
        }
        return string;
    }

    public static boolean isSelf(@NotNull FQN fqn) {
        if (fqn == null) {
            RContainerPresentationUtil.$$$reportNull$$$0(14);
        }
        return FQN.same((FQN)fqn, (String)RubyTokenTypes.kSELF.toString());
    }

    @Nullable
    public static String getPresentableSymbolName(@Nullable Symbol symbol, @Nullable PsiElement invocationPoint) {
        if (symbol != null) {
            return RContainerPresentationUtil.getHumanizedFQN(symbol.getFQNWithNesting(), symbol, invocationPoint);
        }
        return null;
    }

    @NotNull
    private static String getPresentationForContainerInAnonymousStruct(@NotNull RContainer container, @NotNull FQN nesting) {
        String last;
        Symbol symbol;
        if (container == null) {
            RContainerPresentationUtil.$$$reportNull$$$0(15);
        }
        if (nesting == null) {
            RContainerPresentationUtil.$$$reportNull$$$0(16);
        }
        String humanized = (symbol = RubySymbolUtilService.getInstance().getSymbolByContainer((RElementWithFQN)container)) != null ? ((last = Objects.requireNonNull((String)ContainerUtil.getLastItem((List)nesting.asList()))).contains("$$ANON") ? Objects.requireNonNull(RContainerPresentationUtil.getPresentableSymbolName(symbol, (PsiElement)container)) : String.format("%s in %s", symbol.getName(), RContainerPresentationUtil.getPresentableSymbolName(symbol.getParentSymbol(), (PsiElement)container))) : RContainerPresentationUtil.getHumanizedFQN(nesting);
        String string = humanized;
        if (string == null) {
            RContainerPresentationUtil.$$$reportNull$$$0(17);
        }
        return string;
    }

    public static String formatName(@NotNull RElementWithFQN classOrModule, int options) {
        if (classOrModule == null) {
            RContainerPresentationUtil.$$$reportNull$$$0(18);
        }
        if (!classOrModule.isValid()) {
            return RBundle.message((String)"ruby.presentation.invalid");
        }
        StringBuilder buffer = new StringBuilder();
        if ((options & 0x200) != 0) {
            buffer.append(RContainerPresentationUtil.getHumanizedFQN(classOrModule.getFQN()));
        } else if ((options & 1) != 0) {
            buffer.append(classOrModule.getName());
        }
        return buffer.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 6, 9, 10, 11, 12, 13, 17 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/presentation/RContainerPresentationUtil";
                break;
            }
            case 5: 
            case 7: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nesting";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classOrModule";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/presentation/RContainerPresentationUtil";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainerNameWithLocation";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getHumanizedFQN";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocation";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentationForContainerInAnonymousStruct";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getContainerNameWithLocation";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 17: {
                break;
            }
            case 5: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getHumanizedFQN";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getLocation";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isSelf";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getPresentationForContainerInAnonymousStruct";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "formatName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 6, 9, 10, 11, 12, 13, 17 -> new IllegalStateException(string);
        };
    }
}

