/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall;

import com.google.common.base.Charsets;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.util.containers.ContainerUtil;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Type;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RBlockCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.FQNCallType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyCallType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyCallTypeWithScopeContext;
import org.jetbrains.plugins.ruby.ruby.lang.psi.stubs.calls.RBlockCallStub;

public class AnonymousDefiningCallType
extends FQNCallType
implements RubyCallTypeWithScopeContext {
    @NlsSafe
    public static final String ANONYMOUS_FQN_START = "$$ANON";
    @NlsSafe
    public static final String ANONYMOUS_CLASS = "$C";
    @NlsSafe
    public static final String ANONYMOUS_MODULE = "$M";
    private static final Base64.Encoder ENCODER = Base64.getUrlEncoder().withoutPadding();

    public AnonymousDefiningCallType(@NotNull String commandName) {
        if (commandName == null) {
            AnonymousDefiningCallType.$$$reportNull$$$0(0);
        }
        super(commandName);
    }

    public boolean shouldIndex(@NotNull RBlockCallStub rBlockCallStub) {
        if (rBlockCallStub == null) {
            AnonymousDefiningCallType.$$$reportNull$$$0(1);
        }
        return true;
    }

    @Override
    @NotNull
    public List<FQN> getCallData(@NotNull RPossibleCall call) {
        if (call == null) {
            AnonymousDefiningCallType.$$$reportNull$$$0(2);
        }
        List<FQN> list = Collections.singletonList(FQN.Builder.fromString((String)this.getAnonymousClassName((RPsiElement)call)));
        if (list == null) {
            AnonymousDefiningCallType.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Override
    public boolean isCompatible(@NotNull RPossibleCall possibleCall) {
        if (possibleCall == null) {
            AnonymousDefiningCallType.$$$reportNull$$$0(4);
        }
        return true;
    }

    protected boolean isClass() {
        return true;
    }

    @NotNull
    private String getAnonymousClassName(@NotNull RPsiElement psi) {
        if (psi == null) {
            AnonymousDefiningCallType.$$$reportNull$$$0(5);
        }
        RPsiElement element = psi instanceof RBlockCall ? ((RBlockCall)psi).getCall() : psi;
        String string = String.format("%s%s%s$$", ANONYMOUS_FQN_START, this.isClass() ? ANONYMOUS_CLASS : ANONYMOUS_MODULE, ENCODER.encodeToString(Integer.toString(element.getTextRange().hashCode() << 15 ^ element.getText().hashCode()).getBytes(Charsets.US_ASCII)));
        if (string == null) {
            AnonymousDefiningCallType.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public FQN getScopeContext(@NotNull RPossibleCall call) {
        if (call == null) {
            AnonymousDefiningCallType.$$$reportNull$$$0(7);
        }
        FQN fQN = (FQN)ContainerUtil.getFirstItem((Collection)((Collection)call.getData(new RubyCallType[]{this})), (Object)FQN.INVALID);
        if (fQN == null) {
            AnonymousDefiningCallType.$$$reportNull$$$0(8);
        }
        return fQN;
    }

    @NotNull
    public FQN getScopeContext(@NotNull RBlockCallStub callStub) {
        if (callStub == null) {
            AnonymousDefiningCallType.$$$reportNull$$$0(9);
        }
        FQN fQN = (FQN)ContainerUtil.getFirstItem((Collection)((Collection)callStub.getCallData().getData((RubyCallType)this, new RubyCallType[0])), (Object)FQN.INVALID);
        if (fQN == null) {
            AnonymousDefiningCallType.$$$reportNull$$$0(10);
        }
        return fQN;
    }

    public static boolean isAnonymousFQN(@NotNull FQN fqn) {
        if (fqn == null) {
            AnonymousDefiningCallType.$$$reportNull$$$0(11);
        }
        return fqn.getShortName().startsWith(ANONYMOUS_FQN_START);
    }

    public static Type getFQNType(@NotNull FQN fqn) {
        if (fqn == null) {
            AnonymousDefiningCallType.$$$reportNull$$$0(12);
        }
        if (fqn.getShortName().startsWith("$$ANON$M")) {
            return Type.MODULE;
        }
        return Type.CLASS;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 6, 8, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rBlockCallStub";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/lang/psi/methodCall/AnonymousDefiningCallType";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "possibleCall";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callStub";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/lang/psi/methodCall/AnonymousDefiningCallType";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCallData";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnonymousClassName";
                break;
            }
            case 8: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getScopeContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "shouldIndex";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getCallData";
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 10: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isCompatible";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getAnonymousClassName";
                break;
            }
            case 7: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getScopeContext";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isAnonymousFQN";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getFQNType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 6, 8, 10 -> new IllegalStateException(string);
        };
    }
}

