/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang.psi.impl.references;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.RPossibleCallElementBase;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyCallType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyCallTypeRegistry;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.UnknownRubyCallType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RReference;
import org.jetbrains.plugins.ruby.ruby.lang.psi.stubs.impl.RReferenceStub;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RConstant;
import org.jetbrains.plugins.ruby.ruby.lang.psi.visitors.RubyElementVisitor;

public abstract class RReferenceBase
extends RPossibleCallElementBase<RReferenceStub>
implements RReference {
    public RReferenceBase(ASTNode astNode) {
        super(astNode);
    }

    public RReferenceBase(RReferenceStub stub, IElementType nodeType) {
        super(stub, nodeType);
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            RReferenceBase.$$$reportNull$$$0(0);
        }
        if (visitor instanceof RubyElementVisitor) {
            ((RubyElementVisitor)visitor).visitRReference((RReference)this);
            return;
        }
        super.accept(visitor);
    }

    @Nullable
    public RPsiElement getValue() {
        PsiElement delimiter = this.getDelimiter();
        if (delimiter == null) {
            return null;
        }
        for (PsiElement element = delimiter.getNextSibling(); element != null; element = element.getNextSibling()) {
            if (!(element instanceof RPsiElement)) continue;
            return (RPsiElement)element;
        }
        return null;
    }

    @Nullable
    public RPsiElement getReceiver() {
        PsiElement delimiter = this.getDelimiter();
        if (delimiter == null) {
            return null;
        }
        RPsiElement element = RubyPsiUtilCore.getChildByFilter((PsiElement)this, RPsiElement.class, 0);
        return element != null && RubyPsiUtilCore.isBefore((PsiElement)element, delimiter) ? element : null;
    }

    public abstract PsiElement getDelimiter();

    @NotNull
    public String getName() {
        RPsiElement value = this.getValue();
        return value != null ? value.getText() : "";
    }

    public boolean isConstructorLike() {
        RPsiElement value = this.getValue();
        if (value != null) {
            String text = value.getText();
            return "new".equals(text);
        }
        return false;
    }

    public boolean isCall() {
        RPossibleCall possibleCall;
        RPsiElement rPsiElement = this.getValue();
        return rPsiElement instanceof RPossibleCall && (possibleCall = (RPossibleCall)rPsiElement).isCall();
    }

    @Nullable
    public PsiElement getPsiCommand() {
        RPsiElement call = this.getValue();
        return !(call instanceof RPossibleCall) ? null : ((RPossibleCall)call).getPsiCommand();
    }

    @Nullable
    public String getCommand() {
        RPsiElement call = this.getValue();
        return !(call instanceof RPossibleCall) ? null : ((RPossibleCall)call).getCommand();
    }

    @Override
    @NotNull
    protected RubyCallType<?> computeCallType() {
        String command = this.getCommand();
        RubyCallType<?> rubyCallType = command != null ? RubyCallTypeRegistry.getInstance().getCallType(command, this) : UnknownRubyCallType.INSTANCE;
        if (rubyCallType == null) {
            RReferenceBase.$$$reportNull$$$0(1);
        }
        return rubyCallType;
    }

    @NotNull
    public List<RPsiElement> getArguments() {
        List<RPsiElement> list = Collections.emptyList();
        if (list == null) {
            RReferenceBase.$$$reportNull$$$0(2);
        }
        return list;
    }

    public static boolean doesResolveToConstant(@NotNull RReference reference) {
        RPsiElement value;
        if (reference == null) {
            RReferenceBase.$$$reportNull$$$0(3);
        }
        return (value = reference.getValue()) instanceof RConstant && ((RConstant)value).doesReferenceToConstant();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/lang/psi/impl/references/RReferenceBase";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/lang/psi/impl/references/RReferenceBase";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "computeCallType";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getArguments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doesResolveToConstant";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

