/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang.psi.impl.iterators;

import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rdoc.DocumentationSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.RNamespace;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RubyDocumentationSymbolsService;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.RStubBasedPsiElementBase;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RBlockCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RCodeBlock;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.CallTypeWithStructurePresentation;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyCallType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyCallTypeWithScopeContext;
import org.jetbrains.plugins.ruby.ruby.lang.psi.stubs.calls.RBlockCallStub;

public abstract class RBlockCallBase
extends RStubBasedPsiElementBase<RBlockCallStub>
implements RBlockCall,
StubBasedPsiElement<RBlockCallStub> {
    public RBlockCallBase(ASTNode astNode) {
        super(astNode);
    }

    public RBlockCallBase(RBlockCallStub stub, IElementType nodeType) {
        super(stub, nodeType);
    }

    public boolean isValidNamespace() {
        return this.getCallType() instanceof RubyCallTypeWithScopeContext;
    }

    @NotNull
    public FQN getFQN() {
        FQN fQN = this.isValidNamespace() ? ((RubyCallTypeWithScopeContext)this.getCallType()).getScopeContext((RPossibleCall)this) : FQN.INVALID;
        if (fQN == null) {
            RBlockCallBase.$$$reportNull$$$0(0);
        }
        return fQN;
    }

    @NotNull
    public FQN getFQNWithNesting() {
        RBlockCallStub stub = (RBlockCallStub)this.getGreenStub();
        if (stub != null) {
            FQN fQN = stub.getFQNWithNesting();
            if (fQN == null) {
                RBlockCallBase.$$$reportNull$$$0(1);
            }
            return fQN;
        }
        if (!this.isValid()) {
            FQN fQN = FQN.INVALID;
            if (fQN == null) {
                RBlockCallBase.$$$reportNull$$$0(2);
            }
            return fQN;
        }
        FQN fqn = this.getFQN();
        RNamespace namespace = RubyPsiUtilCore.getParentNamespace((PsiElement)this);
        if (namespace == null) {
            FQN fQN = fqn;
            if (fQN == null) {
                RBlockCallBase.$$$reportNull$$$0(3);
            }
            return fQN;
        }
        FQN fQN = FQN.Builder.concat((FQN)namespace.getFQNWithNesting(), (FQN)fqn);
        if (fQN == null) {
            RBlockCallBase.$$$reportNull$$$0(4);
        }
        return fQN;
    }

    @Override
    public ItemPresentation getPresentation() {
        RubyCallType<?> type = this.getCallType();
        if (type instanceof CallTypeWithStructurePresentation) {
            return ((CallTypeWithStructurePresentation)type).getPresentation((RPossibleCall)this);
        }
        return super.getPresentation();
    }

    @NotNull
    public RPossibleCall getCall() {
        RPossibleCall rPossibleCall = (RPossibleCall)PsiTreeUtil.getChildOfType((PsiElement)this, RPossibleCall.class);
        if (rPossibleCall == null) {
            RBlockCallBase.$$$reportNull$$$0(5);
        }
        return rPossibleCall;
    }

    @NotNull
    public RCodeBlock getBlock() {
        RCodeBlock rCodeBlock = (RCodeBlock)PsiTreeUtil.getStubChildOfType((PsiElement)this, RCodeBlock.class);
        if (rCodeBlock == null) {
            RBlockCallBase.$$$reportNull$$$0(6);
        }
        return rCodeBlock;
    }

    public RPsiElement getLoopBody() {
        return this.getBlock();
    }

    @Nullable
    public PsiElement getPsiCommand() {
        return this.getCall().getPsiCommand();
    }

    public String getCommand() {
        RBlockCallStub callStub = (RBlockCallStub)this.getGreenStub();
        if (callStub != null) {
            return callStub.getCommandName();
        }
        return this.getCall().getCommand();
    }

    @Nullable
    public RPsiElement getReceiver() {
        return this.getCall().getReceiver();
    }

    public boolean isCall() {
        return true;
    }

    @NotNull
    public List<RPsiElement> getArguments() {
        List list = this.getCall().getArguments();
        if (list == null) {
            RBlockCallBase.$$$reportNull$$$0(7);
        }
        return list;
    }

    @NotNull
    public RubyCallType<?> getCallType() {
        RBlockCallStub stub = (RBlockCallStub)this.getGreenStub();
        if (stub != null) {
            RubyCallType rubyCallType = stub.getCallData().getCallType();
            if (rubyCallType == null) {
                RBlockCallBase.$$$reportNull$$$0(8);
            }
            return rubyCallType;
        }
        RubyCallType rubyCallType = this.getCall().getCallType();
        if (rubyCallType == null) {
            RBlockCallBase.$$$reportNull$$$0(9);
        }
        return rubyCallType;
    }

    @NotNull
    public Map<String, DocumentationSymbol<?>> getDocumentationSymbols() {
        RBlockCallStub stub = (RBlockCallStub)this.getGreenStub();
        if (stub != null) {
            Map map = stub.getDocumentationSymbols();
            if (map == null) {
                RBlockCallBase.$$$reportNull$$$0(10);
            }
            return map;
        }
        Map map = (Map)CachedValuesManager.getCachedValue((PsiElement)this, () -> {
            if (!(this.getCallType() instanceof RubyCallTypeWithScopeContext)) {
                return new CachedValueProvider.Result(Collections.emptyMap(), new Object[]{this.getContainingFile()});
            }
            return new CachedValueProvider.Result((Object)RubyDocumentationSymbolsService.instance().collectDocumentationSymbols((PsiElement)this, this.getBlock().getCompoundStatement()), new Object[]{this.getContainingFile()});
        });
        if (map == null) {
            RBlockCallBase.$$$reportNull$$$0(11);
        }
        return map;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/plugins/ruby/ruby/lang/psi/impl/iterators/RBlockCallBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFQN";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFQNWithNesting";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCall";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getBlock";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getArguments";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getCallType";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocumentationSymbols";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

