/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang.psi.impl.holders.utils;

import com.intellij.openapi.util.Comparing;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypes;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiStructureElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;

public final class RContainerUtilCore {
    private RContainerUtilCore() {
    }

    @NotNull
    public static <T extends RPsiStructureElement> List<T> selectElementsByType(@NotNull List<? extends RPsiStructureElement> fullList, @NotNull Class<T> type) {
        if (fullList == null) {
            RContainerUtilCore.$$$reportNull$$$0(0);
        }
        if (type == null) {
            RContainerUtilCore.$$$reportNull$$$0(1);
        }
        ArrayList<RPsiStructureElement> list = new ArrayList<RPsiStructureElement>();
        for (RPsiStructureElement rPsiStructureElement : fullList) {
            if (!type.isInstance(rPsiStructureElement)) continue;
            list.add(rPsiStructureElement);
        }
        ArrayList<RPsiStructureElement> arrayList = list;
        if (arrayList == null) {
            RContainerUtilCore.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @Nullable
    public static RClass findClassByName(@NotNull RContainer container, @Nullable String className) {
        if (container == null) {
            RContainerUtilCore.$$$reportNull$$$0(3);
        }
        if (className == null) {
            return null;
        }
        String[] names = className.split(RubyTokenTypes.tCOLON2.toString());
        RContainer current = container;
        for (String name : names) {
            RContainer newCurrent = RContainerUtilCore.getContainerByName(current, name);
            current = newCurrent != null ? newCurrent : current;
        }
        return current instanceof RClass ? (RClass)current : null;
    }

    @Nullable
    public static RContainer getContainerByName(@NotNull RContainer container, @Nullable String name) {
        if (container == null) {
            RContainerUtilCore.$$$reportNull$$$0(4);
        }
        return RContainerUtilCore.getContainerByName(container, name, false);
    }

    @Nullable
    public static RContainer getContainerByName(@NotNull RContainer container, @Nullable String name, boolean recursive) {
        if (container == null) {
            RContainerUtilCore.$$$reportNull$$$0(5);
        }
        for (RContainer child : RContainerUtilCore.selectElementsByType(container.getStructureElements(), RContainer.class)) {
            RContainer nestedChild;
            if (Comparing.strEqual((String)child.getName(), (String)name, (boolean)true)) {
                return child;
            }
            if (!recursive || (nestedChild = RContainerUtilCore.getContainerByName(child, name, true)) == null) continue;
            return nestedChild;
        }
        return null;
    }

    @NotNull
    public static List<RContainer> getStructureElementsRecursively(@NotNull RContainer container) {
        if (container == null) {
            RContainerUtilCore.$$$reportNull$$$0(6);
        }
        ArrayList<RContainer> declarations = new ArrayList<RContainer>(List.of(container));
        for (RContainer child : ContainerUtil.filterIsInstance((Collection)container.getStructureElements(), RContainer.class)) {
            declarations.addAll(RContainerUtilCore.getStructureElementsRecursively(child));
        }
        List<RContainer> list = Collections.unmodifiableList(declarations);
        if (list == null) {
            RContainerUtilCore.$$$reportNull$$$0(7);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fullList";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/lang/psi/impl/holders/utils/RContainerUtilCore";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/lang/psi/impl/holders/utils/RContainerUtilCore";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "selectElementsByType";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getStructureElementsRecursively";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "selectElementsByType";
                break;
            }
            case 2: 
            case 7: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findClassByName";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getContainerByName";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getStructureElementsRecursively";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 7 -> new IllegalStateException(string);
        };
    }
}

