/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang.psi.impl.holders;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.CheckUtil;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rdoc.DocumentationSymbol;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RCompoundStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RConstantHolder;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RDocumentationSymbolsHolder;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RFieldHolder;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RMethodHolder;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RubyDocumentationSymbolsService;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.RFileNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.holders.RStubBasedContainerBase;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.holders.utils.RConstantHolderUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.holders.utils.RFieldHolderUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.holders.utils.RHolderUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.stubs.containers.RContainerStub;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RConstant;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.fields.RField;

public abstract class RFieldConstantContainerBase<Stub extends RContainerStub<?>>
extends RStubBasedContainerBase<Stub>
implements RContainer,
RFieldHolder,
RConstantHolder,
RMethodHolder,
RDocumentationSymbolsHolder {
    private static final Logger LOG = Logger.getInstance(RFieldConstantContainerBase.class);

    public RFieldConstantContainerBase(ASTNode astNode) {
        super(astNode);
    }

    protected RFieldConstantContainerBase(Stub stub, IElementType nodeType) {
        super(stub, nodeType);
    }

    @NotNull
    public final List<RConstant> getConstantDeclarations() {
        List list = (List)CachedValuesManager.getCachedValue((PsiElement)this, () -> CachedValueProvider.Result.create(RConstantHolderUtil.collectConstantDeclarations(this, this.getGreenStub()), (Object[])new Object[]{this}));
        if (list == null) {
            RFieldConstantContainerBase.$$$reportNull$$$0(0);
        }
        return list;
    }

    @NotNull
    public final List<RField> getFieldsDeclarations() {
        List list = (List)CachedValuesManager.getCachedValue((PsiElement)this, () -> CachedValueProvider.Result.create(RFieldHolderUtil.collectFieldDeclarations(this, this.getGreenStub()), (Object[])new Object[]{this}));
        if (list == null) {
            RFieldConstantContainerBase.$$$reportNull$$$0(1);
        }
        return list;
    }

    @NotNull
    public List<RMethod> getMethods() {
        List list = (List)CachedValuesManager.getCachedValue((PsiElement)this, () -> CachedValueProvider.Result.create(RHolderUtil.collectMethodDeclarations(this, this.getGreenStub()), (Object[])new Object[]{this}));
        if (list == null) {
            RFieldConstantContainerBase.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    public Map<String, DocumentationSymbol<?>> getDocumentationSymbols() {
        RContainerStub stub = (RContainerStub)this.getGreenStub();
        if (stub != null) {
            Map map = stub.getDocumentationSymbols();
            if (map == null) {
                RFieldConstantContainerBase.$$$reportNull$$$0(3);
            }
            return map;
        }
        Map map = (Map)CachedValuesManager.getCachedValue((PsiElement)this, () -> new CachedValueProvider.Result((Object)RubyDocumentationSymbolsService.instance().collectDocumentationSymbols((PsiElement)this, this.getCompoundStatement()), new Object[]{this.getContainingFile()}));
        if (map == null) {
            RFieldConstantContainerBase.$$$reportNull$$$0(4);
        }
        return map;
    }

    @Nullable
    public RMethod findMethodByName(String name) {
        for (RMethod method : this.getMethods()) {
            if (!StringUtil.equals((CharSequence)method.getName(), (CharSequence)name)) continue;
            return method;
        }
        return null;
    }

    public void delete() throws IncorrectOperationException {
        RFile rFile;
        ASTNode parentNode = this.getNode().getTreeParent();
        LOG.assertTrue(parentNode != null);
        CheckUtil.checkWritable((PsiElement)this);
        PsiElement parent = this.getParent();
        if (parent instanceof RCompoundStatement && (rFile = RFileNavigator.getByRCompoundStatement((RCompoundStatement)parent)) != null && parent.getChildren().length == 1) {
            rFile.delete();
            return;
        }
        ((CompositeElement)parentNode).deleteChildInternal(this.getNode());
    }

    @Override
    protected boolean isAlwaysConstant() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/plugins/ruby/ruby/lang/psi/impl/holders/RFieldConstantContainerBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getConstantDeclarations";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFieldsDeclarations";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethods";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocumentationSymbols";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

