/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang.psi.impl.controlStructures.methods;

import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.swing.Icon;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rdoc.yard.YARDParser;
import org.jetbrains.plugins.ruby.rdoc.yard.YARDTag;
import org.jetbrains.plugins.ruby.ruby.codeInsight.annotations.AnnotationsHelperCore;
import org.jetbrains.plugins.ruby.ruby.codeInsight.annotations.MethodAnnotationData;
import org.jetbrains.plugins.ruby.ruby.codeInsight.annotations.YARDMethodData;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.summary.Summary;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.summary.SummaryUtilService;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Type;
import org.jetbrains.plugins.ruby.ruby.lang.documentation.RubyCommentsUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypes;
import org.jetbrains.plugins.ruby.ruby.lang.parser.RubyElementTypes;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RFormatStructureElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RYieldStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RBodyStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RCompoundStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.ArgumentInfo;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.OptionInfo;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RArgument;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RArgumentList;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RSingletonMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.names.RName;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.holders.RStubBasedContainerBase;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.methodCall.RCallNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.stubs.containers.RMethodStubBase;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RPseudoConstant;
import org.jetbrains.plugins.ruby.ruby.lang.psi.visitors.RubyRecursiveElementVisitor;
import org.jetbrains.plugins.ruby.ruby.presentation.RMethodPresentationUtil;

public abstract class RMethodBase<T extends RMethodStubBase<?>>
extends RStubBasedContainerBase<T>
implements RMethod,
RFormatStructureElement {
    public static final TokenSet TS_ARGUMENT_LISTS = TokenSet.create((IElementType[])new IElementType[]{RubyElementTypes.FUNCTION_ARGUMENT_LIST, RubyElementTypes.COMMAND_ARGUMENT_LIST});

    public RMethodBase(ASTNode astNode) {
        super(astNode);
    }

    protected RMethodBase(T t, IElementType nodeType) {
        super(t, nodeType);
    }

    @Contract(pure=true)
    @Nullable
    public RName getMethodName() {
        return (RName)PsiTreeUtil.getChildOfType((PsiElement)this, RName.class);
    }

    @Nullable
    public RArgumentList getArgumentList() {
        return (RArgumentList)RubyPsiUtilCore.getChildByFilter((PsiElement)this, TS_ARGUMENT_LISTS, 0);
    }

    public String getPresentableName(boolean includeDefaultArgs) {
        int options = 257;
        if (includeDefaultArgs) {
            options |= 0x80;
        }
        return RMethodPresentationUtil.formatName(this, options);
    }

    public Icon getIcon(int flags) {
        return RMethodPresentationUtil.getIcon(this, flags);
    }

    @Override
    public ItemPresentation getPresentation() {
        return RMethodPresentationUtil.getPresentation(this);
    }

    public List<RArgument> getArguments() {
        RArgumentList argumentList = this.getArgumentList();
        return argumentList != null ? argumentList.getArguments() : Collections.emptyList();
    }

    @NotNull
    public List<ArgumentInfo> getArgumentInfos() {
        RMethodStubBase stub = (RMethodStubBase)this.getGreenStub();
        if (stub != null) {
            List list = stub.getArgumentInfos();
            if (list == null) {
                RMethodBase.$$$reportNull$$$0(0);
            }
            return list;
        }
        RArgumentList argumentList = this.getArgumentList();
        List list = argumentList != null ? argumentList.getArgumentInfos() : Collections.emptyList();
        if (list == null) {
            RMethodBase.$$$reportNull$$$0(1);
        }
        return list;
    }

    @NotNull
    public List<ArgumentInfo> getArgumentInfos(boolean includeDefaultValues) {
        RArgumentList argumentList = this.getArgumentList();
        List list = argumentList != null ? argumentList.getArgumentInfos(true) : Collections.emptyList();
        if (list == null) {
            RMethodBase.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    public MethodAnnotationData getAnnotationData() {
        RMethodStubBase stub = (RMethodStubBase)this.getGreenStub();
        if (stub != null) {
            MethodAnnotationData methodAnnotationData = stub.getAnnotationData();
            if (methodAnnotationData == null) {
                RMethodBase.$$$reportNull$$$0(3);
            }
            return methodAnnotationData;
        }
        MethodAnnotationData methodAnnotationData = (MethodAnnotationData)CachedValuesManager.getCachedValue((PsiElement)this, () -> CachedValueProvider.Result.create((Object)AnnotationsHelperCore.createFromPsi(this), (Object[])new Object[]{this.getParent()}));
        if (methodAnnotationData == null) {
            RMethodBase.$$$reportNull$$$0(4);
        }
        return methodAnnotationData;
    }

    @NotNull
    public List<YARDTag> getYARDTags() {
        List list = (List)CachedValuesManager.getCachedValue((PsiElement)this, () -> {
            List<PsiComment> comments = RubyCommentsUtilCore.getPsiComments((PsiElement)this);
            List<Object> tags = comments.isEmpty() ? Collections.emptyList() : YARDParser.parse(comments);
            return CachedValueProvider.Result.create(tags, (Object[])new Object[]{this.getParent()});
        });
        if (list == null) {
            RMethodBase.$$$reportNull$$$0(5);
        }
        return list;
    }

    public List<OptionInfo> getOptionInfos() {
        return Optional.ofNullable(this.getAnnotationData().getYARDMethodData()).map(YARDMethodData::getOptionInfos).orElse(Collections.emptyList());
    }

    @NotNull
    public RCompoundStatement getCompoundStatement() {
        RBodyStatement body = (RBodyStatement)PsiTreeUtil.getChildOfType((PsiElement)this, RBodyStatement.class);
        assert (body != null);
        RCompoundStatement rCompoundStatement = body.getCompoundStatement();
        if (rCompoundStatement == null) {
            RMethodBase.$$$reportNull$$$0(6);
        }
        return rCompoundStatement;
    }

    public Type getSymbolType() {
        return this instanceof RSingletonMethod ? Type.CLASS_METHOD : Type.INSTANCE_METHOD;
    }

    public boolean hasSuperCall() {
        RMethodStubBase stub = (RMethodStubBase)this.getGreenStub();
        if (stub != null) {
            return stub.hasSuperCall();
        }
        final Ref hasSuperCallRef = new Ref((Object)false);
        this.acceptChildren((PsiElementVisitor)new RubyRecursiveElementVisitor(){

            public void visitElement(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!(element instanceof RContainer) && !((Boolean)hasSuperCallRef.get()).booleanValue()) {
                    super.visitElement(element);
                }
            }

            public void visitRPseudoConstant(@NotNull RPseudoConstant pseudoConstant) {
                if (pseudoConstant == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (pseudoConstant.getText().equals("super") && RCallNavigator.getByCommand((PsiElement)pseudoConstant) == null) {
                    hasSuperCallRef.set((Object)true);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "pseudoConstant";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/lang/psi/impl/controlStructures/methods/RMethodBase$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitElement";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitRPseudoConstant";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        return (Boolean)hasSuperCallRef.get();
    }

    public boolean hasYieldCall() {
        RMethodStubBase stub = (RMethodStubBase)this.getGreenStub();
        if (stub != null) {
            return stub.hasYieldCall();
        }
        final Ref hasYieldCallRef = new Ref((Object)false);
        this.acceptChildren((PsiElementVisitor)new RubyRecursiveElementVisitor(){

            public void visitElement(@NotNull PsiElement element) {
                if (element == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (!(element instanceof RContainer) && !((Boolean)hasYieldCallRef.get()).booleanValue()) {
                    super.visitElement(element);
                }
            }

            public void visitRYieldStatement(@NotNull RYieldStatement yieldStatement) {
                if (yieldStatement == null) {
                    2.$$$reportNull$$$0(1);
                }
                hasYieldCallRef.set((Object)true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "yieldStatement";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/lang/psi/impl/controlStructures/methods/RMethodBase$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitElement";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitRYieldStatement";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        return (Boolean)hasYieldCallRef.get();
    }

    public boolean isDeprecated() {
        MethodAnnotationData annotationData = this.getAnnotationData();
        return annotationData.getRailsDeprecationValue() || Optional.ofNullable(annotationData.getYARDMethodData()).map(YARDMethodData::isDeprecated).orElse(false) != false;
    }

    public boolean isEndless() {
        return PsiUtilCore.getElementType((PsiElement)PsiTreeUtil.prevVisibleLeaf((PsiElement)this.getBody())) == RubyTokenTypes.tASSGN;
    }

    @Nullable
    public Summary getSummary() {
        RMethodStubBase stub = (RMethodStubBase)this.getGreenStub();
        if (stub != null) {
            return stub.getSummary();
        }
        return SummaryUtilService.instance().computeSummaryForMethod((RMethod)this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/plugins/ruby/ruby/lang/psi/impl/controlStructures/methods/RMethodBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getArgumentInfos";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotationData";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getYARDTags";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompoundStatement";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

