/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang.psi.impl.controlStructures.methods;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypes;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementFactoryCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.ArgumentInfo;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RArgument;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RArgumentList;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.RPsiElementBaseImpl;
import org.jetbrains.plugins.ruby.ruby.lang.psi.visitors.RubyElementVisitor;

public class RCommandArgumentListImpl
extends RPsiElementBaseImpl
implements RArgumentList {
    public RCommandArgumentListImpl(ASTNode astNode) {
        super(astNode);
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            RCommandArgumentListImpl.$$$reportNull$$$0(0);
        }
        if (visitor instanceof RubyElementVisitor) {
            ((RubyElementVisitor)visitor).visitRArgumentList((RArgumentList)this);
            return;
        }
        super.accept(visitor);
    }

    @NotNull
    public List<RArgument> getArguments() {
        PsiElement[] children;
        ArrayList<RArgument> list = new ArrayList<RArgument>();
        for (PsiElement child : children = this.getChildren()) {
            if (!(child instanceof RArgument)) continue;
            list.add((RArgument)child);
        }
        ArrayList<RArgument> arrayList = list;
        if (arrayList == null) {
            RCommandArgumentListImpl.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @NotNull
    public List<ArgumentInfo> getArgumentInfos(boolean includeDefaultArgs) {
        ArrayList<ArgumentInfo> myInfos = new ArrayList<ArgumentInfo>();
        for (RArgument argument : this.getArguments()) {
            myInfos.add(argument.getArgumentInfo(includeDefaultArgs));
        }
        ArrayList<ArgumentInfo> arrayList = myInfos;
        if (arrayList == null) {
            RCommandArgumentListImpl.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @NotNull
    public List<ArgumentInfo> getArgumentInfos() {
        List<ArgumentInfo> list = this.getArgumentInfos(false);
        if (list == null) {
            RCommandArgumentListImpl.$$$reportNull$$$0(3);
        }
        return list;
    }

    public int getArgNumber(@NotNull RArgument arg) {
        if (arg == null) {
            RCommandArgumentListImpl.$$$reportNull$$$0(4);
        }
        List<RArgument> arguments = this.getArguments();
        for (int i = 0; i < arguments.size(); ++i) {
            RArgument argument = arguments.get(i);
            if (argument != arg) continue;
            return i;
        }
        return -1;
    }

    @NotNull
    public String getPresentableName(boolean includeDefaultArgs) {
        String string = RCommandArgumentListImpl.getPresentableName(this.getArgumentInfos(includeDefaultArgs));
        if (string == null) {
            RCommandArgumentListImpl.$$$reportNull$$$0(5);
        }
        return string;
    }

    public int addParameter(@NotNull String name, @NotNull ArgumentInfo.Type argumentType, boolean generateParenthesesAroundArguments) {
        if (name == null) {
            RCommandArgumentListImpl.$$$reportNull$$$0(6);
        }
        if (argumentType == null) {
            RCommandArgumentListImpl.$$$reportNull$$$0(7);
        }
        if (argumentType == ArgumentInfo.Type.HASH) {
            throw new IllegalArgumentException("HASH arguments are not supported");
        }
        String dummyText = "def foo" + (generateParenthesesAroundArguments ? "(" : " ") + "a," + name + (generateParenthesesAroundArguments ? ")" : " ") + "\nend";
        RMethod dummyMethod = (RMethod)RubyElementFactoryCore.createElementFromText((PsiElement)this, dummyText);
        RArgumentList dummyMethodArgumentList = dummyMethod.getArgumentList();
        assert (dummyMethodArgumentList != null) : "Incorrectly parsed dummy method";
        List dummyArgs = dummyMethodArgumentList.getArguments();
        if (this.getPrevSibling().getNode().getElementType() != RubyTokenTypes.tLPAREN && StringUtil.isEmptyOrSpaces((String)this.getText())) {
            PsiElement parent = this.getParent();
            parent.addBefore(dummyMethodArgumentList.getPrevSibling(), (PsiElement)this);
            parent.addAfter(dummyMethodArgumentList.getNextSibling(), (PsiElement)this);
        }
        List<RArgument> args = this.getArguments();
        RArgument arg2Insert = (RArgument)dummyArgs.get(dummyArgs.size() - 1);
        if (args.isEmpty()) {
            this.add((PsiElement)arg2Insert);
            return 0;
        }
        int insertPlace = RCommandArgumentListImpl.getArgumentInsertPlace(args, argumentType);
        if (insertPlace == -1) {
            this.addBefore((PsiElement)arg2Insert, this.addBefore(arg2Insert.getPrevSibling(), (PsiElement)args.get(0)));
        } else {
            this.addAfter((PsiElement)arg2Insert, this.addAfter(arg2Insert.getPrevSibling(), (PsiElement)args.get(insertPlace)));
        }
        return insertPlace + 1;
    }

    private static int getArgumentInsertPlace(@NotNull List<? extends RArgument> args, @NotNull ArgumentInfo.Type type) {
        if (args == null) {
            RCommandArgumentListImpl.$$$reportNull$$$0(8);
        }
        if (type == null) {
            RCommandArgumentListImpl.$$$reportNull$$$0(9);
        }
        return switch (type) {
            case ArgumentInfo.Type.SIMPLE, ArgumentInfo.Type.ARRAY, ArgumentInfo.Type.CAPTURE -> RCommandArgumentListImpl.getAfterSimpleInsertPlace(args);
            case ArgumentInfo.Type.PREDEFINED -> RCommandArgumentListImpl.getPredefinedArgumentInsertPlace(args);
            case ArgumentInfo.Type.NAMED, ArgumentInfo.Type.KEYREQ -> RCommandArgumentListImpl.getNamedArgumentInsertPlace(args);
            case ArgumentInfo.Type.BLOCK, ArgumentInfo.Type.BLOCK_REQUIRED -> args.size() - 1;
            default -> throw new IllegalArgumentException("HASH arguments are not supported");
        };
    }

    private static int getPredefinedArgumentInsertPlace(@NotNull List<? extends RArgument> args) {
        if (args == null) {
            RCommandArgumentListImpl.$$$reportNull$$$0(10);
        }
        int insertPlace = args.size() - 1;
        boolean hasPredefinedArgument = false;
        for (int i = 0; i < args.size(); ++i) {
            ArgumentInfo.Type type = args.get(i).getType();
            if (type == ArgumentInfo.Type.PREDEFINED) {
                hasPredefinedArgument = true;
                insertPlace = i;
                continue;
            }
            if (hasPredefinedArgument) break;
            if (type == ArgumentInfo.Type.SIMPLE) continue;
            insertPlace = i - 1;
            break;
        }
        return insertPlace;
    }

    private static int getNamedArgumentInsertPlace(@NotNull List<? extends RArgument> args) {
        int insertPlace;
        ArgumentInfo.Type type;
        if (args == null) {
            RCommandArgumentListImpl.$$$reportNull$$$0(11);
        }
        if ((type = args.get(insertPlace = args.size() - 1).getType()) == ArgumentInfo.Type.HASH || type.isBlock()) {
            if (--insertPlace == -1) {
                return insertPlace;
            }
            type = args.get(insertPlace).getType();
            if (type == ArgumentInfo.Type.HASH) {
                --insertPlace;
            }
        }
        return insertPlace;
    }

    private static int getAfterSimpleInsertPlace(@NotNull List<? extends RArgument> args) {
        int insertPlace;
        if (args == null) {
            RCommandArgumentListImpl.$$$reportNull$$$0(12);
        }
        for (insertPlace = args.size() - 1; insertPlace >= 0 && args.get(insertPlace).getType() != ArgumentInfo.Type.SIMPLE; --insertPlace) {
        }
        return insertPlace;
    }

    public static String getPresentableName(List<? extends ArgumentInfo> argList) {
        StringBuilder buff = new StringBuilder();
        for (int i = 0; i < argList.size(); ++i) {
            if (i != 0) {
                buff.append(", ");
            }
            buff.append(argList.get(i).getPresentableName());
        }
        return buff.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/lang/psi/impl/controlStructures/methods/RCommandArgumentListImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arg";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentType";
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/lang/psi/impl/controlStructures/methods/RCommandArgumentListImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getArguments";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getArgumentInfos";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getArgNumber";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addParameter";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getArgumentInsertPlace";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getPredefinedArgumentInsertPlace";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getNamedArgumentInsertPlace";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getAfterSimpleInsertPlace";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 5 -> new IllegalStateException(string);
        };
    }
}

