/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang.psi.impl.basicTypes.stringLiterals.heredocs;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import org.jetbrains.plugins.ruby.ruby.lang.RubyTextUtil;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyHeredocUtil;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypes;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubySpaceUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RExpressionSubstitution;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.heredocs.RHeredocId;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.heredocs.RHeredocValue;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.basicTypes.stringLiterals.RStringLiteralBase;
import org.jetbrains.plugins.ruby.ruby.lang.psi.visitors.RubyElementVisitor;

public class RHeredocValueImpl
extends RStringLiteralBase
implements RHeredocValue {
    public RHeredocValueImpl(ASTNode astNode) {
        super(astNode);
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            RHeredocValueImpl.$$$reportNull$$$0(0);
        }
        if (visitor instanceof RubyElementVisitor) {
            ((RubyElementVisitor)visitor).visitRHeredocValue((RHeredocValue)this);
            return;
        }
        super.accept(visitor);
    }

    @Nullable
    public String getId() {
        IElementType type;
        PsiElement element = this.getNextSibling();
        while (RubySpaceUtil.isAnySpace((PsiElement)element)) {
            element = element.getNextSibling();
        }
        if (element != null && ((type = element.getNode().getElementType()) == RubyTokenTypes.tHEREDOC_END || type == RubyTokenTypes.tHEREDOC_INDENTED_END)) {
            return element.getText();
        }
        return null;
    }

    @NotNull
    public RHeredocId getIdElement() {
        RHeredocId rHeredocId = (RHeredocId)CachedValuesManager.getCachedValue((PsiElement)this, () -> {
            String myId = this.getId();
            RHeredocValueImpl currentElement = this;
            while (currentElement != null) {
                PsiElement patt3577$temp;
                if ((currentElement = PsiTreeUtil.prevVisibleLeaf((PsiElement)currentElement)) == null || !((patt3577$temp = currentElement.getParent()) instanceof RHeredocId)) continue;
                RHeredocId result = (RHeredocId)patt3577$temp;
                if (myId != null && !result.getId().equals(myId)) continue;
                return CachedValueProvider.Result.create((Object)result, (Object[])new Object[]{currentElement, result});
            }
            PsiFile containingFile = this.getContainingFile();
            VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)this);
            FileType fileType = virtualFile == null ? null : virtualFile.getFileType();
            PsiElement parent = this.getParent();
            throw new IllegalStateException("This heredoc value does not have an opening :(; valid=" + this.isValid() + "; myId='" + myId + "'; containing file: " + String.valueOf(containingFile) + "; file type: " + String.valueOf(fileType) + "; parent text: " + (parent == null ? "null" : parent.getText()));
        });
        if (rHeredocId == null) {
            RHeredocValueImpl.$$$reportNull$$$0(1);
        }
        return rHeredocId;
    }

    public int getIndent() {
        if (!this.isSquiggly()) {
            return 0;
        }
        return RHeredocValueImpl.getIndentForLines(StringUtil.split((CharSequence)this.getText(), (CharSequence)"\n"));
    }

    public @Unmodifiable @NotNull List<CharSequence> getContentLines() {
        List lines = StringUtil.split((CharSequence)this.getText(), (CharSequence)"\n", (boolean)true, (boolean)false);
        if (!this.isSquiggly()) {
            List list = lines;
            if (list == null) {
                RHeredocValueImpl.$$$reportNull$$$0(2);
            }
            return list;
        }
        int minIndent = RHeredocValueImpl.getIndentForLines(lines);
        ArrayList<CharSequence> result = new ArrayList<CharSequence>(lines.size());
        for (CharSequence line : lines) {
            result.add(RHeredocValueImpl.adaptLineToThisIndent(line, minIndent));
        }
        ArrayList<CharSequence> arrayList = result;
        if (arrayList == null) {
            RHeredocValueImpl.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @Override
    public String getContent() {
        if (!this.isSquiggly()) {
            return super.getContent();
        }
        return StringUtil.join(this.getContentLines(), (String)"\n");
    }

    @NotNull
    public List<TextRange> getContentRanges() {
        int indent = this.getIndent();
        if (indent == 0) {
            List list = super.getContentRanges();
            if (list == null) {
                RHeredocValueImpl.$$$reportNull$$$0(4);
            }
            return list;
        }
        PsiElement first = (PsiElement)ContainerUtil.getFirstItem(this.getPsiContent());
        if (first == null) {
            List<TextRange> list = Collections.emptyList();
            if (list == null) {
                RHeredocValueImpl.$$$reportNull$$$0(5);
            }
            return list;
        }
        ArrayList<TextRange> ranges = new ArrayList<TextRange>();
        int offset = first.getTextRangeInParent().getStartOffset();
        for (String line : StringUtil.split((String)this.getText(), (String)"\n", (boolean)false, (boolean)false)) {
            ranges.add(TextRange.create((int)(offset + Math.min(StringUtil.lastIndexOf((CharSequence)line, (char)' ', (int)0, (int)indent) + 1, indent)), (int)(offset + line.length())));
            offset += line.length();
        }
        ArrayList<TextRange> arrayList = ranges;
        if (arrayList == null) {
            RHeredocValueImpl.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    private boolean isSquiggly() {
        return RubyHeredocUtil.isSquiggly((String)this.getIdElement().getIdPrefix());
    }

    public static int getIndentForLines(@NotNull List<CharSequence> lines) {
        if (lines == null) {
            RHeredocValueImpl.$$$reportNull$$$0(7);
        }
        Optional result = RHeredocValueImpl.getCurrentIndents(lines).stream().min(Comparator.naturalOrder());
        return result.orElse(0);
    }

    @NotNull
    private static List<Integer> getCurrentIndents(List<CharSequence> lines) {
        ArrayList<Integer> indents = new ArrayList<Integer>(lines.size());
        for (CharSequence line : lines) {
            if (StringUtil.isEmptyOrSpaces((CharSequence)line)) {
                indents.add(Integer.MAX_VALUE);
                continue;
            }
            indents.add(RubyTextUtil.getLineIndent((CharSequence)line, (int)8));
        }
        ArrayList<Integer> arrayList = indents;
        if (arrayList == null) {
            RHeredocValueImpl.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    @NotNull
    private static CharSequence adaptLineToThisIndent(@NotNull CharSequence line, int minIndent) {
        int pos;
        if (line == null) {
            RHeredocValueImpl.$$$reportNull$$$0(9);
        }
        int currentIndent = 0;
        for (pos = 0; pos < line.length() && currentIndent < minIndent; ++pos) {
            char c = line.charAt(pos);
            if (c == ' ') {
                ++currentIndent;
                continue;
            }
            if (c != '\t' || currentIndent + 8 > minIndent) break;
            currentIndent += 8;
        }
        CharSequence charSequence = line.subSequence(pos, line.length());
        if (charSequence == null) {
            RHeredocValueImpl.$$$reportNull$$$0(10);
        }
        return charSequence;
    }

    @Override
    public char @NotNull [] getCharsThatMustBeEscaped() {
        return new char[0];
    }

    @Override
    public boolean supportsInterpolation() {
        return true;
    }

    @Override
    public boolean isValidHost() {
        return PsiTreeUtil.getChildOfType((PsiElement)this, RExpressionSubstitution.class) == null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 5, 6, 8, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/lang/psi/impl/basicTypes/stringLiterals/heredocs/RHeredocValueImpl";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lines";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/lang/psi/impl/basicTypes/stringLiterals/heredocs/RHeredocValueImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getIdElement";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentLines";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentRanges";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentIndents";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "adaptLineToThisIndent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getIndentForLines";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "adaptLineToThisIndent";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 5, 6, 8, 10 -> new IllegalStateException(string);
        };
    }
}

