/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang.psi.impl;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.model.psi.RubyPsiPresentationService;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.RElementWithFQN;
import org.jetbrains.plugins.ruby.ruby.lang.RubyFileType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RConstantHolder;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RMethodHolder;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.RPsiFileBase;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.holders.utils.RContainerUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.stubs.containers.RubyFileStub;
import org.jetbrains.plugins.ruby.utils.NamingConventions;

public class RFileImpl
extends RPsiFileBase {
    @NotNull
    private final Language myLanguage;

    public RFileImpl(FileViewProvider viewProvider) {
        this(viewProvider, RubyFileType.RUBY.getLanguage());
    }

    public RFileImpl(FileViewProvider viewProvider, Language language) {
        super(viewProvider);
        this.myLanguage = this.initLanguage(language);
    }

    @Override
    @NotNull
    public FileType getFileType() {
        RubyFileType rubyFileType = RubyFileType.RUBY;
        if (rubyFileType == null) {
            RFileImpl.$$$reportNull$$$0(0);
        }
        return rubyFileType;
    }

    @NotNull
    public String toString() {
        return "Ruby file";
    }

    @NotNull
    public final Language getLanguage() {
        Language language = this.myLanguage;
        if (language == null) {
            RFileImpl.$$$reportNull$$$0(1);
        }
        return language;
    }

    @NotNull
    private Language initLanguage(@NotNull Language language) {
        ParserDefinition parserDefinition;
        if (language == null) {
            RFileImpl.$$$reportNull$$$0(2);
        }
        if ((parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(language)) == null) {
            throw new RuntimeException("PsiFileBase: language.getParserDefinition() returned null.");
        }
        IFileElementType nodeType = parserDefinition.getFileNodeType();
        this.init((IElementType)nodeType, (IElementType)nodeType);
        Language language2 = language;
        if (language2 == null) {
            RFileImpl.$$$reportNull$$$0(3);
        }
        return language2;
    }

    @NotNull
    public Map<String, String> getPragmas() {
        Map map = (Map)this.withGreenStubOrAst(RubyFileStub.class, RubyFileStub::getPragmas, ast -> {
            PsiComment comment;
            PsiElement first = PsiTreeUtil.getDeepestFirst((PsiElement)ast.getPsi());
            PsiElement candidate = first instanceof PsiComment ? first : PsiTreeUtil.nextVisibleLeaf((PsiElement)first);
            LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
            while (candidate instanceof PsiComment && RubyPsiUtilCore.isPragmaComment(comment = (PsiComment)candidate)) {
                List pragma = StringUtil.split((String)comment.getText().substring(1), (String)":");
                if (pragma.size() == 2) {
                    result.put(((String)pragma.get(0)).trim(), ((String)pragma.get(1)).trim());
                }
                while ((candidate = candidate.getNextSibling()) instanceof PsiWhiteSpace) {
                }
            }
            return Collections.unmodifiableMap(result);
        });
        if (map == null) {
            RFileImpl.$$$reportNull$$$0(4);
        }
        return map;
    }

    @Nullable
    public String getPresentableLocation() {
        return RubyPsiPresentationService.instance().getPresentableLocation((RFile)this);
    }

    @Nullable
    public RElementWithFQN getPrimaryDeclaration() {
        String filename = FileUtilRt.getNameWithoutExtension((String)this.getName());
        if (filename.isBlank()) {
            return null;
        }
        ArrayList<RContainer> declarations = new ArrayList<RContainer>();
        for (RContainer element : RContainerUtilCore.getStructureElementsRecursively((RContainer)this)) {
            if (element instanceof RMethodHolder) {
                declarations.add(element);
            }
            if (!(element instanceof RConstantHolder)) continue;
            RConstantHolder rConstantHolder = (RConstantHolder)element;
            declarations.addAll(rConstantHolder.getConstantDeclarations());
        }
        Module module = ModuleUtilCore.findModuleForFile((PsiFile)this);
        return (RElementWithFQN)ContainerUtil.findLast(declarations, it -> filename.equals(NamingConventions.toUnderscoreCase(it.getFQN().getShortName(), module)));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/lang/psi/impl/RFileImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/lang/psi/impl/RFileImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "initLanguage";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPragmas";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "initLanguage";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2 -> new IllegalArgumentException(string);
        };
    }
}

