/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.ArgumentInfo;

public final class ArgumentInfoUtil {
    private ArgumentInfoUtil() {
    }

    public static boolean areArgumentsCompatible(@NotNull List<? extends ArgumentInfo> first, @NotNull List<? extends ArgumentInfo> second) {
        if (first == null) {
            ArgumentInfoUtil.$$$reportNull$$$0(0);
        }
        if (second == null) {
            ArgumentInfoUtil.$$$reportNull$$$0(1);
        }
        return ArgumentInfoUtil.areSimpleArgumentsCompatible(first, second) && ArgumentInfoUtil.areNamedArgumentsCompatible(first, second);
    }

    public static int getMinNumberOfSimpleArguments(@NotNull List<? extends ArgumentInfo> argumentInfos) {
        if (argumentInfos == null) {
            ArgumentInfoUtil.$$$reportNull$$$0(2);
        }
        int result = 0;
        for (ArgumentInfo argumentInfo : argumentInfos) {
            if (argumentInfo.getType() != ArgumentInfo.Type.SIMPLE) continue;
            ++result;
        }
        return result;
    }

    public static int getMaxNumberOfSimpleArguments(@NotNull List<? extends ArgumentInfo> argumentInfos) {
        if (argumentInfos == null) {
            ArgumentInfoUtil.$$$reportNull$$$0(3);
        }
        int result = 0;
        for (ArgumentInfo argumentInfo : argumentInfos) {
            ArgumentInfo.Type type = argumentInfo.getType();
            if (type.isPositional()) {
                ++result;
                continue;
            }
            if (type != ArgumentInfo.Type.ARRAY) continue;
            result = -1;
            break;
        }
        return result;
    }

    private static boolean areSimpleArgumentsCompatible(@NotNull List<? extends ArgumentInfo> first, @NotNull List<? extends ArgumentInfo> second) {
        int minMaxArg;
        if (first == null) {
            ArgumentInfoUtil.$$$reportNull$$$0(4);
        }
        if (second == null) {
            ArgumentInfoUtil.$$$reportNull$$$0(5);
        }
        int firstMaxArg = ArgumentInfoUtil.getMaxNumberOfSimpleArguments(first);
        int secondMaxArg = ArgumentInfoUtil.getMaxNumberOfSimpleArguments(second);
        if (firstMaxArg == -1) {
            return secondMaxArg == -1 || secondMaxArg >= ArgumentInfoUtil.getMinNumberOfSimpleArguments(first);
        }
        if (secondMaxArg == -1) {
            return firstMaxArg >= ArgumentInfoUtil.getMinNumberOfSimpleArguments(second);
        }
        int maxMinArg = Math.max(ArgumentInfoUtil.getMinNumberOfSimpleArguments(first), ArgumentInfoUtil.getMinNumberOfSimpleArguments(second));
        return maxMinArg <= (minMaxArg = Math.min(firstMaxArg, secondMaxArg));
    }

    private static boolean areNamedArgumentsCompatible(@NotNull List<? extends ArgumentInfo> first, @NotNull List<? extends ArgumentInfo> second) {
        if (first == null) {
            ArgumentInfoUtil.$$$reportNull$$$0(6);
        }
        if (second == null) {
            ArgumentInfoUtil.$$$reportNull$$$0(7);
        }
        List<String> firstMaxArg = ArgumentInfoUtil.getMaxNamedArguments(first);
        List<String> secondMaxArg = ArgumentInfoUtil.getMaxNamedArguments(second);
        if (firstMaxArg == null || secondMaxArg == null) {
            return true;
        }
        List<String> firstMinArg = ArgumentInfoUtil.getMinNamedArguments(first);
        List<String> secondMinArg = ArgumentInfoUtil.getMinNamedArguments(second);
        return secondMaxArg.containsAll(firstMinArg) && firstMaxArg.containsAll(secondMinArg);
    }

    @NotNull
    private static List<String> getMinNamedArguments(@NotNull List<? extends ArgumentInfo> argumentInfos) {
        if (argumentInfos == null) {
            ArgumentInfoUtil.$$$reportNull$$$0(8);
        }
        ArrayList<String> result = new ArrayList<String>();
        for (ArgumentInfo argumentInfo : argumentInfos) {
            if (argumentInfo.getType() != ArgumentInfo.Type.KEYREQ) continue;
            result.add(argumentInfo.getName());
        }
        ArrayList<String> arrayList = result;
        if (arrayList == null) {
            ArgumentInfoUtil.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    @Nullable
    private static List<String> getMaxNamedArguments(@NotNull List<? extends ArgumentInfo> argumentInfos) {
        if (argumentInfos == null) {
            ArgumentInfoUtil.$$$reportNull$$$0(10);
        }
        ArrayList<String> result = new ArrayList<String>();
        for (ArgumentInfo argumentInfo : argumentInfos) {
            ArgumentInfo.Type type = argumentInfo.getType();
            if (type.isKeyword()) {
                result.add(argumentInfo.getName());
                continue;
            }
            if (type != ArgumentInfo.Type.HASH) continue;
            result = null;
            break;
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 1: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "second";
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentInfos";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/lang/psi/controlStructures/methods/ArgumentInfoUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/lang/psi/controlStructures/methods/ArgumentInfoUtil";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getMinNamedArguments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "areArgumentsCompatible";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getMinNumberOfSimpleArguments";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getMaxNumberOfSimpleArguments";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "areSimpleArgumentsCompatible";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "areNamedArgumentsCompatible";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getMinNamedArguments";
                break;
            }
            case 9: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getMaxNamedArguments";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9 -> new IllegalStateException(string);
        };
    }
}

