/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang.psi;

import com.intellij.injected.editor.DocumentWindow;
import com.intellij.lang.ASTNode;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.TextRangeUtil;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.console.RubyLanguageConsoleUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.RNamespace;
import org.jetbrains.plugins.ruby.ruby.codeInsight.usages.RubyUsageAnalyzerCore;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypes;
import org.jetbrains.plugins.ruby.ruby.lang.parser.RubyElementTypes;
import org.jetbrains.plugins.ruby.ruby.lang.parser.bnf.RubyTokenSets;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyCommonPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementFactoryCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyExpressionCodeFragment;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.RSymbol;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RExpressionSubstitution;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RStringLiteral;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.heredocs.RHeredocValue;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RLoopStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RCompoundStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RArgument;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RClassObject;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modules.RModule;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RAssignmentExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RGroupedExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RLiteral;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RSelfAssignmentExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.RubyLanguageLevelService;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.controlStructures.methods.arguments.RNamedArgumentNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.controlStructures.methods.arguments.RPredefinedArgumentNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.controlStructures.names.RNameImpl;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.expressions.RAssignmentExpressionNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.expressions.RSelfAssignmentExpressionNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.iterators.RBlockCallNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.methodCall.RCallNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.references.RReferenceNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RBlockCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyCallTypesCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RColonReference;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RTopConstReference;
import org.jetbrains.plugins.ruby.ruby.lang.psi.ruby19.RAssocKey;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RConstant;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RFName;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RIdentifier;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RPseudoConstant;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RVariable;
import org.jetbrains.plugins.ruby.ruby.sdk.LanguageLevel;

public final class RubyPsiUtilCore {
    private static final Logger LOG = Logger.getInstance(RubyPsiUtilCore.class);
    @NonNls
    private static final String INFINITE_LOOP_STATEMENT_NAME = "loop";
    @NonNls
    private static final Set<String> EXIT_NAMES = Set.of("abort", "exit", "exit!");
    private static final Set<String> PRAGMAS = Set.of("coding", "encoding", "frozen_string_literal", "warn_indent", "warn_past_scope");
    private static final String[] VISIBILITY_MODIFIER_COMMANDS = new String[]{"private", "protected", "public"};

    private RubyPsiUtilCore() {
    }

    @Contract(value="!null -> !null", pure=true)
    @Nullable
    public static Project getProject(@Nullable PsiElement element) {
        if (element == null) {
            return null;
        }
        return (Project)ReadAction.compute(() -> element.getProject());
    }

    @Nullable
    public static String getElementText(@NotNull PsiElement element) {
        if (element == null) {
            RubyPsiUtilCore.$$$reportNull$$$0(0);
        }
        if (element instanceof RStringLiteral && !((RStringLiteral)element).hasExpressionSubstitutions()) {
            return ((RStringLiteral)element).getContentValue();
        }
        if (element instanceof RLiteral) {
            return ((RLiteral)element).getContent();
        }
        if (element instanceof RPseudoConstant) {
            return element.getText();
        }
        if (element instanceof RSymbol) {
            return ((RSymbol)element).getValue();
        }
        if (element instanceof RMethod) {
            return ((RMethod)element).getName();
        }
        if (element instanceof RFName) {
            return element.getText();
        }
        if (element instanceof RVariable) {
            return element.getText();
        }
        if (element instanceof RAssocKey) {
            return element.getText();
        }
        if (element instanceof RGroupedExpression) {
            return (String)ObjectUtils.doIfNotNull((Object)((RGroupedExpression)element).getExpression(), RubyPsiUtilCore::getElementText);
        }
        return null;
    }

    public static void replaceInParent(@NotNull PsiElement oldElement, @NotNull PsiElement newElement) {
        PsiElement psiParent;
        if (oldElement == null) {
            RubyPsiUtilCore.$$$reportNull$$$0(1);
        }
        if (newElement == null) {
            RubyPsiUtilCore.$$$reportNull$$$0(2);
        }
        LOG.assertTrue((psiParent = oldElement.getParent()) != null);
        ASTNode parentNode = psiParent.getNode();
        LOG.assertTrue(parentNode != null);
        ASTNode oldNode = oldElement.getNode();
        LOG.assertTrue(oldNode != null);
        ASTNode newElementNode = newElement.getNode();
        LOG.assertTrue(newElementNode != null);
        parentNode.replaceChild(oldNode, newElementNode);
    }

    @Nullable
    public static RNamespace getParentNamespace(PsiElement element) {
        do {
            if ((element = PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)element, RNamespace.class)) != null) continue;
            return null;
        } while (!((RNamespace)element).isValidNamespace());
        return (RNamespace)element;
    }

    @NotNull
    public static <T extends PsiElement> List<T> getChildrenByFilter(PsiElement psiElement, Class<T> c) {
        PsiElement run = psiElement.getFirstChild();
        if (run == null) {
            List list = Collections.emptyList();
            if (list == null) {
                RubyPsiUtilCore.$$$reportNull$$$0(3);
            }
            return list;
        }
        LinkedList<PsiElement> list = null;
        while (run != null) {
            if (c.isInstance(run)) {
                if (list == null) {
                    list = new LinkedList<PsiElement>();
                }
                list.add(run);
            }
            run = run.getNextSibling();
        }
        List<Object> list2 = list == null ? Collections.emptyList() : list;
        if (list2 == null) {
            RubyPsiUtilCore.$$$reportNull$$$0(4);
        }
        return list2;
    }

    @NotNull
    public static Iterator<? extends RPsiElement> getChildrenIterator(@NotNull PsiElement parent) {
        if (parent == null) {
            RubyPsiUtilCore.$$$reportNull$$$0(5);
        }
        return RubyPsiUtilCore.getChildrenIterator(parent, RPsiElement.class);
    }

    @NotNull
    public static <T extends PsiElement> Iterator<? extends T> getChildrenIterator(@NotNull PsiElement parent, @NotNull Class<T> clazz) {
        T run;
        if (parent == null) {
            RubyPsiUtilCore.$$$reportNull$$$0(6);
        }
        if (clazz == null) {
            RubyPsiUtilCore.$$$reportNull$$$0(7);
        }
        if ((run = RubyPsiUtilCore.getNextSuitableElement(parent.getFirstChild(), clazz)) == null) {
            Iterator iterator = Collections.emptyIterator();
            if (iterator == null) {
                RubyPsiUtilCore.$$$reportNull$$$0(8);
            }
            return iterator;
        }
        return new Iterator<T>((PsiElement)run, clazz){
            private T myNext;
            final /* synthetic */ PsiElement val$run;
            final /* synthetic */ Class val$clazz;
            {
                this.val$run = psiElement;
                this.val$clazz = clazz;
                this.myNext = this.val$run;
            }

            @Override
            public boolean hasNext() {
                return this.myNext != null;
            }

            private void computeNext() {
                if (this.myNext == null) {
                    throw new NoSuchElementException();
                }
                this.myNext = RubyPsiUtilCore.getNextSuitableElement(this.myNext.getNextSibling(), this.val$clazz);
            }

            @Override
            public T next() {
                if (this.myNext == null) {
                    throw new NoSuchElementException();
                }
                Object result = this.myNext;
                this.computeNext();
                return result;
            }
        };
    }

    @Nullable
    private static <T extends PsiElement> T getNextSuitableElement(@Nullable PsiElement run, @NotNull Class<T> clazz) {
        if (clazz == null) {
            RubyPsiUtilCore.$$$reportNull$$$0(9);
        }
        while (!(run == null || clazz.isInstance(run) && run.getNode() instanceof CompositeElement && PsiUtilCore.getElementType((PsiElement)run) != RubyElementTypes.HEREDOC_VALUE)) {
            run = run.getNextSibling();
        }
        return (T)run;
    }

    @Nullable
    public static <T extends PsiElement> T getChildByFilter(PsiElement element, Class<T> aClass, int i) {
        List<T> childrenByType = RubyPsiUtilCore.getChildrenByFilter(element, aClass);
        int size = childrenByType.size();
        return (T)(i >= 0 && i < size ? (PsiElement)childrenByType.get(i) : null);
    }

    @Nullable
    public static PsiElement getChildByFilter(@NotNull PsiElement element, @NotNull TokenSet filter, int number) {
        ASTNode node;
        if (element == null) {
            RubyPsiUtilCore.$$$reportNull$$$0(10);
        }
        if (filter == null) {
            RubyPsiUtilCore.$$$reportNull$$$0(11);
        }
        if ((node = element.getNode()) != null) {
            ASTNode[] children = node.getChildren(filter);
            return 0 <= number && number < children.length ? children[number].getPsi() : null;
        }
        return null;
    }

    @Nullable
    public static PsiElement getChildByFilter(@NotNull PsiElement element, IElementType filter, int number) {
        if (element == null) {
            RubyPsiUtilCore.$$$reportNull$$$0(12);
        }
        return RubyPsiUtilCore.getChildByFilter(element, TokenSet.create((IElementType[])new IElementType[]{filter}), number);
    }

    @Nullable
    public static RContainer getContainingRClassOrModule(@Nullable PsiElement psiElement) {
        for (RContainer current = RubyPsiUtilCore.getParentContainerOrSelf(psiElement); current != null; current = current.getParentContainer()) {
            if (!(current instanceof RClass) && !(current instanceof RModule)) continue;
            return current;
        }
        return null;
    }

    @Nullable
    public static RContainer getParentContainer(@Nullable PsiElement element) {
        if (element instanceof RPsiElement) {
            return ((RPsiElement)element).getParentContainer();
        }
        return (RContainer)PsiTreeUtil.getParentOfType((PsiElement)element, RContainer.class);
    }

    @Nullable
    public static RContainer getParentContainerOrSelf(@Nullable PsiElement element) {
        if (element instanceof RContainer) {
            return (RContainer)element;
        }
        return RubyPsiUtilCore.getParentContainer(element);
    }

    @NotNull
    public static LanguageLevel getLanguageLevel(@NotNull PsiElement element) {
        if (element == null) {
            RubyPsiUtilCore.$$$reportNull$$$0(13);
        }
        LanguageLevel languageLevel = RubyLanguageLevelService.getLanguageLevel((PsiElement)element);
        if (languageLevel == null) {
            RubyPsiUtilCore.$$$reportNull$$$0(14);
        }
        return languageLevel;
    }

    @Nullable
    public static PsiElement getPrevSignificantSibling(PsiElement element) {
        return RubyPsiUtilCore.getSignificantSiblingToTheLeft(element.getPrevSibling());
    }

    @Nullable
    public static PsiElement getSignificantSiblingToTheLeft(PsiElement element) {
        while (element != null && (element instanceof PsiWhiteSpace || element instanceof PsiErrorElement || RubyTokenSets.getTWHITESPACES_OR_COMMENTS().contains(element.getNode().getElementType()))) {
            element = element.getPrevSibling();
        }
        return element;
    }

    @NotNull
    public static List<PsiElement> getChildrenByFilter(@NotNull PsiElement element, @NotNull TokenSet filter) {
        ASTNode node;
        if (element == null) {
            RubyPsiUtilCore.$$$reportNull$$$0(15);
        }
        if (filter == null) {
            RubyPsiUtilCore.$$$reportNull$$$0(16);
        }
        if ((node = element.getNode()) == null) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                RubyPsiUtilCore.$$$reportNull$$$0(17);
            }
            return list;
        }
        Object[] children = node.getChildren(filter);
        if (children.length == 0) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                RubyPsiUtilCore.$$$reportNull$$$0(18);
            }
            return list;
        }
        List list = ContainerUtil.map((Object[])children, ASTNode::getPsi);
        if (list == null) {
            RubyPsiUtilCore.$$$reportNull$$$0(19);
        }
        return list;
    }

    @NotNull
    public static List<PsiElement> getChildrenByFilter(@NotNull PsiElement element, IElementType filter) {
        if (element == null) {
            RubyPsiUtilCore.$$$reportNull$$$0(20);
        }
        return RubyPsiUtilCore.getChildrenByFilter(element, TokenSet.create((IElementType[])new IElementType[]{filter}));
    }

    public static PsiElement setElementName(@NotNull PsiElement namedElement, @NotNull String newName, @Nullable String prefix) {
        if (namedElement == null) {
            RubyPsiUtilCore.$$$reportNull$$$0(21);
        }
        if (newName == null) {
            RubyPsiUtilCore.$$$reportNull$$$0(22);
        }
        String fieldText = prefix != null ? prefix + newName : newName;
        RPsiElement element = RubyElementFactoryCore.createElementFromText(namedElement, fieldText);
        RubyPsiUtilCore.replaceInParent(namedElement, (PsiElement)element);
        return element;
    }

    @Nullable
    public static RCompoundStatement getCompoundStatement(PsiElement element) {
        RCompoundStatement statement = (RCompoundStatement)PsiTreeUtil.getParentOfType((PsiElement)element, RCompoundStatement.class);
        while (statement != null && (statement.getParent() instanceof RGroupedExpression || statement.getParent() instanceof RExpressionSubstitution)) {
            statement = (RCompoundStatement)PsiTreeUtil.getParentOfType((PsiElement)statement, RCompoundStatement.class);
        }
        return statement;
    }

    @Nullable
    public static RPsiElement getStatement(PsiElement element) {
        RCompoundStatement compoundStatement = RubyPsiUtilCore.getCompoundStatement(element);
        return compoundStatement != null ? RubyPsiUtilCore.getStatement(compoundStatement, element) : null;
    }

    @Nullable
    public static RPsiElement getStatement(@NotNull RCompoundStatement compoundStatement, @Nullable PsiElement element) {
        PsiElement result;
        if (compoundStatement == null) {
            RubyPsiUtilCore.$$$reportNull$$$0(23);
        }
        return (result = RubyPsiUtilCore.getCompoundStatementChild(compoundStatement, element)) instanceof RPsiElement ? (RPsiElement)result : null;
    }

    @Nullable
    public static PsiElement getCompoundStatementChild(RCompoundStatement compoundStatement, PsiElement element) {
        while (element != null) {
            if (element instanceof RHeredocValue) {
                element = ((RHeredocValue)element).getIdElement();
            }
            if (element.getParent() == compoundStatement) break;
            element = element.getParent();
        }
        return element;
    }

    public static boolean isBefore(@NotNull PsiElement element, @NotNull PsiElement element2) {
        if (element == null) {
            RubyPsiUtilCore.$$$reportNull$$$0(24);
        }
        if (element2 == null) {
            RubyPsiUtilCore.$$$reportNull$$$0(25);
        }
        return element.getTextOffset() <= element2.getTextOffset();
    }

    @Nullable
    public static RPsiElement getCoveringRPsiElement(@Nullable PsiElement psiElement) {
        return (RPsiElement)PsiTreeUtil.getNonStrictParentOfType((PsiElement)psiElement, (Class[])new Class[]{RPsiElement.class});
    }

    public static boolean isExplicitCall(RPsiElement identifierOrConstant) {
        return RReferenceNavigator.getReferenceByRightPart((PsiElement)identifierOrConstant) != null || RCallNavigator.getByCommand((PsiElement)identifierOrConstant) != null || RBlockCallNavigator.getByCall(identifierOrConstant) != null;
    }

    public static boolean isInfiniteLoop(@NotNull RLoopStatement element) {
        if (element == null) {
            RubyPsiUtilCore.$$$reportNull$$$0(26);
        }
        if (element instanceof RBlockCall) {
            RPossibleCall call = ((RBlockCall)element).getCall();
            if (!(call instanceof RIdentifier)) {
                return false;
            }
            PsiElement identifier = call.getPsiCommand();
            if (!(identifier instanceof PsiNamedElement)) {
                return false;
            }
            return INFINITE_LOOP_STATEMENT_NAME.equals(((PsiNamedElement)identifier).getName());
        }
        return false;
    }

    public static boolean isExit(@NotNull PsiElement element) {
        if (element == null) {
            RubyPsiUtilCore.$$$reportNull$$$0(27);
        }
        String name = null;
        if (element instanceof RPossibleCall) {
            name = ((RPossibleCall)element).getCommand();
        }
        if (element instanceof RIdentifier) {
            name = element.getText();
        }
        return name != null && EXIT_NAMES.contains(name);
    }

    public static boolean isDeclaration(@NotNull PsiElement element) {
        if (element == null) {
            RubyPsiUtilCore.$$$reportNull$$$0(28);
        }
        if (element instanceof RVariable) {
            return ((RVariable)element).isDeclaration();
        }
        return RubyPsiUtilCore.isDeclarationImpl(element);
    }

    public static boolean isDeclarationImpl(@NotNull PsiElement element) {
        if (element == null) {
            RubyPsiUtilCore.$$$reportNull$$$0(29);
        }
        return RAssignmentExpressionNavigator.getAssignmentByLeftPart(element) != null || RAssignmentExpressionNavigator.getQualifiedConstantAssignment(element) != null || RSelfAssignmentExpressionNavigator.getSelfAssignmentByLeftPart(element) != null || RubyUsageAnalyzerCore.isPatternMatchingAssignment(element) || RPredefinedArgumentNavigator.getByDeclaredElement(element) != null || RubyCallTypesCore.getDefinedAttributeName(element) != null || RubyCallTypesCore.isClassName(element) || RNamedArgumentNavigator.getByDeclaredElement(element) != null;
    }

    @Nullable
    public static RPsiElement getRealContext(@NotNull RPsiElement element) {
        if (element == null) {
            RubyPsiUtilCore.$$$reportNull$$$0(30);
        }
        if (!element.isValid()) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("RubyPsiUtil.getRealContext(" + String.valueOf(element) + ") called. Returned null. Element in invalid");
            }
            return null;
        }
        PsiFile file = element.getContainingFile();
        if (file instanceof RubyExpressionCodeFragment) {
            PsiElement context = file.getContext();
            if (LOG.isTraceEnabled()) {
                LOG.trace("RubyPsiUtil.getRealContext(" + String.valueOf(element) + ") is called. Returned " + String.valueOf(context) + ". Element inside code fragment");
            }
            return (RPsiElement)PsiTreeUtil.getParentOfType((PsiElement)context, (boolean)false, (Class[])new Class[]{RPsiElement.class});
        }
        PsiElement consoleContext = RubyLanguageConsoleUtil.getLanguageConsoleContext((PsiElement)element);
        if (consoleContext instanceof RPsiElement) {
            RPsiElement rconsoleContext = (RPsiElement)consoleContext;
            if (LOG.isTraceEnabled()) {
                LOG.trace("RubyPsiUtil.getRealContext(" + String.valueOf(element) + ") is called. Returned " + String.valueOf(rconsoleContext) + ". Element inside console");
            }
            return rconsoleContext;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("RubyPsiUtil.getRealContext(" + String.valueOf(element) + ") is called. Returned " + String.valueOf(element) + ".");
        }
        return element;
    }

    public static boolean isSelfObject(@Nullable RClassObject object) {
        return object != null && object.getFirstChild() instanceof RPseudoConstant && RubyTokenTypes.kSELF.toString().equals(object.getFirstChild().getText());
    }

    @Nullable
    public static RPsiElement getDeclaration(@NotNull PsiElement element) {
        RAssignmentExpression assign;
        if (element == null) {
            RubyPsiUtilCore.$$$reportNull$$$0(31);
        }
        if ((assign = RAssignmentExpressionNavigator.getAssignmentByLeftPart(element)) != null) {
            return assign;
        }
        assign = RAssignmentExpressionNavigator.getQualifiedConstantAssignment(element);
        if (assign != null) {
            return assign;
        }
        RSelfAssignmentExpression selfAssign = RSelfAssignmentExpressionNavigator.getSelfAssignmentByLeftPart(element);
        if (selfAssign != null) {
            return selfAssign;
        }
        RArgument predefined = RPredefinedArgumentNavigator.getByDeclaredElement(element);
        if (predefined != null) {
            return predefined;
        }
        if (RubyCallTypesCore.getDefinedAttributeName(element) != null || RubyCallTypesCore.isClassName(element)) {
            return RCallNavigator.getByRArgument(element.getNavigationElement());
        }
        return RNamedArgumentNavigator.getByDeclaredElement(element);
    }

    public static boolean isPragmaComment(@NotNull PsiComment comment) {
        if (comment == null) {
            RubyPsiUtilCore.$$$reportNull$$$0(32);
        }
        if (PsiUtilCore.getElementType((PsiElement)comment) != RubyTokenTypes.TLINE_COMMENT) {
            return false;
        }
        String text = StringUtil.trimStart((String)StringUtil.notNullize((String)comment.getText()), (String)"#");
        String candidate = StringUtil.substringBefore((String)text, (String)":");
        return candidate != null && PRAGMAS.contains(candidate.trim());
    }

    @Nullable
    public static PsiElement getSignificantLeafToTheRight(PsiElement leaf) {
        while (leaf != null && (leaf instanceof PsiWhiteSpace || ((TokenSet)RubyCommonPsiUtil.INSIGNIFICANT_TOKENS.get()).contains(leaf.getNode().getElementType()))) {
            leaf = PsiTreeUtil.nextLeaf((PsiElement)leaf);
        }
        return leaf;
    }

    public static boolean isRClassName(@Nullable PsiElement element) {
        PsiElement grandParent;
        if (!(element instanceof RConstant)) {
            return false;
        }
        PsiElement parent = element.getParent();
        if (parent == null) {
            return false;
        }
        PsiElement nameElement = null;
        if (parent instanceof RNameImpl) {
            nameElement = parent;
        } else if ((parent instanceof RColonReference && PsiTreeUtil.getDeepestLast((PsiElement)parent) == element || parent instanceof RTopConstReference && ((RTopConstReference)parent).getConstant() == element) && (grandParent = parent.getParent()) instanceof RNameImpl) {
            nameElement = grandParent;
        }
        if (nameElement == null) {
            return false;
        }
        PsiElement nameParent = nameElement.getParent();
        return nameParent instanceof RClass || nameParent instanceof RModule;
    }

    @Contract(value="null -> false")
    public static boolean isVisibilityModifier(@Nullable PsiElement element) {
        return element instanceof RIdentifier && RubyPsiUtilCore.textMatchesAny(element, VISIBILITY_MODIFIER_COMMANDS);
    }

    @Contract(value="null, _ -> false")
    public static boolean textMatchesAny(@Nullable PsiElement element, CharSequence ... texts) {
        if (texts == null) {
            RubyPsiUtilCore.$$$reportNull$$$0(33);
        }
        if (element != null) {
            for (CharSequence text : texts) {
                if (!element.textMatches(text)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasNonEditableFragment(@NotNull Project project, @NotNull Document document, @NotNull PsiElement element) {
        if (project == null) {
            RubyPsiUtilCore.$$$reportNull$$$0(34);
        }
        if (document == null) {
            RubyPsiUtilCore.$$$reportNull$$$0(35);
        }
        if (element == null) {
            RubyPsiUtilCore.$$$reportNull$$$0(36);
        }
        TextRange range = element.getTextRange();
        if (document instanceof DocumentWindow) {
            DocumentWindow window = (DocumentWindow)document;
            TextRange nonEditableRange = TextRangeUtil.getEnclosingTextRange((List)InjectedLanguageManager.getInstance((Project)project).getNonEditableFragments(window));
            return nonEditableRange.intersects(range);
        }
        return document.getRangeGuard(range.getStartOffset(), range.getEndOffset()) != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 8, 14, 17, 18, 19 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldElement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElement";
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 14: 
            case 17: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/lang/psi/RubyPsiUtilCore";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 11: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namedElement";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compoundStatement";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element2";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "texts";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/lang/psi/RubyPsiUtilCore";
                break;
            }
            case 3: 
            case 4: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildrenByFilter";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildrenIterator";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageLevel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getElementText";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "replaceInParent";
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 14: 
            case 17: 
            case 18: 
            case 19: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getChildrenIterator";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getNextSuitableElement";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getChildByFilter";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getLanguageLevel";
                break;
            }
            case 15: 
            case 16: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getChildrenByFilter";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "setElementName";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getStatement";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isBefore";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "isInfiniteLoop";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isExit";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "isDeclaration";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "isDeclarationImpl";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getRealContext";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getDeclaration";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "isPragmaComment";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "textMatchesAny";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "hasNonEditableFragment";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 8, 14, 17, 18, 19 -> new IllegalStateException(string);
        };
    }
}

