/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang.documentation;

import com.intellij.lang.Language;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rdoc.yard.YARDParser;
import org.jetbrains.plugins.ruby.rdoc.yard.YARDTag;
import org.jetbrains.plugins.ruby.rdoc.yard.tags.YARDParamTag;
import org.jetbrains.plugins.ruby.rdoc.yard.tags.YARDTypeTag;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.ArgumentFakePsiElement;
import org.jetbrains.plugins.ruby.ruby.codeInsight.usages.RubyUsageAnalyzerCore;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypes;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RMethodWithPossibleInlineVisibilityModifier;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubySpaceUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.RSymbol;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RBodyStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RCompoundStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RAssignmentExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.controlStructures.VisibilityUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RConstant;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RGlobalVariable;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RIdentifier;

public final class RubyCommentsUtilCore {
    public static final Map<String, String> TYPE_ABBREVIATIONS = Map.ofEntries(Map.entry("false", "FalseClass"), Map.entry("nil", "NilClass"), Map.entry("true", "TrueClass"));
    private static final Pattern UNSHARPING_PATTERN = Pattern.compile("^##+\n|^#", 8);

    private RubyCommentsUtilCore() {
    }

    @NotNull
    public static List<PsiComment> getPsiComments(@NotNull PsiElement element) {
        if (element == null) {
            RubyCommentsUtilCore.$$$reportNull$$$0(0);
        }
        PsiElement anchor = element;
        RMethodWithPossibleInlineVisibilityModifier methodWithPossibleInlineVisibilityModifier = RMethodWithPossibleInlineVisibilityModifier.from(element);
        if (RubyPsiUtilCore.isDeclaration(element) && (element instanceof RConstant || element instanceof RGlobalVariable || element instanceof ArgumentFakePsiElement || element instanceof RSymbol)) {
            RPsiElement decl = RubyPsiUtilCore.getDeclaration(element);
            assert (decl != null);
            anchor = decl;
        } else if (element instanceof RIdentifier) {
            anchor = (PsiElement)ObjectUtils.chooseNotNull((Object)RubyCommentsUtilCore.getAnchorForIdentifier((RIdentifier)element), (Object)element);
        } else if (methodWithPossibleInlineVisibilityModifier != null && methodWithPossibleInlineVisibilityModifier.getVisibilityCall() != null) {
            anchor = methodWithPossibleInlineVisibilityModifier.getVisibilityCall();
        }
        List<PsiComment> comments = RubyCommentsUtilCore.getPsiCommentsByAnchor(anchor);
        if (!comments.isEmpty()) {
            List<PsiComment> list = comments;
            if (list == null) {
                RubyCommentsUtilCore.$$$reportNull$$$0(1);
            }
            return list;
        }
        RPsiElement prev = (RPsiElement)PsiTreeUtil.getPrevSiblingOfType((PsiElement)anchor, RPsiElement.class);
        if (prev instanceof RIdentifier && VisibilityUtilCore.getVisibility(prev.getText()) != null) {
            anchor = prev;
        }
        return RubyCommentsUtilCore.getPsiCommentsByAnchor(anchor);
    }

    @Nullable
    private static PsiElement getAnchorForIdentifier(@NotNull RIdentifier element) {
        boolean isMethodParameter;
        if (element == null) {
            RubyCommentsUtilCore.$$$reportNull$$$0(2);
        }
        if (isMethodParameter = RubyUsageAnalyzerCore.isMethodParameter((RPsiElement)element)) {
            return null;
        }
        boolean isBlockParameter = RubyUsageAnalyzerCore.isBlockParameter((RPsiElement)element) || RubyUsageAnalyzerCore.isBlockCallLocalDeclaration((RPsiElement)element);
        boolean isVariableDeclaration = RubyPsiUtilCore.isDeclaration((PsiElement)element);
        if (!isBlockParameter && !isVariableDeclaration) {
            return null;
        }
        return RubyCommentsUtilCore.getParentCommentOwnerForIdentifier(element, isMethodParameter, isBlockParameter, isVariableDeclaration);
    }

    @Nullable
    public static PsiElement getParentCommentOwnerForIdentifier(@NotNull RIdentifier element, boolean isMethodParameter, boolean isBlockParameter, boolean isVariableDeclaration) {
        if (element == null) {
            RubyCommentsUtilCore.$$$reportNull$$$0(3);
        }
        if (isMethodParameter) {
            return PsiTreeUtil.getParentOfType((PsiElement)element, RMethod.class);
        }
        if (isBlockParameter) {
            return RubyCommentsUtilCore.getParentCommentOwnerForBlockParameter(element);
        }
        if (isVariableDeclaration) {
            return PsiTreeUtil.getParentOfType((PsiElement)element, RAssignmentExpression.class);
        }
        throw new IllegalArgumentException("one of the three bools must be true!");
    }

    @NotNull
    private static PsiElement getParentCommentOwnerForBlockParameter(@NotNull RIdentifier element) {
        if (element == null) {
            RubyCommentsUtilCore.$$$reportNull$$$0(4);
        }
        PsiElement run = PsiTreeUtil.prevLeaf((PsiElement)element);
        RIdentifier firstElementInTheLine = element;
        while (run != null && !RubySpaceUtil.isAnyNewLine((PsiElement)run)) {
            firstElementInTheLine = run;
            run = PsiTreeUtil.prevLeaf((PsiElement)run);
        }
        RIdentifier rIdentifier = firstElementInTheLine;
        if (rIdentifier == null) {
            RubyCommentsUtilCore.$$$reportNull$$$0(5);
        }
        return rIdentifier;
    }

    @NotNull
    private static PsiElement prepareAnchor(@NotNull PsiElement anchor) {
        PsiElement parent;
        if (anchor == null) {
            RubyCommentsUtilCore.$$$reportNull$$$0(6);
        }
        while (anchor.getPrevSibling() == null && ((parent = anchor.getParent()) instanceof RCompoundStatement || parent instanceof RBodyStatement)) {
            anchor = parent;
        }
        PsiElement psiElement = anchor;
        if (psiElement == null) {
            RubyCommentsUtilCore.$$$reportNull$$$0(7);
        }
        return psiElement;
    }

    @NotNull
    private static List<PsiComment> getPsiCommentsByAnchor(@NotNull PsiElement anchor) {
        PsiElement element;
        PsiComment comment;
        if (anchor == null) {
            RubyCommentsUtilCore.$$$reportNull$$$0(8);
        }
        if ((comment = RubyCommentsUtilCore.getPrevComment(element = RubyCommentsUtilCore.prepareAnchor(anchor), RubyTokenTypes.tBLOCK_COMMENT)) != null) {
            List<PsiComment> list = Collections.singletonList(comment);
            if (list == null) {
                RubyCommentsUtilCore.$$$reportNull$$$0(9);
            }
            return list;
        }
        LinkedList<PsiComment> comments = new LinkedList<PsiComment>();
        while ((element = RubyCommentsUtilCore.getPrevComment(element, RubyTokenTypes.TLINE_COMMENT)) != null) {
            comments.addFirst((PsiComment)element);
        }
        LinkedList<PsiComment> linkedList = comments;
        if (linkedList == null) {
            RubyCommentsUtilCore.$$$reportNull$$$0(10);
        }
        return linkedList;
    }

    @Nullable
    public static PsiComment getPrevComment(@NotNull PsiElement anchorElement, @NotNull IElementType commentType) {
        if (anchorElement == null) {
            RubyCommentsUtilCore.$$$reportNull$$$0(11);
        }
        if (commentType == null) {
            RubyCommentsUtilCore.$$$reportNull$$$0(12);
        }
        PsiElement comment = PsiTreeUtil.prevLeaf((PsiElement)anchorElement);
        while (PsiUtilCore.getElementType((PsiElement)comment) != commentType) {
            if (RubySpaceUtil.isSingleSoftNewLine((PsiElement)comment) || comment != null && comment.getLanguage() == Language.ANY) {
                comment = PsiTreeUtil.prevLeaf((PsiElement)comment);
                continue;
            }
            return null;
        }
        return (PsiComment)comment;
    }

    @NotNull
    public static String normalizeTypeName(@NotNull String helpType) {
        if (helpType == null) {
            RubyCommentsUtilCore.$$$reportNull$$$0(13);
        }
        String string = TYPE_ABBREVIATIONS.getOrDefault(helpType, StringUtil.capitalize((String)helpType));
        if (string == null) {
            RubyCommentsUtilCore.$$$reportNull$$$0(14);
        }
        return string;
    }

    @Contract(value="null->null; !null->!null")
    @Nullable
    public static String unsharpText(@Nullable String originalText) {
        if (originalText == null) {
            return null;
        }
        return UNSHARPING_PATTERN.matcher(originalText.trim()).replaceAll("");
    }

    @Nullable
    public static String getPsiHelpWithoutLeadingSharps(@NotNull PsiElement element) {
        String helpWithSharps;
        if (element == null) {
            RubyCommentsUtilCore.$$$reportNull$$$0(15);
        }
        return (helpWithSharps = RubyCommentsUtilCore.getPsiHelp(element)) == null ? null : RubyCommentsUtilCore.unsharpText(helpWithSharps);
    }

    @Nullable
    public static String getPsiHelp(@NotNull PsiElement element) {
        String helpFromTags;
        if (element == null) {
            RubyCommentsUtilCore.$$$reportNull$$$0(16);
        }
        if (!element.isValid()) {
            return null;
        }
        if (element instanceof RIdentifier && (helpFromTags = RubyCommentsUtilCore.getPsiHelpForIdentifier((RIdentifier)element)) != null) {
            return helpFromTags;
        }
        List<PsiComment> comments = RubyCommentsUtilCore.getPsiComments(element);
        return RubyCommentsUtilCore.joinComments(comments);
    }

    @Nullable
    public static String joinComments(@NotNull List<? extends PsiComment> list) {
        if (list == null) {
            RubyCommentsUtilCore.$$$reportNull$$$0(17);
        }
        StringBuilder buffer = new StringBuilder();
        for (PsiComment psiComment : list) {
            if (!buffer.isEmpty()) {
                buffer.append("\n");
            }
            buffer.append(psiComment.getText());
        }
        return !buffer.isEmpty() ? buffer.toString() : null;
    }

    @Nullable
    public static String getPsiHelpForIdentifier(RIdentifier element) {
        boolean isMethodParameter = RubyUsageAnalyzerCore.isMethodParameter((RPsiElement)element);
        boolean isBlockParameter = RubyUsageAnalyzerCore.isBlockParameter((RPsiElement)element) || RubyUsageAnalyzerCore.isBlockCallLocalDeclaration((RPsiElement)element);
        boolean isVariableDeclaration = RubyPsiUtilCore.isDeclaration((PsiElement)element);
        if (!(isMethodParameter || isBlockParameter || isVariableDeclaration)) {
            return null;
        }
        PsiElement commentOwner = RubyCommentsUtilCore.getParentCommentOwnerForIdentifier(element, isMethodParameter, isBlockParameter, isVariableDeclaration);
        if (commentOwner == null) {
            return null;
        }
        List<PsiComment> comments = RubyCommentsUtilCore.getPsiComments(commentOwner);
        String name = element.getName();
        if (name == null) {
            return null;
        }
        for (YARDTag yardTag : YARDParser.parse(comments)) {
            if (isMethodParameter && yardTag instanceof YARDParamTag && name.equals(((YARDParamTag)yardTag).getName())) {
                return ((YARDParamTag)yardTag).getDescription();
            }
            if (!isBlockParameter && !isVariableDeclaration || !(yardTag instanceof YARDTypeTag) || !name.equals(((YARDTypeTag)yardTag).getName())) continue;
            return ((YARDTypeTag)yardTag).getDescription();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 5, 7, 9, 10, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/lang/documentation/RubyCommentsUtilCore";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchorElement";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commentType";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helpType";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/lang/documentation/RubyCommentsUtilCore";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiComments";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getParentCommentOwnerForBlockParameter";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareAnchor";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiCommentsByAnchor";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "normalizeTypeName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPsiComments";
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 14: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getAnchorForIdentifier";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getParentCommentOwnerForIdentifier";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getParentCommentOwnerForBlockParameter";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "prepareAnchor";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getPsiCommentsByAnchor";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getPrevComment";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "normalizeTypeName";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getPsiHelpWithoutLeadingSharps";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getPsiHelp";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "joinComments";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 5, 7, 9, 10, 14 -> new IllegalStateException(string);
        };
    }
}

