/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.usages;

import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.assoc.RAssoc;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RForStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RWhenCase;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RCompoundStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RArgument;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RBlockArgumentList;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RNamedArgument;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.patternMatching.RGuardedPatternBase;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.patternMatching.RInMatch;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.assoc.RAssocNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.controlStructures.blocks.RRescueBlockNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.controlStructures.methods.RArgumentListNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.controlStructures.methods.arguments.RArgumentNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RCodeBlock;
import org.jetbrains.plugins.ruby.ruby.lang.psi.ruby19.RAssocKey;
import org.jetbrains.plugins.ruby.ruby.lang.psi.ruby19.controlStructures.RBlockLocalVariables;
import org.jetbrains.plugins.ruby.ruby.lang.psi.ruby19.controlStructures.RLambda;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RFid;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RIdentifier;

public final class RubyUsageAnalyzerCore {
    private RubyUsageAnalyzerCore() {
    }

    public static boolean isPatternMatchingAssignment(@NotNull PsiElement element) {
        if (element == null) {
            RubyUsageAnalyzerCore.$$$reportNull$$$0(0);
        }
        if (!(element instanceof RIdentifier) && !(element instanceof RFid)) {
            return false;
        }
        RAssoc assoc = (RAssoc)ObjectUtils.doIfCast((Object)element.getParent(), RAssocKey.class, RAssocNavigator::getAssocByKey);
        if (assoc != null && assoc.getValue() != null) {
            return false;
        }
        RInMatch inMatch = (RInMatch)PsiTreeUtil.getParentOfType((PsiElement)element, RInMatch.class);
        return inMatch != null && PsiTreeUtil.isAncestor((PsiElement)inMatch.getPattern(), (PsiElement)element, (boolean)false);
    }

    public static boolean isParameter(@NotNull RPsiElement element) {
        if (element == null) {
            RubyUsageAnalyzerCore.$$$reportNull$$$0(1);
        }
        return RubyUsageAnalyzerCore.isParameterInScope(element) || RubyUsageAnalyzerCore.isForParameter(element) || RubyUsageAnalyzerCore.isRescueParameter(element) || RubyUsageAnalyzerCore.isPatternMatchingParameter(element);
    }

    public static boolean isParameterInScope(@NotNull RPsiElement element) {
        if (element == null) {
            RubyUsageAnalyzerCore.$$$reportNull$$$0(2);
        }
        return RubyUsageAnalyzerCore.isMethodParameter(element) || RubyUsageAnalyzerCore.isBlockParameter(element) || RubyUsageAnalyzerCore.isLambdaParameter(element) || RubyUsageAnalyzerCore.isBlockCallLocalDeclaration(element);
    }

    public static boolean isRescueParameter(RPsiElement element) {
        return RRescueBlockNavigator.getByRPsiElement(element) != null;
    }

    public static boolean isForParameter(RPsiElement element) {
        PsiElement parent = element.getParent();
        return parent instanceof RForStatement && ((RForStatement)parent).getVariable() == element;
    }

    public static boolean isBlockParameter(RPsiElement element) {
        return RArgumentListNavigator.getByArgumentContents(element) instanceof RBlockArgumentList;
    }

    public static boolean isMethodParameter(RPsiElement element) {
        RArgument arg = RArgumentNavigator.getByParameter(element);
        return arg != null && PsiTreeUtil.getParentOfType((PsiElement)arg, (Class[])new Class[]{RMethod.class, RLambda.class, RBlockArgumentList.class, RBlockLocalVariables.class}) instanceof RMethod;
    }

    public static boolean isLambdaParameter(RPsiElement element) {
        RArgument arg = RArgumentNavigator.getByParameter(element);
        return arg != null && PsiTreeUtil.getParentOfType((PsiElement)arg, (Class[])new Class[]{RMethod.class, RLambda.class, RBlockArgumentList.class, RBlockLocalVariables.class}) instanceof RLambda;
    }

    public static boolean isBlockCallLocalDeclaration(RPsiElement element) {
        PsiElement parent = element.getParent();
        return parent instanceof RBlockLocalVariables;
    }

    public static boolean isPatternMatchingParameter(RPsiElement element) {
        PsiElement parent = PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{RWhenCase.class, RCompoundStatement.class, RGuardedPatternBase.class, RAssoc.class});
        while (parent instanceof RAssoc) {
            if (((RAssoc)parent).getValue() != null && !PsiTreeUtil.isAncestor((PsiElement)((RAssoc)parent).getValue(), (PsiElement)element, (boolean)false)) {
                return false;
            }
            parent = PsiTreeUtil.getParentOfType((PsiElement)parent, (Class[])new Class[]{RWhenCase.class, RCompoundStatement.class, RGuardedPatternBase.class, RAssoc.class});
        }
        if (parent instanceof RGuardedPatternBase) {
            return PsiTreeUtil.isAncestor((PsiElement)((RGuardedPatternBase)parent).getPattern(), (PsiElement)element, (boolean)false);
        }
        return parent instanceof RWhenCase && ((RWhenCase)parent).isPatternMatching();
    }

    public static boolean isNamedParameter(@NotNull RPsiElement element) {
        if (element == null) {
            RubyUsageAnalyzerCore.$$$reportNull$$$0(3);
        }
        RArgument arg = RArgumentNavigator.getByParameter(element);
        return arg instanceof RNamedArgument;
    }

    public static RPsiElement getParameterScope(@NotNull RPsiElement element) {
        RCodeBlock codeBlock;
        if (element == null) {
            RubyUsageAnalyzerCore.$$$reportNull$$$0(4);
        }
        if (RubyUsageAnalyzerCore.isMethodParameter(element)) {
            return (RPsiElement)PsiTreeUtil.getParentOfType((PsiElement)element, RMethod.class);
        }
        if (RubyUsageAnalyzerCore.isRescueParameter(element)) {
            return RRescueBlockNavigator.getByRPsiElement(element);
        }
        if (RubyUsageAnalyzerCore.isBlockParameter(element) && (codeBlock = (RCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)element, RCodeBlock.class)) != null) {
            return codeBlock.getBlockCall();
        }
        if (RubyUsageAnalyzerCore.isForParameter(element)) {
            return (RPsiElement)PsiTreeUtil.getParentOfType((PsiElement)element, RForStatement.class);
        }
        if (RubyUsageAnalyzerCore.isLambdaParameter(element)) {
            return (RPsiElement)PsiTreeUtil.getParentOfType((PsiElement)element, RLambda.class);
        }
        if (RubyUsageAnalyzerCore.isBlockCallLocalDeclaration(element)) {
            return (RPsiElement)PsiTreeUtil.getParentOfType((PsiElement)element, RCodeBlock.class);
        }
        if (RubyUsageAnalyzerCore.isPatternMatchingParameter(element)) {
            return (RPsiElement)PsiTreeUtil.getParentOfType((PsiElement)element, RWhenCase.class);
        }
        if (RubyUsageAnalyzerCore.isNumberedParameter(element)) {
            return (RPsiElement)PsiTreeUtil.getParentOfType((PsiElement)element, RCodeBlock.class);
        }
        throw new IllegalStateException("Cannot be called for not parameter: " + String.valueOf(element));
    }

    public static boolean isNumberedParameter(RPsiElement element) {
        return element instanceof RIdentifier && ((RIdentifier)element).isNumberedParameter();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "element";
        objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/usages/RubyUsageAnalyzerCore";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isPatternMatchingAssignment";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isParameter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isParameterInScope";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isNamedParameter";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getParameterScope";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

