/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.types;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.CoreFqns;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.MultiSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RIntersectionType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RSymbolType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RUnionType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.impl.RDelegatedType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.impl.REmptyType;

public final class RTypeUtilCore {
    private RTypeUtilCore() {
    }

    public static Collection<? extends Symbol> intersection(@NotNull Collection<? extends Symbol> collection1, @NotNull Collection<? extends Symbol> collection2) {
        if (collection1 == null) {
            RTypeUtilCore.$$$reportNull$$$0(0);
        }
        if (collection2 == null) {
            RTypeUtilCore.$$$reportNull$$$0(1);
        }
        if (collection1.isEmpty()) {
            return collection2;
        }
        if (collection2.isEmpty()) {
            return collection1;
        }
        HashMap<String, Symbol> map1 = new HashMap<String, Symbol>();
        for (Symbol symbol : collection1) {
            ProgressManager.checkCanceled();
            String string = symbol.getName();
            if (string == null) continue;
            map1.put(string, symbol);
        }
        HashMap<String, Symbol> map2 = new HashMap<String, Symbol>();
        for (Symbol symbol : collection2) {
            ProgressManager.checkCanceled();
            String name = symbol.getName();
            if (name == null) continue;
            map2.put(name, symbol);
        }
        ArrayList<Symbol> arrayList = new ArrayList<Symbol>();
        Set set = map1.keySet();
        Set names2 = map2.keySet();
        for (String name : set) {
            Symbol symbol2;
            ProgressManager.checkCanceled();
            if (!names2.contains(name)) continue;
            Symbol symbol1 = (Symbol)map1.get(name);
            if (Comparing.equal((Object)symbol1, (Object)(symbol2 = (Symbol)map2.get(name)))) {
                arrayList.add(symbol1);
                continue;
            }
            arrayList.add(MultiSymbol.of(symbol1, symbol2));
        }
        return arrayList;
    }

    public static Collection<? extends Symbol> union(@NotNull Collection<? extends Symbol> collection1, @NotNull Collection<? extends Symbol> collection2) {
        if (collection1 == null) {
            RTypeUtilCore.$$$reportNull$$$0(2);
        }
        if (collection2 == null) {
            RTypeUtilCore.$$$reportNull$$$0(3);
        }
        if (collection1.isEmpty()) {
            return collection2;
        }
        if (collection2.isEmpty()) {
            return collection1;
        }
        HashMap<String, Symbol> map1 = new HashMap<String, Symbol>();
        for (Symbol symbol : collection1) {
            ProgressManager.checkCanceled();
            String string = symbol.getName();
            if (string == null) continue;
            map1.put(string, symbol);
        }
        HashMap<String, Symbol> map2 = new HashMap<String, Symbol>();
        for (Symbol symbol : collection2) {
            ProgressManager.checkCanceled();
            String name = symbol.getName();
            if (name == null) continue;
            map2.put(name, symbol);
        }
        HashSet hashSet = new HashSet();
        hashSet.addAll(map1.keySet());
        hashSet.addAll(map2.keySet());
        ArrayList<Symbol> arrayList = new ArrayList<Symbol>(hashSet.size());
        for (String name : hashSet) {
            ProgressManager.checkCanceled();
            Symbol symbol1 = (Symbol)map1.get(name);
            Symbol symbol2 = (Symbol)map2.get(name);
            if (symbol1 == null) {
                arrayList.add(symbol2);
                continue;
            }
            if (symbol2 == null) {
                arrayList.add(symbol1);
                continue;
            }
            if (Comparing.equal((Object)symbol1, (Object)symbol2)) {
                arrayList.add(symbol1);
                continue;
            }
            arrayList.add(MultiSymbol.of(symbol1, symbol2));
        }
        return arrayList;
    }

    @Nullable
    public static Symbol union(@Nullable Symbol first, @Nullable Symbol second) {
        if (first == null || second == null || Comparing.equal((Object)first, (Object)second)) {
            return (Symbol)ObjectUtils.coalesce((Object)first, (Object)second);
        }
        return MultiSymbol.of(first, second);
    }

    public static boolean isNullOrEmpty(@Nullable RType type) {
        return type == null || type == REmptyType.INSTANCE;
    }

    public static boolean isNotEmpty(@Nullable RType type) {
        return !RTypeUtilCore.isNullOrEmpty(type);
    }

    public static boolean isArrayType(@NotNull RType type) {
        Symbol symbol;
        if (type == null) {
            RTypeUtilCore.$$$reportNull$$$0(4);
        }
        return (symbol = RTypeUtilCore.getBirthTypeSymbol(type)) != null && symbol.getFQNWithNesting().equals(CoreFqns.ARRAY);
    }

    @Nullable
    public static Symbol getBirthTypeSymbol(@Nullable RType type) {
        return (Symbol)ObjectUtils.doIfCast((Object)RTypeUtilCore.getOriginalType(type), RSymbolType.class, RSymbolType::getSymbol);
    }

    @Nullable
    private static RType getOriginalType(@Nullable RType type) {
        if (type instanceof RDelegatedType) {
            return RTypeUtilCore.getOriginalType(((RDelegatedType)type).getOriginalType());
        }
        if (type instanceof RIntersectionType) {
            return RTypeUtilCore.getOriginalType((RType)ContainerUtil.getFirstItem((List)((RIntersectionType)type).getTypes()));
        }
        if (type instanceof RUnionType) {
            return RTypeUtilCore.getOriginalType((RType)ContainerUtil.getFirstItem((List)((RUnionType)type).getTypes()));
        }
        return type;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection1";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection2";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/types/RTypeUtilCore";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "intersection";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "union";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isArrayType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

