/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Type;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.TypeSet;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.v2.SymbolPsiProcessor;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.v2.TopLevelSymbol;

public class SymbolImpl
implements Symbol {
    protected final Project myProject;
    protected final String myName;
    protected final Type myType;
    protected final Symbol myParent;
    private final Icon myExplicitIcon;

    public SymbolImpl(@NotNull Project project, @Nullable String name, @NotNull Type type, @Nullable Symbol parent) {
        if (project == null) {
            SymbolImpl.$$$reportNull$$$0(0);
        }
        if (type == null) {
            SymbolImpl.$$$reportNull$$$0(1);
        }
        this(project, name, null, type, parent);
    }

    public SymbolImpl(@NotNull Project project, @Nullable String name, @Nullable Icon explicitIcon, @NotNull Type type, @Nullable Symbol parent) {
        if (project == null) {
            SymbolImpl.$$$reportNull$$$0(2);
        }
        if (type == null) {
            SymbolImpl.$$$reportNull$$$0(3);
        }
        this.myProject = project;
        this.myName = name;
        this.myType = type;
        this.myParent = parent;
        this.myExplicitIcon = explicitIcon;
    }

    @Nullable
    public String getName() {
        return this.myName;
    }

    @NotNull
    public FQN getFQNWithNesting() {
        String name = this.getName();
        if (name == null) {
            FQN fQN = FQN.INVALID;
            if (fQN == null) {
                SymbolImpl.$$$reportNull$$$0(4);
            }
            return fQN;
        }
        FQN currentFQN = FQN.Builder.fromString((String)name);
        Symbol parentSymbol = this.getParentSymbol();
        if (parentSymbol == null || parentSymbol instanceof TopLevelSymbol) {
            FQN fQN = currentFQN;
            if (fQN == null) {
                SymbolImpl.$$$reportNull$$$0(5);
            }
            return fQN;
        }
        FQN fQN = FQN.Builder.concat((FQN)parentSymbol.getFQNWithNesting(), (FQN)currentFQN);
        if (fQN == null) {
            SymbolImpl.$$$reportNull$$$0(6);
        }
        return fQN;
    }

    @NotNull
    public Type getType() {
        Type type = this.myType;
        if (type == null) {
            SymbolImpl.$$$reportNull$$$0(7);
        }
        return type;
    }

    @Nullable
    public Symbol getParentSymbol() {
        return this.myParent;
    }

    @Nullable
    public Icon getExplicitIcon() {
        return this.myExplicitIcon;
    }

    public PsiElement getPsiElement() {
        return null;
    }

    @NotNull
    public Collection<? extends PsiElement> getAllDeclarations(@Nullable PsiElement invocationPoint) {
        List list = Collections.emptyList();
        if (list == null) {
            SymbolImpl.$$$reportNull$$$0(8);
        }
        return list;
    }

    public boolean processChildren(SymbolPsiProcessor processor, PsiElement invocationPoint) {
        return true;
    }

    @NotNull
    public List<Symbol> getChildren(Type type, PsiElement invocationPoint) {
        List list = Symbol.getSymbolsByFilter((Symbol)this, (Predicate)Symbol.Filter.byType((Type)type), (PsiElement)invocationPoint);
        if (list == null) {
            SymbolImpl.$$$reportNull$$$0(9);
        }
        return list;
    }

    @NotNull
    public List<Symbol> getChildren(TypeSet types, PsiElement invocationPoint) {
        List list = Symbol.getSymbolsByFilter((Symbol)this, (Predicate)Symbol.Filter.byTypes((TypeSet)types), (PsiElement)invocationPoint);
        if (list == null) {
            SymbolImpl.$$$reportNull$$$0(10);
        }
        return list;
    }

    @Nullable
    public Module getModule() {
        return null;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            SymbolImpl.$$$reportNull$$$0(11);
        }
        return project;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SymbolImpl symbol = (SymbolImpl)o;
        if (!Objects.equals(this.myExplicitIcon, symbol.myExplicitIcon)) {
            return false;
        }
        if (!Objects.equals(this.myName, symbol.myName)) {
            return false;
        }
        if (!Objects.equals(this.myParent, symbol.myParent)) {
            return false;
        }
        return Objects.equals(this.myType, symbol.myType);
    }

    public int hashCode() {
        int result = this.myName != null ? this.myName.hashCode() : 0;
        result = 31 * result + (this.myType != null ? this.myType.hashCode() : 0);
        result = 31 * result + (this.myExplicitIcon != null ? this.myExplicitIcon.hashCode() : 0);
        result = 31 * result + (this.myParent != null ? this.myParent.hashCode() : 0);
        return result;
    }

    @NotNull
    public String toString() {
        String string = "%s{myName='%s', myType=%s, myParent=%s}".formatted(this.getClass().getSimpleName(), this.myName, this.myType, this.myParent);
        if (string == null) {
            SymbolImpl.$$$reportNull$$$0(12);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 7, 8, 9, 10, 11, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/codeInsight/symbols/structure/SymbolImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/symbols/structure/SymbolImpl";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFQNWithNesting";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllDeclarations";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 7, 8, 9, 10, 11, 12 -> new IllegalStateException(string);
        };
    }
}

