/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.visitors;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.values.InvalidStringValue;
import org.jetbrains.plugins.ruby.ruby.codeInsight.values.StringValue;
import org.jetbrains.plugins.ruby.ruby.codeInsight.values.StringValueArray;
import org.jetbrains.plugins.ruby.ruby.codeInsight.values.StringValueUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.assoc.RAssoc;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.RFloatConstant;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.RIntegerConstant;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.RSymbol;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RExpressionSubstitution;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RStringLiteral;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RStrings;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RWords;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RArray;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RArrayIndexing;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RAssocList;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RArrayToArguments;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RDotReference;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RReference;
import org.jetbrains.plugins.ruby.ruby.lang.psi.ruby19.RAssocKey;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RFName;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RPseudoConstant;
import org.jetbrains.plugins.ruby.ruby.lang.psi.visitors.RubyElementVisitor;

public class PsiStringValueVisitor
extends RubyElementVisitor {
    private static final List<String> IGNORED_CALLS = List.of("freeze");
    @Nullable
    private StringValue myResult;
    @NotNull
    private final Function<RPsiElement, StringValue> myElementToStringValue;

    public PsiStringValueVisitor(@NotNull Function<RPsiElement, StringValue> elementToStringValue) {
        if (elementToStringValue == null) {
            PsiStringValueVisitor.$$$reportNull$$$0(0);
        }
        this.myElementToStringValue = elementToStringValue.andThen(value -> (StringValue)ObjectUtils.coalesce((Object)value, (Object)InvalidStringValue.INSTANCE));
    }

    public void visitRSymbol(@NotNull RSymbol rSymbol) {
        if (rSymbol == null) {
            PsiStringValueVisitor.$$$reportNull$$$0(1);
        }
        this.myResult = rSymbol.getContent() instanceof RFName ? StringValueUtil.createSymbolStringValue((String)rSymbol.getValue()) : this.myElementToStringValue.apply((RPsiElement)rSymbol.getContent());
    }

    public void visitRDotReference(@NotNull RDotReference reference) {
        if (reference == null) {
            PsiStringValueVisitor.$$$reportNull$$$0(2);
        }
        RPsiElement receiver = reference.getReceiver();
        RPsiElement value = reference.getValue();
        if (receiver != null && value instanceof RPossibleCall && IGNORED_CALLS.contains(value.getName())) {
            this.myResult = this.myElementToStringValue.apply(receiver);
        }
    }

    public void visitRCall(@NotNull RCall call) {
        if (call == null) {
            PsiStringValueVisitor.$$$reportNull$$$0(3);
        }
        if (call.getPsiCommand() instanceof RReference) {
            this.myResult = this.myElementToStringValue.apply((RPsiElement)call.getPsiCommand());
        }
    }

    public void visitRDStringLiteral(@NotNull RStringLiteral rStringLiteral) {
        if (rStringLiteral == null) {
            PsiStringValueVisitor.$$$reportNull$$$0(4);
        }
        if (!rStringLiteral.hasExpressionSubstitutions()) {
            this.myResult = StringValueUtil.createConstantStringValue((String)rStringLiteral.getContent());
            return;
        }
        ArrayList<StringValue> stringParts = new ArrayList<StringValue>();
        for (PsiElement element : rStringLiteral.getPsiContent()) {
            StringValue value;
            if (element instanceof RExpressionSubstitution) {
                RPsiElement expression = ((RExpressionSubstitution)element).getExpression();
                if (expression == null) continue;
                value = this.myElementToStringValue.apply(expression).format();
            } else {
                value = StringValueUtil.createConstantStringValue((String)element.getText());
            }
            stringParts.add(value);
        }
        this.myResult = StringValueUtil.createStringValueConcatenation(stringParts);
    }

    public void visitRStringLiteral(@NotNull RStringLiteral rStringLiteral) {
        if (rStringLiteral == null) {
            PsiStringValueVisitor.$$$reportNull$$$0(5);
        }
        this.myResult = StringValueUtil.createConstantStringValue((String)rStringLiteral.getContent());
    }

    public void visitRStrings(@NotNull RStrings rStrings) {
        if (rStrings == null) {
            PsiStringValueVisitor.$$$reportNull$$$0(6);
        }
        ArrayList<StringValue> stringParts = new ArrayList<StringValue>();
        for (RStringLiteral literal : rStrings.getElements()) {
            StringValue value = this.myElementToStringValue.apply((RPsiElement)literal);
            if (value == null) {
                this.myResult = InvalidStringValue.INSTANCE;
                return;
            }
            stringParts.add(value);
        }
        this.myResult = StringValueUtil.createStringValueConcatenation(stringParts);
    }

    public void visitRWords(@NotNull RWords rWords) {
        if (rWords == null) {
            PsiStringValueVisitor.$$$reportNull$$$0(7);
        }
        this.visitRWordsInterface(rWords, StringValueUtil::createConstantStringValue);
    }

    public void visitRSymbols(@NotNull RWords rSymbols) {
        if (rSymbols == null) {
            PsiStringValueVisitor.$$$reportNull$$$0(8);
        }
        this.visitRWordsInterface(rSymbols, StringValueUtil::createSymbolStringValue);
    }

    public void visitRDWords(@NotNull RWords rdWords) {
        if (rdWords == null) {
            PsiStringValueVisitor.$$$reportNull$$$0(9);
        }
        this.visitRWordsInterface(rdWords, StringValueUtil::createConstantStringValue);
    }

    public void visitRDSymbols(@NotNull RWords rdSymbols) {
        if (rdSymbols == null) {
            PsiStringValueVisitor.$$$reportNull$$$0(10);
        }
        this.visitRWordsInterface(rdSymbols, StringValueUtil::createSymbolStringValue);
    }

    public void visitRArray(@NotNull RArray array) {
        if (array == null) {
            PsiStringValueVisitor.$$$reportNull$$$0(11);
        }
        ArrayList<StringValue> stringParts = new ArrayList<StringValue>();
        for (RPsiElement element : array.getElements()) {
            StringValue value = this.myElementToStringValue.apply(element);
            stringParts.add(value);
        }
        this.myResult = StringValueUtil.createStringValueArray(stringParts);
    }

    public void visitRAssocList(@NotNull RAssocList assocList) {
        if (assocList == null) {
            PsiStringValueVisitor.$$$reportNull$$$0(12);
        }
        HashMap<StringValue, ArrayList<StringValue>> stringListsMap = new HashMap<StringValue, ArrayList<StringValue>>();
        for (RAssoc assoc : assocList.getAssocElements()) {
            if (assoc.getKey() == null || assoc.getValue() == null) continue;
            StringValue keyValue = assoc.getKey() instanceof RAssocKey ? StringValueUtil.createSymbolStringValue((String)assoc.getKeyText()) : this.myElementToStringValue.apply(assoc.getKey());
            ArrayList<StringValue> stringValueList = stringListsMap.getOrDefault(keyValue, null);
            if (stringValueList == null) {
                stringValueList = new ArrayList<StringValue>();
                stringListsMap.put(keyValue, stringValueList);
            }
            stringValueList.add(this.myElementToStringValue.apply(assoc.getValue()));
        }
        HashMap<StringValue, StringValue> stringValueMap = new HashMap<StringValue, StringValue>();
        for (Map.Entry entry : stringListsMap.entrySet()) {
            stringValueMap.put((StringValue)entry.getKey(), StringValueUtil.createStringValueUnion((List)((List)entry.getValue())));
        }
        this.myResult = StringValueUtil.createStringValueHash(stringValueMap);
    }

    public void visitRArrayIndexing(@NotNull RArrayIndexing arrayIndexing) {
        RPsiElement receiver;
        if (arrayIndexing == null) {
            PsiStringValueVisitor.$$$reportNull$$$0(13);
        }
        if ((receiver = arrayIndexing.getReceiver()) == null) {
            return;
        }
        StringValue arrayValue = this.myElementToStringValue.apply(receiver);
        if (!(arrayValue instanceof StringValueArray)) {
            return;
        }
        List indexes = arrayIndexing.getIndexes();
        this.myResult = indexes.size() == 1 ? StringValueUtil.createStringValueUnion((List)((StringValueArray)arrayValue).getStringValueList()) : arrayValue;
    }

    public void visitRArrayToArguments(@NotNull RArrayToArguments rArrayToArguments) {
        if (rArrayToArguments == null) {
            PsiStringValueVisitor.$$$reportNull$$$0(14);
        }
        if (rArrayToArguments.getArray() == null) {
            return;
        }
        StringValue array = this.myElementToStringValue.apply(rArrayToArguments.getArray());
        if (array instanceof StringValueArray) {
            this.myResult = StringValueUtil.createStringValueUnion((List)((StringValueArray)array).getStringValueList());
        }
    }

    public void visitRPseudoConstant(@NotNull RPseudoConstant rPseudoConstant) {
        if (rPseudoConstant == null) {
            PsiStringValueVisitor.$$$reportNull$$$0(15);
        }
        this.myResult = StringValueUtil.createConstantStringValue((String)rPseudoConstant.getName());
    }

    public void visitRIntegerConstant(@NotNull RIntegerConstant rIntegerConstant) {
        if (rIntegerConstant == null) {
            PsiStringValueVisitor.$$$reportNull$$$0(16);
        }
        this.myResult = StringValueUtil.createNumericStringValue((String)((String)ObjectUtils.doIfNotNull((Object)rIntegerConstant.getValue(), it -> it.toString())));
    }

    public void visitRFloatConstant(@NotNull RFloatConstant rFloatConstant) {
        if (rFloatConstant == null) {
            PsiStringValueVisitor.$$$reportNull$$$0(17);
        }
        this.myResult = StringValueUtil.createNumericStringValue((String)((String)ObjectUtils.doIfNotNull((Object)rFloatConstant.getValue(), it -> it.toString())));
    }

    @Nullable
    public static StringValue inferStringValue(@NotNull RPsiElement element, @NotNull Function<RPsiElement, StringValue> elementToStringValue) {
        if (element == null) {
            PsiStringValueVisitor.$$$reportNull$$$0(18);
        }
        if (elementToStringValue == null) {
            PsiStringValueVisitor.$$$reportNull$$$0(19);
        }
        PsiStringValueVisitor psiStringValueVisitor = new PsiStringValueVisitor(elementToStringValue);
        element.accept((PsiElementVisitor)psiStringValueVisitor);
        return psiStringValueVisitor.myResult;
    }

    private void visitRWordsInterface(@NotNull RWords rWords, @NotNull Function<String, StringValue> stringValueFunction) {
        if (rWords == null) {
            PsiStringValueVisitor.$$$reportNull$$$0(20);
        }
        if (stringValueFunction == null) {
            PsiStringValueVisitor.$$$reportNull$$$0(21);
        }
        this.myResult = StringValueUtil.createStringValueArray((List)ContainerUtil.map((Collection)rWords.getWords(), word -> (StringValue)stringValueFunction.apply((String)word)));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToStringValue";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rSymbol";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rStringLiteral";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rStrings";
                break;
            }
            case 7: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rWords";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rSymbols";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rdWords";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rdSymbols";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "array";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assocList";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrayIndexing";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rArrayToArguments";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rPseudoConstant";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rIntegerConstant";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rFloatConstant";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringValueFunction";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/symbolicExecution/visitors/PsiStringValueVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitRSymbol";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "visitRDotReference";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "visitRCall";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "visitRDStringLiteral";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "visitRStringLiteral";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "visitRStrings";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "visitRWords";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "visitRSymbols";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "visitRDWords";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "visitRDSymbols";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "visitRArray";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "visitRAssocList";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "visitRArrayIndexing";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "visitRArrayToArguments";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "visitRPseudoConstant";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "visitRIntegerConstant";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "visitRFloatConstant";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "inferStringValue";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[2] = "visitRWordsInterface";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

