/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.symbolicExpression;

import com.intellij.openapi.util.Pair;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.SymbolicExpressionTypeHolder;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.symbolicExpression.SymbolicExpression;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.symbolicExpression.attribute.AttributeKey;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.symbolicExpression.attribute.AttributeRegistry;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.symbolicExpression.attribute.AttributeSerializerRegistry;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RTypeUtilCore;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.impl.REmptyType;

public abstract class SymbolicExpressionBase
implements SymbolicExpression {
    @Nullable
    private List<Pair<AttributeKey<?>, Object>> myStorage;
    private final int myId;

    SymbolicExpressionBase(@NotNull SymbolicExpression.IdSupplier id) {
        if (id == null) {
            SymbolicExpressionBase.$$$reportNull$$$0(0);
        }
        this.myStorage = null;
        this.myId = id.getId();
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SymbolicExpressionBase base = (SymbolicExpressionBase)o;
        return this.myId == base.myId;
    }

    public final int hashCode() {
        return this.myId;
    }

    public int getId() {
        return this.myId;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " " + this.myId;
    }

    @Nullable
    public <T> T getAttributeValue(@NotNull AttributeKey<T> attributeKey) {
        Pair first;
        if (attributeKey == null) {
            SymbolicExpressionBase.$$$reportNull$$$0(1);
        }
        if (this.myStorage != null && (first = (Pair)ContainerUtil.find(this.myStorage, it -> ((AttributeKey)it.first).equals(attributeKey))) != null) {
            return (T)first.second;
        }
        return null;
    }

    public <T> void setAttributeValue(@NotNull AttributeKey<T> attributeKey, @NotNull T value) {
        if (attributeKey == null) {
            SymbolicExpressionBase.$$$reportNull$$$0(2);
        }
        if (value == null) {
            SymbolicExpressionBase.$$$reportNull$$$0(3);
        }
        if (this.myStorage == null) {
            this.myStorage = Collections.synchronizedList(new SmartList());
        }
        this.removeAttribute(attributeKey);
        this.myStorage.add(Pair.create(attributeKey, value));
    }

    public <T> void removeAttribute(@NotNull AttributeKey<T> attributeKey) {
        if (attributeKey == null) {
            SymbolicExpressionBase.$$$reportNull$$$0(4);
        }
        if (this.myStorage != null) {
            this.myStorage.removeIf(it -> ((AttributeKey)it.first).equals(attributeKey));
        }
    }

    @NotNull
    protected RType getTypeWithoutHolderCheck(@NotNull SymbolicExpressionTypeHolder holder) {
        if (holder == null) {
            SymbolicExpressionBase.$$$reportNull$$$0(5);
        }
        REmptyType rEmptyType = REmptyType.INSTANCE;
        if (rEmptyType == null) {
            SymbolicExpressionBase.$$$reportNull$$$0(6);
        }
        return rEmptyType;
    }

    @NotNull
    public final RType getType(@NotNull SymbolicExpressionTypeHolder holder) {
        RType forcedType;
        if (holder == null) {
            SymbolicExpressionBase.$$$reportNull$$$0(7);
        }
        if (RTypeUtilCore.isNotEmpty(forcedType = holder.getTypeForSymbolicExpression((SymbolicExpression)this))) {
            RType rType = forcedType;
            if (rType == null) {
                SymbolicExpressionBase.$$$reportNull$$$0(8);
            }
            return rType;
        }
        RType rType = this.getTypeWithoutHolderCheck(holder);
        if (rType == null) {
            SymbolicExpressionBase.$$$reportNull$$$0(9);
        }
        return rType;
    }

    public void copyAttributes(@NotNull SymbolicExpressionBase from) {
        if (from == null) {
            SymbolicExpressionBase.$$$reportNull$$$0(10);
        }
        if (from.myStorage != null) {
            this.myStorage = Collections.synchronizedList(new SmartList(from.myStorage));
        }
    }

    protected void serializeAttributes(@NotNull StubOutputStream outputStream) throws IOException {
        if (outputStream == null) {
            SymbolicExpressionBase.$$$reportNull$$$0(11);
        }
        if (this.myStorage == null) {
            outputStream.writeVarInt(0);
            return;
        }
        List registered = ContainerUtil.filter(this.myStorage, it -> ((AttributeKey)it.first).isRegistered());
        outputStream.writeVarInt(registered.size());
        for (Pair pair : registered) {
            outputStream.writeName(((AttributeKey)pair.first).getName());
            SymbolicExpressionBase.serializeValue((AttributeKey)pair.first, pair.second, outputStream);
        }
    }

    protected void deserializeAttributes(@NotNull StubInputStream inputStream) throws IOException {
        if (inputStream == null) {
            SymbolicExpressionBase.$$$reportNull$$$0(12);
        }
        int size = inputStream.readVarInt();
        for (int i = 0; i < size; ++i) {
            String name = inputStream.readNameString();
            if (name == null) {
                throw new IOException("readNameString returned null");
            }
            AttributeKey attributeKey = AttributeRegistry.getInstance().getAttributeByName(name);
            if (attributeKey == null) {
                throw new IllegalStateException("AttributeKey with name " + name + " not found");
            }
            this.deserializeAndSetValue(inputStream, attributeKey);
        }
    }

    private <T> void deserializeAndSetValue(@NotNull StubInputStream inputStream, AttributeKey<T> attributeKey) throws IOException {
        if (inputStream == null) {
            SymbolicExpressionBase.$$$reportNull$$$0(13);
        }
        this.setAttributeValue(attributeKey, AttributeSerializerRegistry.getInstance().serializer(attributeKey).deserialize(inputStream));
    }

    private static <T> void serializeValue(AttributeKey<T> key, Object o, StubOutputStream outputStream) throws IOException {
        AttributeSerializerRegistry.getInstance().serializer(key).serialize(o, outputStream);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeKey";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 6: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/codeInsight/symbolicExecution/symbolicExpression/SymbolicExpressionBase";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputStream";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/symbolicExecution/symbolicExpression/SymbolicExpressionBase";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeWithoutHolderCheck";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getAttributeValue";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setAttributeValue";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "removeAttribute";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getTypeWithoutHolderCheck";
                break;
            }
            case 6: 
            case 8: 
            case 9: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getType";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "copyAttributes";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "serializeAttributes";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "deserializeAttributes";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "deserializeAndSetValue";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 8, 9 -> new IllegalStateException(string);
        };
    }
}

