/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.annotations;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rdoc.RDocConstants;
import org.jetbrains.plugins.ruby.rdoc.yard.YARDTag;
import org.jetbrains.plugins.ruby.rdoc.yard.tags.YARDOptionTag;
import org.jetbrains.plugins.ruby.rdoc.yard.tags.YARDOverloadDirective;
import org.jetbrains.plugins.ruby.rdoc.yard.tags.YARDParamTag;
import org.jetbrains.plugins.ruby.rdoc.yard.tags.YARDYieldparamTag;
import org.jetbrains.plugins.ruby.rdoc.yard.tags.YardYieldTag;
import org.jetbrains.plugins.ruby.rdoc.yard.tags.base.YARDTypedTag;
import org.jetbrains.plugins.ruby.ruby.codeInsight.annotations.MethodAnnotationData;
import org.jetbrains.plugins.ruby.ruby.codeInsight.annotations.MethodAnnotationDataImpl;
import org.jetbrains.plugins.ruby.ruby.codeInsight.annotations.YARDMethodData;
import org.jetbrains.plugins.ruby.ruby.codeInsight.annotations.YARDMethodDataImpl;
import org.jetbrains.plugins.ruby.ruby.codeInsight.signature.ROverloadSyntheticSignature;
import org.jetbrains.plugins.ruby.ruby.codeInsight.signature.ROverloadSyntheticSignatureImpl;
import org.jetbrains.plugins.ruby.ruby.codeInsight.signature.RSignature;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RubyCommentsHelper;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.serializable.SerializableType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.serializable.SerializableTypeUtil;
import org.jetbrains.plugins.ruby.ruby.lang.documentation.RubyCommentsUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RMethodWithPossibleInlineVisibilityModifier;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.ArgumentInfo;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.OptionInfo;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.holders.RContainerBase;
import org.jetbrains.plugins.ruby.sorbet.SorbetSigParser;
import org.jetbrains.plugins.ruby.util.StreamUtil;

public final class AnnotationsHelperCore {
    private AnnotationsHelperCore() {
    }

    @NotNull
    public static YARDMethodData createYARDDataFromYardTagsAndPsiHelp(List<YARDTag> yardTags, String psiHelp) {
        return new YARDMethodDataImpl(AnnotationsHelperCore.getYARDParamTypes(yardTags), AnnotationsHelperCore.getCommentReturnType(yardTags), AnnotationsHelperCore.findDeprecationInYARD(psiHelp), AnnotationsHelperCore.getOptionInfos(yardTags), AnnotationsHelperCore.getYieldParamInfo(yardTags), AnnotationsHelperCore.getROverloadSyntheticSignatures(yardTags));
    }

    private static List<RSignature.TypedArgument> getYARDParamTypes(@NotNull List<YARDTag> yardTags) {
        if (yardTags == null) {
            AnnotationsHelperCore.$$$reportNull$$$0(0);
        }
        return yardTags.stream().filter(tag -> tag instanceof YARDParamTag).map(tag -> new RSignature.TypedArgument(((YARDParamTag)tag).getName(), ((YARDParamTag)tag).getType())).collect(Collectors.toList());
    }

    @NotNull
    private static SerializableType getCommentReturnType(@NotNull List<YARDTag> yardTags) {
        if (yardTags == null) {
            AnnotationsHelperCore.$$$reportNull$$$0(1);
        }
        SerializableType serializableType = RubyCommentsHelper.getYARDReturnType(yardTags);
        if (serializableType == null) {
            AnnotationsHelperCore.$$$reportNull$$$0(2);
        }
        return serializableType;
    }

    private static boolean findDeprecationInYARD(@NotNull String commentsText) {
        if (commentsText == null) {
            AnnotationsHelperCore.$$$reportNull$$$0(3);
        }
        return RDocConstants.DEPRECATED_PATTERN.matcher(commentsText).find();
    }

    @NotNull
    public static List<SerializableType> getYieldParamInfo(@NotNull List<YARDTag> tags) {
        List<SerializableType> types;
        if (tags == null) {
            AnnotationsHelperCore.$$$reportNull$$$0(4);
        }
        if (!(types = tags.stream().mapMulti(StreamUtil.select(YARDYieldparamTag.class, (Class[])new Class[0])).map(YARDTypedTag::getType).toList()).isEmpty()) {
            List<SerializableType> list = types;
            if (list == null) {
                AnnotationsHelperCore.$$$reportNull$$$0(5);
            }
            return list;
        }
        List<SerializableType> list = tags.stream().mapMulti(StreamUtil.select(YardYieldTag.class, (Class[])new Class[0])).findFirst().stream().flatMap(it -> it.getVariableNames().stream()).map(__ -> SerializableTypeUtil.EMPTY).toList();
        if (list == null) {
            AnnotationsHelperCore.$$$reportNull$$$0(6);
        }
        return list;
    }

    @NotNull
    public static ROverloadSyntheticSignature getROverloadSyntheticSignature(@NotNull YARDOverloadDirective tag) {
        if (tag == null) {
            AnnotationsHelperCore.$$$reportNull$$$0(7);
        }
        List<ArgumentInfo> argumentInfos = tag.getArguments().getArgumentInfos();
        YARDMethodData methodData = AnnotationsHelperCore.createYARDDataFromYardTagsAndPsiHelp(tag.getChildTags(), "");
        return new ROverloadSyntheticSignatureImpl(argumentInfos, methodData);
    }

    @NotNull
    public static List<ROverloadSyntheticSignature> getROverloadSyntheticSignatures(@NotNull List<YARDTag> tags) {
        if (tags == null) {
            AnnotationsHelperCore.$$$reportNull$$$0(8);
        }
        List<ROverloadSyntheticSignature> list = tags.stream().mapMulti(StreamUtil.select(YARDOverloadDirective.class, (Class[])new Class[0])).map(AnnotationsHelperCore::getROverloadSyntheticSignature).collect(Collectors.toList());
        if (list == null) {
            AnnotationsHelperCore.$$$reportNull$$$0(9);
        }
        return list;
    }

    @NotNull
    private static List<OptionInfo> getOptionInfos(@NotNull List<YARDTag> yardTags) {
        if (yardTags == null) {
            AnnotationsHelperCore.$$$reportNull$$$0(10);
        }
        List list = (List)((StreamEx)StreamEx.of(yardTags).select(YARDOptionTag.class).filter(tag -> tag.getPsiElement() != null)).map(tag -> new OptionInfo(tag.getName(), tag.getOptionName(), (PsiElement)tag.getPsiElement(), tag.isRequired())).collect(Collectors.toList());
        if (list == null) {
            AnnotationsHelperCore.$$$reportNull$$$0(11);
        }
        return list;
    }

    @NotNull
    public static MethodAnnotationData createFromPsi(@NotNull RMethod psi) {
        if (psi == null) {
            AnnotationsHelperCore.$$$reportNull$$$0(12);
        }
        YARDMethodData yardData = AnnotationsHelperCore.createYARDDataFromPsi(psi);
        RSignature sorbetSignature = AnnotationsHelperCore.findSorbetSignature(psi);
        boolean railsDeprecation = AnnotationsHelperCore.findRailsDeprecationFromPsi(psi);
        return AnnotationsHelperCore.createAnnotationData(yardData, railsDeprecation, sorbetSignature);
    }

    @NotNull
    public static MethodAnnotationData createAnnotationData(@Nullable YARDMethodData yardMethodData, boolean railsDeprecation, @Nullable RSignature sorbetSignature) {
        return new MethodAnnotationDataImpl(yardMethodData, railsDeprecation, sorbetSignature);
    }

    @Nullable
    private static YARDMethodData createYARDDataFromPsi(@NotNull RMethod psi) {
        String psiHelp;
        if (psi == null) {
            AnnotationsHelperCore.$$$reportNull$$$0(13);
        }
        if ((psiHelp = RubyCommentsUtilCore.getPsiHelpWithoutLeadingSharps((PsiElement)psi)) == null) {
            return null;
        }
        List yardTags = psi.getYARDTags();
        return AnnotationsHelperCore.createYARDDataFromYardTagsAndPsiHelp(yardTags, psiHelp);
    }

    private static boolean findRailsDeprecationFromPsi(@NotNull RMethod psi) {
        if (psi == null) {
            AnnotationsHelperCore.$$$reportNull$$$0(14);
        }
        return StringUtil.startsWith((CharSequence)((RContainerBase)psi).getBody().getText(), (CharSequence)"ActiveSupport::Deprecation.warn");
    }

    public static RSignature findSorbetSignature(@NotNull RMethod psi) {
        RPsiElement anchor;
        PsiElement element;
        if (psi == null) {
            AnnotationsHelperCore.$$$reportNull$$$0(15);
        }
        return (element = PsiTreeUtil.getPrevSiblingOfType((PsiElement)(anchor = Optional.ofNullable(RMethodWithPossibleInlineVisibilityModifier.from((PsiElement)psi)).map(RMethodWithPossibleInlineVisibilityModifier::getVisibilityCall).orElse((RPsiElement)psi)), RPsiElement.class)) != null ? SorbetSigParser.parse(element) : null;
    }

    @NotNull
    public static MethodAnnotationData createAnnotationData(@Nullable YARDMethodData yardMethodData, @Nullable RSignature sorbetSignature) {
        return AnnotationsHelperCore.createAnnotationData(yardMethodData, false, sorbetSignature);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 5, 6, 9, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "yardTags";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/codeInsight/annotations/AnnotationsHelperCore";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commentsText";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tags";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/annotations/AnnotationsHelperCore";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommentReturnType";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getYieldParamInfo";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getROverloadSyntheticSignatures";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionInfos";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getYARDParamTypes";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getCommentReturnType";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 9: 
            case 11: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findDeprecationInYARD";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getYieldParamInfo";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getROverloadSyntheticSignature";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getROverloadSyntheticSignatures";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getOptionInfos";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createFromPsi";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createYARDDataFromPsi";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findRailsDeprecationFromPsi";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findSorbetSignature";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 5, 6, 9, 11 -> new IllegalStateException(string);
        };
    }
}

