/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rdoc.yard.tags;

import java.util.Locale;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rdoc.yard.psi.RangeInDocumentFakePsiElement;
import org.jetbrains.plugins.ruby.rdoc.yard.tags.base.YardTagImpl;

public final class YardMacroDirective
extends YardTagImpl {
    private static final String MACRO_DIRECTIVE = "@!macro";
    private static final String MACRO_DIRECTIVE_OLD = "@macro";
    private static final Pattern MACRO_DIRECTIVE_PATTERN = Pattern.compile("@!?macro");
    @Nullable
    private final Type myType;
    private final String myName;
    private final String myDescription;

    public YardMacroDirective(@NotNull RangeInDocumentFakePsiElement element, @Nullable Type type, @NotNull String name, @NotNull String description) {
        if (element == null) {
            YardMacroDirective.$$$reportNull$$$0(0);
        }
        if (name == null) {
            YardMacroDirective.$$$reportNull$$$0(1);
        }
        if (description == null) {
            YardMacroDirective.$$$reportNull$$$0(2);
        }
        super(element);
        this.myType = type;
        this.myName = name;
        this.myDescription = description;
    }

    @NotNull
    public String getDescription() {
        String string = this.myDescription;
        if (string == null) {
            YardMacroDirective.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            YardMacroDirective.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    @NotNull
    public RangeInDocumentFakePsiElement getPsiElement() {
        RangeInDocumentFakePsiElement rangeInDocumentFakePsiElement = super.getPsiElement();
        if (rangeInDocumentFakePsiElement == null) {
            YardMacroDirective.$$$reportNull$$$0(5);
        }
        return rangeInDocumentFakePsiElement;
    }

    public boolean isDeclaration() {
        return this.myType != null || !this.myDescription.isBlank();
    }

    public String toString() {
        return String.format("YardMacroDirective{myElement=%s, myType=%s, myName='%s', myDescription='%s'}", new Object[]{this.myElement, this.myType, this.myName, this.myDescription});
    }

    public static boolean containsMacroDirective(@NotNull CharSequence text) {
        if (text == null) {
            YardMacroDirective.$$$reportNull$$$0(6);
        }
        return MACRO_DIRECTIVE_PATTERN.matcher(text).find();
    }

    public static boolean isMacroDirective(@NotNull String text) {
        if (text == null) {
            YardMacroDirective.$$$reportNull$$$0(7);
        }
        return text.equals(MACRO_DIRECTIVE) || text.equals(MACRO_DIRECTIVE_OLD);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rdoc/yard/tags/YardMacroDirective";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rdoc/yard/tags/YardMacroDirective";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "containsMacroDirective";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isMacroDirective";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5 -> new IllegalStateException(string);
        };
    }

    public static enum Type {
        ATTACH,
        NEW;


        @Nullable
        public static Type from(@NotNull String name) {
            if (name == null) {
                Type.$$$reportNull$$$0(0);
            }
            return switch (name.toLowerCase(Locale.ROOT)) {
                case "attach" -> ATTACH;
                case "new" -> NEW;
                default -> null;
            };
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/plugins/ruby/rdoc/yard/tags/YardMacroDirective$Type", "from"));
        }
    }
}

