/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rdoc.yard.tags;

import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rdoc.AccessType;
import org.jetbrains.plugins.ruby.rdoc.DocumentationMember;
import org.jetbrains.plugins.ruby.rdoc.DocumentationSymbol;
import org.jetbrains.plugins.ruby.rdoc.RDocTokenTypes;
import org.jetbrains.plugins.ruby.rdoc.yard.DocumentationSymbolProducer;
import org.jetbrains.plugins.ruby.rdoc.yard.psi.RangeInDocumentFakePsiElement;
import org.jetbrains.plugins.ruby.rdoc.yard.tags.base.YARDVariableRelatedTag;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Type;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.serializable.SerializableType;

public class YARDAttrTag
extends YARDVariableRelatedTag
implements DocumentationSymbolProducer {
    @NotNull
    private final AccessType myAccessType;

    public YARDAttrTag(@Nullable RangeInDocumentFakePsiElement element, @NotNull String name, @NotNull AccessType accessType, @NotNull SerializableType type, String description) {
        if (name == null) {
            YARDAttrTag.$$$reportNull$$$0(0);
        }
        if (accessType == null) {
            YARDAttrTag.$$$reportNull$$$0(1);
        }
        if (type == null) {
            YARDAttrTag.$$$reportNull$$$0(2);
        }
        super(element, name, type, description, RDocTokenTypes.ATTR);
        this.myAccessType = accessType;
    }

    public static AccessType getAccessTypeFromTagName(@NotNull String tagName) {
        if (tagName == null) {
            YARDAttrTag.$$$reportNull$$$0(3);
        }
        return switch (tagName) {
            case "@attr" -> AccessType.ACCESSOR;
            case "@attr_reader" -> AccessType.READER;
            case "@attr_writer" -> AccessType.WRITER;
            default -> null;
        };
    }

    public static AccessType getAccessTypeFromModeName(@NotNull String modeName) {
        if (modeName == null) {
            YARDAttrTag.$$$reportNull$$$0(4);
        }
        return switch (modeName) {
            case "rw" -> AccessType.ACCESSOR;
            case "r" -> AccessType.READER;
            case "w" -> AccessType.WRITER;
            default -> null;
        };
    }

    @NotNull
    public Collection<DocumentationSymbol<?>> createDocumentationSymbols() {
        ArrayList result = new ArrayList(2);
        if (this.myAccessType == AccessType.READER || this.myAccessType == AccessType.ACCESSOR) {
            result.add(new DocumentationMember(this.getPsiElement(), this.getName(), Type.FIELD_READER, this.getType(), this.myAccessType));
        }
        if (this.myAccessType == AccessType.WRITER || this.myAccessType == AccessType.ACCESSOR) {
            result.add(new DocumentationMember(this.getPsiElement(), this.getName() + "=", Type.FIELD_WRITER, this.getType(), this.myAccessType));
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            YARDAttrTag.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modeName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rdoc/yard/tags/YARDAttrTag";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rdoc/yard/tags/YARDAttrTag";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createDocumentationSymbols";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getAccessTypeFromTagName";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getAccessTypeFromModeName";
                break;
            }
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }
}

