/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rdoc.yard;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rdoc.AccessType;
import org.jetbrains.plugins.ruby.rdoc.DocumentationMethodSymbolArguments;
import org.jetbrains.plugins.ruby.rdoc.RDocTokenTypes;
import org.jetbrains.plugins.ruby.rdoc.yard.YARDLexer;
import org.jetbrains.plugins.ruby.rdoc.yard.YARDPsiLexer;
import org.jetbrains.plugins.ruby.rdoc.yard.YARDTag;
import org.jetbrains.plugins.ruby.rdoc.yard.psi.MethodNameFakePsiElement;
import org.jetbrains.plugins.ruby.rdoc.yard.psi.RangeInDocumentFakePsiElement;
import org.jetbrains.plugins.ruby.rdoc.yard.psi.YARDFakePsiFactory;
import org.jetbrains.plugins.ruby.rdoc.yard.tags.YARDAttrTag;
import org.jetbrains.plugins.ruby.rdoc.yard.tags.YARDAttributeDirective;
import org.jetbrains.plugins.ruby.rdoc.yard.tags.YARDMethodDirective;
import org.jetbrains.plugins.ruby.rdoc.yard.tags.YARDOptionTag;
import org.jetbrains.plugins.ruby.rdoc.yard.tags.YARDOverloadDirective;
import org.jetbrains.plugins.ruby.rdoc.yard.tags.YARDParamTag;
import org.jetbrains.plugins.ruby.rdoc.yard.tags.YARDReturnTag;
import org.jetbrains.plugins.ruby.rdoc.yard.tags.YARDTypeTag;
import org.jetbrains.plugins.ruby.rdoc.yard.tags.YARDYieldparamTag;
import org.jetbrains.plugins.ruby.rdoc.yard.tags.YardMacroDirective;
import org.jetbrains.plugins.ruby.rdoc.yard.tags.YardYieldTag;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.serializable.SerializableType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.serializable.SerializableTypeUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.ArgumentInfo;

public final class YARDParser {
    public static List<YARDTag> parse(@NotNull String helpWithoutLeadingSharps) {
        if (helpWithoutLeadingSharps == null) {
            YARDParser.$$$reportNull$$$0(0);
        }
        YARDLexer lexer = new YARDLexer(true);
        lexer.start(helpWithoutLeadingSharps);
        return YARDParser.parse(lexer);
    }

    public static List<YARDTag> parse(List<? extends PsiComment> comments) {
        YARDPsiLexer lexer = new YARDPsiLexer(comments);
        return YARDParser.parse(lexer);
    }

    private static List<YARDTag> parse(YARDLexer lexer) {
        ArrayList<YARDTag> result = new ArrayList<YARDTag>();
        while (lexer.getNonWhitespaceTokenType() != null) {
            YARDTag parsedTag;
            IElementType tokenType = lexer.getNonWhitespaceTokenType();
            if (tokenType == RDocTokenTypes.PARAM || tokenType == RDocTokenTypes.ATTR || tokenType == RDocTokenTypes.TYPE_TAG || tokenType == RDocTokenTypes.YIELD_PARAM) {
                parsedTag = YARDParser.parseParamOrAttrOrYieldparamOrType(lexer, tokenType);
            } else if (tokenType == RDocTokenTypes.YIELD) {
                parsedTag = YARDParser.parseYield(lexer);
            } else if (tokenType == RDocTokenTypes.RETURN) {
                parsedTag = YARDParser.parseReturn(lexer);
            } else if (tokenType == RDocTokenTypes.OPTION) {
                parsedTag = YARDParser.parseOption(lexer);
            } else if (tokenType == RDocTokenTypes.ATTRIBUTE_DIRECTIVE) {
                parsedTag = YARDParser.parseAttributeDirective(lexer);
            } else if (tokenType == RDocTokenTypes.METHOD_DIRECTIVE) {
                parsedTag = YARDParser.parseSubMethodDirective(lexer, tokenType);
            } else if (tokenType == RDocTokenTypes.OVERLOAD) {
                parsedTag = YARDParser.parseSubMethodDirective(lexer, tokenType);
            } else if (tokenType == RDocTokenTypes.MACRO_DIRECTIVE) {
                parsedTag = YARDParser.parseMacroDirective(lexer);
            } else {
                parsedTag = null;
                lexer.advanceToNonWhitespaceToken();
            }
            if (parsedTag == null) continue;
            result.add(parsedTag);
        }
        return result;
    }

    @Nullable
    private static YARDTag parseOption(@NotNull YARDLexer lexer) {
        String symbol;
        int startOffset;
        if (lexer == null) {
            YARDParser.$$$reportNull$$$0(1);
        }
        lexer.advanceToNonWhitespaceToken();
        String name = null;
        boolean required = false;
        SerializableType type = null;
        for (int i = 0; i < 2; ++i) {
            if (lexer.getNonWhitespaceTokenType() == RDocTokenTypes.PARAM_NAME) {
                name = lexer.getTokenText();
                lexer.advanceToNonWhitespaceToken();
                continue;
            }
            if (lexer.getNonWhitespaceTokenType() != RDocTokenTypes.LBRACKET) continue;
            lexer.advanceToNonWhitespaceToken();
            required = lexer.getTokenText().equals("required");
            boolean optional = lexer.getTokenText().equals("optional");
            if (required || optional) {
                lexer.advanceToNonWhitespaceToken();
                if (lexer.getNonWhitespaceTokenType() != RDocTokenTypes.COMMA) {
                    return null;
                }
                lexer.advanceToNonWhitespaceToken();
            }
            type = YARDParser.parseType(lexer);
            if (lexer.getNonWhitespaceTokenType() != RDocTokenTypes.RBRACKET) {
                return null;
            }
            lexer.advanceToNonWhitespaceToken();
        }
        if (type == null || name == null) {
            return null;
        }
        if (lexer.getNonWhitespaceTokenType() == RDocTokenTypes.SYMBOL) {
            startOffset = YARDParser.getCurrentPosition(lexer) + 1;
            symbol = lexer.getTokenText().substring(1);
        } else if (lexer.getNonWhitespaceTokenType() == RDocTokenTypes.CID) {
            startOffset = YARDParser.getCurrentPosition(lexer);
            symbol = lexer.getTokenText();
        } else {
            return null;
        }
        lexer.advance();
        RangeInDocumentFakePsiElement element = YARDParser.createFakePsiElement(lexer, startOffset);
        String description = YARDParser.parseDescription(lexer).trim();
        return new YARDOptionTag(element, name, type, description, symbol, required);
    }

    @Nullable
    private static YardYieldTag parseYield(@NotNull YARDLexer lexer) {
        if (lexer == null) {
            YARDParser.$$$reportNull$$$0(2);
        }
        RangeInDocumentFakePsiElement element = YARDParser.advanceAndGetElement(lexer, YARDFakePsiFactory.DEFAULT);
        ArrayList<String> variableNames = new ArrayList<String>();
        if (lexer.getNonWhitespaceTokenType() == RDocTokenTypes.LBRACKET) {
            lexer.advanceToNonWhitespaceToken();
            while (lexer.getTokenType() != null && lexer.getTokenType() != RDocTokenTypes.RBRACKET) {
                if (lexer.getTokenType() == RDocTokenTypes.PARAM_NAME) {
                    variableNames.add(lexer.getTokenText().trim());
                }
                lexer.advanceToNonWhitespaceToken();
            }
            lexer.advance();
        }
        String description = YARDParser.parseDescription(lexer).trim();
        return element != null ? new YardYieldTag(element, variableNames, description) : null;
    }

    @Nullable
    private static YARDTag parseParamOrAttrOrYieldparamOrType(YARDLexer lexer, IElementType tokenType) {
        SerializableType type;
        RangeInDocumentFakePsiElement psiElement;
        int startPosition = YARDParser.getCurrentPosition(lexer);
        AccessType accessType = YARDAttrTag.getAccessTypeFromTagName(lexer.getTokenText());
        lexer.getNonWhitespaceTokenType();
        lexer.advanceToNonWhitespaceToken();
        String name = "";
        if (lexer.getNonWhitespaceTokenType() == RDocTokenTypes.PARAM_NAME) {
            name = lexer.getTokenText().trim();
            psiElement = YARDParser.advanceAndGetElement(lexer, YARDFakePsiFactory.DEFAULT);
            type = YARDParser.parseTypeDeclaration(lexer);
        } else {
            type = YARDParser.parseTypeDeclaration(lexer);
            lexer.getNonWhitespaceTokenType();
            if (lexer.getNonWhitespaceTokenType() == RDocTokenTypes.PARAM_NAME) {
                name = lexer.getTokenText().trim();
                psiElement = YARDParser.advanceAndGetElement(lexer, YARDFakePsiFactory.DEFAULT);
            } else {
                psiElement = null;
            }
        }
        if (StringUtil.isEmpty((String)name) && tokenType != RDocTokenTypes.TYPE_TAG) {
            return null;
        }
        String description = YARDParser.parseDescription(lexer).trim();
        if (tokenType == RDocTokenTypes.PARAM) {
            return new YARDParamTag(psiElement, name, type, description, YARDParser.createFakePsiElement(lexer, startPosition));
        }
        if (tokenType == RDocTokenTypes.ATTR) {
            assert (accessType != null);
            return new YARDAttrTag(psiElement, name, accessType, type, description);
        }
        if (tokenType == RDocTokenTypes.YIELD_PARAM) {
            return new YARDYieldparamTag(psiElement, name, type, description);
        }
        return new YARDTypeTag(psiElement, name, type, description);
    }

    @NotNull
    private static YARDTag parseReturn(YARDLexer lexer) {
        int position = YARDParser.getCurrentPosition(lexer);
        lexer.getNonWhitespaceTokenType();
        lexer.advanceToNonWhitespaceToken();
        SerializableType type = YARDParser.parseTypeDeclaration(lexer);
        String description = YARDParser.parseDescription(lexer).trim();
        return new YARDReturnTag(YARDParser.createFakePsiElement(lexer, position), type, description);
    }

    @Nullable
    private static YARDTag parseSubMethodDirective(@NotNull YARDLexer lexer, @NotNull IElementType parentTokenType) {
        if (lexer == null) {
            YARDParser.$$$reportNull$$$0(3);
        }
        if (parentTokenType == null) {
            YARDParser.$$$reportNull$$$0(4);
        }
        int position = YARDParser.getCurrentPosition(lexer);
        lexer.advanceToNonWhitespaceToken();
        if (lexer.getNonWhitespaceTokenType() != RDocTokenTypes.CID) {
            return null;
        }
        int directiveIndent = lexer.getLastIndent();
        String methodName = lexer.getTokenText();
        MethodNameFakePsiElement methodNameElement = YARDParser.advanceAndGetElement(lexer, YARDFakePsiFactory.METHOD_NAME);
        DocumentationMethodSymbolArguments arguments = YARDParser.parseMethodArguments(lexer);
        YARDParser.skipToNextLine(lexer);
        lexer.advanceToNonWhitespaceToken();
        int nextLineIndent = lexer.getLastIndent();
        Pair<String, List<YARDTag>> descAndTags = nextLineIndent > directiveIndent || nextLineIndent == directiveIndent && YARDParser.shouldAttachToDirective(lexer.getNonWhitespaceTokenType()) && RDocTokenTypes.METHOD_DIRECTIVE == parentTokenType ? YARDParser.parseSubBlock(lexer, nextLineIndent - 1, true, false) : Pair.create((Object)"", Collections.emptyList());
        if (parentTokenType == RDocTokenTypes.OVERLOAD) {
            return new YARDOverloadDirective(YARDParser.createFakePsiElement(lexer, position), methodNameElement, methodName, arguments, (String)descAndTags.first, (List)descAndTags.second);
        }
        if (parentTokenType == RDocTokenTypes.METHOD_DIRECTIVE) {
            return new YARDMethodDirective(YARDParser.createFakePsiElement(lexer, position), methodNameElement, methodName, arguments, (String)descAndTags.first, (List)descAndTags.second);
        }
        throw new RuntimeException("parsing sub method directive is not implemented for " + String.valueOf(parentTokenType));
    }

    private static boolean shouldAttachToDirective(IElementType type) {
        return type != RDocTokenTypes.ATTRIBUTE_DIRECTIVE && type != RDocTokenTypes.METHOD_DIRECTIVE;
    }

    private static DocumentationMethodSymbolArguments parseMethodArguments(YARDLexer lexer) {
        IElementType tokenType;
        if (lexer.getNonWhitespaceTokenType() != RDocTokenTypes.LPAREN) {
            return DocumentationMethodSymbolArguments.EMPTY;
        }
        lexer.advanceToNonWhitespaceToken();
        ArrayList<ArgumentInfo> infos = new ArrayList<ArgumentInfo>(0);
        ArrayList<RangeInDocumentFakePsiElement> elements = new ArrayList<RangeInDocumentFakePsiElement>(0);
        while ((tokenType = lexer.getNonWhitespaceTokenType()) != null && tokenType != RDocTokenTypes.EOL && tokenType != RDocTokenTypes.RPAREN) {
            YARDParser.parseOneArgument(lexer, infos, elements);
        }
        return new DocumentationMethodSymbolArguments(infos, elements);
    }

    private static void parseOneArgument(@NotNull YARDLexer lexer, @NotNull List<ArgumentInfo> infos, @NotNull List<RangeInDocumentFakePsiElement> elements) {
        if (lexer == null) {
            YARDParser.$$$reportNull$$$0(5);
        }
        if (infos == null) {
            YARDParser.$$$reportNull$$$0(6);
        }
        if (elements == null) {
            YARDParser.$$$reportNull$$$0(7);
        }
        IElementType tokenType = lexer.getNonWhitespaceTokenType();
        ArgumentInfo.Type type = null;
        if (tokenType == RDocTokenTypes.STAR) {
            type = ArgumentInfo.Type.ARRAY;
        } else if (tokenType == RDocTokenTypes.DOUBLE_STAR) {
            type = ArgumentInfo.Type.HASH;
        } else if (tokenType == RDocTokenTypes.AMP) {
            type = ArgumentInfo.Type.BLOCK;
        }
        if (type != null) {
            lexer.advanceToNonWhitespaceToken();
            tokenType = lexer.getNonWhitespaceTokenType();
        }
        if (tokenType != RDocTokenTypes.PARAM_NAME) {
            lexer.advanceToNonWhitespaceToken();
            return;
        }
        String argName = lexer.getTokenText();
        RangeInDocumentFakePsiElement element = YARDParser.advanceAndGetElement(lexer, YARDFakePsiFactory.DEFAULT);
        if (type == null) {
            IElementType nextType = lexer.getNonWhitespaceTokenType();
            if (nextType == RDocTokenTypes.EQ || nextType == RDocTokenTypes.COLON) {
                boolean hasPredefinedValue;
                lexer.advanceToNonWhitespaceToken();
                IElementType predefinedValue = lexer.getNonWhitespaceTokenType();
                boolean bl = hasPredefinedValue = predefinedValue != RDocTokenTypes.COMMA && predefinedValue != RDocTokenTypes.RPAREN;
                ArgumentInfo.Type type2 = nextType == RDocTokenTypes.EQ ? ArgumentInfo.Type.PREDEFINED : (type = hasPredefinedValue ? ArgumentInfo.Type.NAMED : ArgumentInfo.Type.KEYREQ);
                while (lexer.getTokenType() != null && lexer.getTokenType() != RDocTokenTypes.COMMA && lexer.getTokenType() != RDocTokenTypes.RPAREN && lexer.getTokenType() != RDocTokenTypes.EOL) {
                    lexer.advanceToNonWhitespaceToken();
                }
            } else {
                type = ArgumentInfo.Type.SIMPLE;
            }
        }
        infos.add(new ArgumentInfo(argName, type));
        if (element != null) {
            elements.add(element);
        }
    }

    private static YARDTag parseAttributeDirective(YARDLexer lexer) {
        lexer.advanceToNonWhitespaceToken();
        AccessType accessType = null;
        if (lexer.getNonWhitespaceTokenType() == RDocTokenTypes.LBRACKET) {
            lexer.advanceToNonWhitespaceToken();
            if (lexer.getTokenType() == RDocTokenTypes.TYPE) {
                accessType = YARDAttrTag.getAccessTypeFromModeName(lexer.getTokenText());
                lexer.advanceToNonWhitespaceToken();
            }
            if (lexer.getTokenType() == RDocTokenTypes.RBRACKET) {
                lexer.advanceToNonWhitespaceToken();
            }
        }
        if (accessType == null) {
            accessType = AccessType.ACCESSOR;
        }
        if (lexer.getTokenType() != RDocTokenTypes.CID) {
            return null;
        }
        int directiveIndent = lexer.getLastIndent();
        String memberName = lexer.getTokenText();
        RangeInDocumentFakePsiElement idElement = YARDParser.advanceAndGetElement(lexer, YARDFakePsiFactory.DEFAULT);
        YARDParser.skipToNextLine(lexer);
        lexer.advanceToNonWhitespaceToken();
        int nextLineIndent = lexer.getLastIndent();
        Pair<String, List<YARDTag>> descAndTags = nextLineIndent > directiveIndent || nextLineIndent == directiveIndent && YARDParser.shouldAttachToDirective(lexer.getNonWhitespaceTokenType()) ? YARDParser.parseSubBlock(lexer, nextLineIndent - 1, true, false) : Pair.create((Object)"", Collections.emptyList());
        return new YARDAttributeDirective(idElement, memberName, accessType, (String)descAndTags.first, (List)descAndTags.second);
    }

    @Nullable
    private static YARDTag parseMacroDirective(@NotNull YARDLexer lexer) {
        YardMacroDirective.Type type;
        if (lexer == null) {
            YARDParser.$$$reportNull$$$0(8);
        }
        lexer.advanceToNonWhitespaceToken();
        int indent = lexer.getLastIndent();
        if (lexer.getNonWhitespaceTokenType() == RDocTokenTypes.LBRACKET) {
            lexer.advanceToNonWhitespaceToken();
            type = YardMacroDirective.Type.from(lexer.getTokenText());
            lexer.advanceToNonWhitespaceToken();
            if (lexer.getNonWhitespaceTokenType() == RDocTokenTypes.RBRACKET) {
                lexer.advanceToNonWhitespaceToken();
            }
        } else {
            type = null;
        }
        if (lexer.getTokenType() != RDocTokenTypes.MACRO_NAME) {
            return null;
        }
        String name = lexer.getTokenText();
        RangeInDocumentFakePsiElement element = YARDParser.advanceAndGetElement(lexer, YARDFakePsiFactory.DEFAULT);
        YARDParser.skipToNextLine(lexer);
        String description = YARDParser.parseRawDescription(lexer, indent);
        return element != null ? new YardMacroDirective(element, type, name, description) : null;
    }

    private static String parseDescription(YARDLexer lexer) {
        return (String)YARDParser.parseSubBlock((YARDLexer)lexer, (int)lexer.getLastIndent(), (boolean)false, (boolean)true).first;
    }

    @NotNull
    private static String parseRawDescription(@NotNull YARDLexer lexer, int indent) {
        if (lexer == null) {
            YARDParser.$$$reportNull$$$0(9);
        }
        StringBuilder sb = new StringBuilder();
        if (lexer.getTokenType() == RDocTokenTypes.EOL) {
            lexer.advanceToNonWhitespaceToken();
            sb.append(StringUtil.repeat((String)" ", (int)lexer.getLastIndent()));
        }
        while (lexer.getTokenType() != null && lexer.getLastIndent() > indent) {
            sb.append(lexer.getTokenText());
            lexer.advance();
        }
        String description = sb.toString();
        String string = description.isBlank() ? "" : StringUtil.trimTrailing((String)description);
        if (string == null) {
            YARDParser.$$$reportNull$$$0(10);
        }
        return string;
    }

    private static Pair<String, List<YARDTag>> parseSubBlock(YARDLexer lexer, int parentIndent, boolean checkThisLine, boolean stopOnTag) {
        IElementType type;
        StringBuilder builder = new StringBuilder();
        ArrayList<YARDTag> tags = stopOnTag ? Collections.emptyList() : new ArrayList<YARDTag>(0);
        lexer.getNonWhitespaceTokenType();
        boolean haveHadAtLeastOneEol = checkThisLine;
        while ((type = lexer.getTokenType()) != null && (!haveHadAtLeastOneEol || lexer.getLastIndent() > parentIndent) && type != RDocTokenTypes.OVERLOAD && YARDParser.shouldAttachToDirective(type)) {
            if (List.of(RDocTokenTypes.PARAM, RDocTokenTypes.RETURN, RDocTokenTypes.YIELD_PARAM, RDocTokenTypes.YIELD, RDocTokenTypes.TYPE_TAG).contains(type)) {
                if (stopOnTag) break;
                Object subTag = List.of(RDocTokenTypes.PARAM, RDocTokenTypes.YIELD_PARAM).contains(type) ? YARDParser.parseParamOrAttrOrYieldparamOrType(lexer, type) : (type == RDocTokenTypes.YIELD ? YARDParser.parseYield(lexer) : YARDParser.parseReturn(lexer));
                if (subTag == null) continue;
                tags.add((YARDTag)subTag);
                haveHadAtLeastOneEol = true;
                continue;
            }
            builder.append(lexer.getTokenText());
            lexer.advance();
            if (!lexer.afterEol()) continue;
            haveHadAtLeastOneEol = true;
            lexer.getNonWhitespaceTokenType();
        }
        return Pair.create((Object)builder.toString(), tags);
    }

    @NotNull
    private static SerializableType parseTypeDeclaration(YARDLexer lexer) {
        IElementType type = lexer.getNonWhitespaceTokenType();
        if (type == RDocTokenTypes.LBRACKET || type == RDocTokenTypes.LPAREN || type == RDocTokenTypes.LT) {
            lexer.advanceToNonWhitespaceToken();
            SerializableType serializableType = YARDParser.parseType(lexer);
            IElementType tokenType = lexer.getNonWhitespaceTokenType();
            if (tokenType == RDocTokenTypes.RBRACKET || tokenType == RDocTokenTypes.RPAREN || tokenType == RDocTokenTypes.GT) {
                lexer.advanceToNonWhitespaceToken();
            }
            SerializableType serializableType2 = serializableType;
            if (serializableType2 == null) {
                YARDParser.$$$reportNull$$$0(11);
            }
            return serializableType2;
        }
        SerializableType serializableType = SerializableTypeUtil.EMPTY;
        if (serializableType == null) {
            YARDParser.$$$reportNull$$$0(12);
        }
        return serializableType;
    }

    @NotNull
    private static SerializableType parseType(@NotNull YARDLexer lexer) {
        if (lexer == null) {
            YARDParser.$$$reportNull$$$0(13);
        }
        SerializableType serializableType = SerializableTypeUtil.createUnionType(YARDParser.parseTypeList(lexer));
        if (serializableType == null) {
            YARDParser.$$$reportNull$$$0(14);
        }
        return serializableType;
    }

    @NotNull
    private static List<SerializableType> parseTypeList(@NotNull YARDLexer lexer) {
        SerializableType typeComputable;
        if (lexer == null) {
            YARDParser.$$$reportNull$$$0(15);
        }
        if ((typeComputable = YARDParser.parseSingleType(lexer)) == SerializableTypeUtil.EMPTY) {
            List<SerializableType> list = Collections.emptyList();
            if (list == null) {
                YARDParser.$$$reportNull$$$0(16);
            }
            return list;
        }
        ArrayList<SerializableType> result = new ArrayList<SerializableType>();
        result.add(typeComputable);
        while (lexer.getNonWhitespaceTokenType() == RDocTokenTypes.COMMA) {
            lexer.advanceToNonWhitespaceToken();
            SerializableType type = YARDParser.parseSingleType(lexer);
            if (type == SerializableTypeUtil.EMPTY) continue;
            result.add(type);
        }
        ArrayList<SerializableType> arrayList = result;
        if (arrayList == null) {
            YARDParser.$$$reportNull$$$0(17);
        }
        return arrayList;
    }

    @NotNull
    private static SerializableType parseSingleType(YARDLexer lexer) {
        String fqn = YARDParser.parseFQN(lexer);
        if (fqn == null) {
            SerializableType serializableType = SerializableTypeUtil.EMPTY;
            if (serializableType == null) {
                YARDParser.$$$reportNull$$$0(18);
            }
            return serializableType;
        }
        SerializableType type = SerializableTypeUtil.createQualifiedType(fqn);
        if (lexer.getNonWhitespaceTokenType() == RDocTokenTypes.LT) {
            lexer.advanceToNonWhitespaceToken();
            SerializableType typeParam = YARDParser.parseType(lexer);
            if (lexer.getNonWhitespaceTokenType() == RDocTokenTypes.GT) {
                lexer.advanceToNonWhitespaceToken();
            }
            if (typeParam == SerializableTypeUtil.EMPTY) {
                SerializableType serializableType = type;
                if (serializableType == null) {
                    YARDParser.$$$reportNull$$$0(19);
                }
                return serializableType;
            }
            SerializableType serializableType = SerializableTypeUtil.createGenericType(type, typeParam);
            if (serializableType == null) {
                YARDParser.$$$reportNull$$$0(20);
            }
            return serializableType;
        }
        if (lexer.getNonWhitespaceTokenType() == RDocTokenTypes.LBRACE) {
            lexer.advanceToNonWhitespaceToken();
            SerializableType keyType = YARDParser.parseType(lexer);
            if (keyType == SerializableTypeUtil.EMPTY || lexer.getNonWhitespaceTokenType() != RDocTokenTypes.RIGHTARROW) {
                SerializableType serializableType = type;
                if (serializableType == null) {
                    YARDParser.$$$reportNull$$$0(21);
                }
                return serializableType;
            }
            lexer.advanceToNonWhitespaceToken();
            SerializableType valueType = YARDParser.parseType(lexer);
            if (valueType == SerializableTypeUtil.EMPTY || lexer.getNonWhitespaceTokenType() != RDocTokenTypes.RBRACE) {
                SerializableType serializableType = type;
                if (serializableType == null) {
                    YARDParser.$$$reportNull$$$0(22);
                }
                return serializableType;
            }
            lexer.advanceToNonWhitespaceToken();
            SerializableType serializableType = SerializableTypeUtil.createHashType(type, keyType, valueType);
            if (serializableType == null) {
                YARDParser.$$$reportNull$$$0(23);
            }
            return serializableType;
        }
        if (lexer.getNonWhitespaceTokenType() == RDocTokenTypes.LPAREN) {
            lexer.advanceToNonWhitespaceToken();
            List<SerializableType> elementTypes = YARDParser.parseTypeList(lexer);
            if (lexer.getNonWhitespaceTokenType() != RDocTokenTypes.RPAREN) {
                SerializableType serializableType = type;
                if (serializableType == null) {
                    YARDParser.$$$reportNull$$$0(24);
                }
                return serializableType;
            }
            lexer.advanceToNonWhitespaceToken();
            SerializableType serializableType = SerializableTypeUtil.createCollectionType(type, elementTypes);
            if (serializableType == null) {
                YARDParser.$$$reportNull$$$0(25);
            }
            return serializableType;
        }
        SerializableType serializableType = type;
        if (serializableType == null) {
            YARDParser.$$$reportNull$$$0(26);
        }
        return serializableType;
    }

    @Nullable
    private static String parseFQN(YARDLexer lexer) {
        StringBuilder builder = new StringBuilder();
        if (lexer.getNonWhitespaceTokenType() == RDocTokenTypes.COLON2) {
            builder.append(lexer.getTokenText());
            lexer.advanceToNonWhitespaceToken();
        }
        if (lexer.getNonWhitespaceTokenType() == RDocTokenTypes.TYPE) {
            builder.append(lexer.getTokenText());
            lexer.advanceToNonWhitespaceToken();
            while (lexer.getNonWhitespaceTokenType() == RDocTokenTypes.COLON2) {
                builder.append(lexer.getTokenText());
                lexer.advanceToNonWhitespaceToken();
                if (lexer.getNonWhitespaceTokenType() != RDocTokenTypes.TYPE) break;
                builder.append(lexer.getTokenText());
                lexer.advanceToNonWhitespaceToken();
            }
            return builder.toString();
        }
        return null;
    }

    private static void skipToNextLine(YARDLexer lexer) {
        IElementType tokenType;
        while ((tokenType = lexer.getNonWhitespaceTokenType()) != null && tokenType != RDocTokenTypes.EOL) {
            lexer.advanceToNonWhitespaceToken();
        }
    }

    private static int getCurrentPosition(YARDLexer lexer) {
        return lexer instanceof YARDPsiLexer ? ((YARDPsiLexer)lexer).getOffsetInParent() : -1;
    }

    @Nullable
    private static RangeInDocumentFakePsiElement createFakePsiElement(YARDLexer lexer, int startOffset) {
        if (lexer instanceof YARDPsiLexer) {
            if (startOffset == -1) {
                startOffset = ((YARDPsiLexer)lexer).getOffsetInParent();
            }
            return YARDFakePsiFactory.DEFAULT.createFakePsiElement(((YARDPsiLexer)lexer).getCommentsParent(), TextRange.create((int)startOffset, (int)((YARDPsiLexer)lexer).getOffsetInParent()));
        }
        return null;
    }

    @Nullable
    private static <T extends RangeInDocumentFakePsiElement> T advanceAndGetElement(YARDLexer lexer, @NotNull YARDFakePsiFactory<T> factory) {
        T methodNameElement;
        if (factory == null) {
            YARDParser.$$$reportNull$$$0(27);
        }
        if (lexer instanceof YARDPsiLexer) {
            methodNameElement = ((YARDPsiLexer)lexer).advanceAndCreateFakePsi(factory);
        } else {
            methodNameElement = null;
            lexer.advanceToNonWhitespaceToken();
        }
        return methodNameElement;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10, 11, 12, 14, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helpWithoutLeadingSharps";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 9: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lexer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentTokenType";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infos";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rdoc/yard/YARDParser";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rdoc/yard/YARDParser";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "parseRawDescription";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "parseTypeDeclaration";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "parseType";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "parseTypeList";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "parseSingleType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "parseOption";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "parseYield";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "parseSubMethodDirective";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "parseOneArgument";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "parseMacroDirective";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "parseRawDescription";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "parseType";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "parseTypeList";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "advanceAndGetElement";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10, 11, 12, 14, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26 -> new IllegalStateException(string);
        };
    }
}

