/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rdoc.yard;

import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.rdoc.RDocTokenTypes;
import org.jetbrains.plugins.ruby.rdoc.lexer.RDocLexer;

public class YARDLexer
extends RDocLexer {
    private int myLastIndentSize = 0;
    private boolean myAfterEol = true;

    public YARDLexer(boolean sharpsRemoved) {
        super(false, sharpsRemoved);
    }

    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        if (buffer == null) {
            YARDLexer.$$$reportNull$$$0(0);
        }
        super.start(buffer, startOffset, endOffset, initialState);
        this.myAfterEol = true;
        this.calcLastIndent(this.getTokenType());
    }

    public void advance() {
        this.myAfterEol = this.getTokenType() == RDocTokenTypes.EOL;
        super.advance();
        if (this.myAfterEol) {
            this.calcLastIndent(this.getTokenType());
        }
    }

    public IElementType getNonWhitespaceTokenType() {
        this.passEols();
        return this.getTokenType();
    }

    public void advanceToNonWhitespaceToken() {
        this.advance();
        this.passEols();
    }

    public int getLastIndent() {
        return this.myLastIndentSize;
    }

    public boolean afterEol() {
        return this.myAfterEol;
    }

    private void calcLastIndent(IElementType tokenType) {
        this.myLastIndentSize = tokenType == RDocTokenTypes.WHITESPACE ? this.getTokenEnd() - this.getTokenStart() : 0;
    }

    protected void passEols() {
        while (this.getTokenType() == RDocTokenTypes.WHITESPACE) {
            this.advance();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "org/jetbrains/plugins/ruby/rdoc/yard/YARDLexer", "start"));
    }
}

