/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.puppet.ruby.epp.ide.editor;

import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.lang.puppet.ruby.epp.EppFileType;
import com.intellij.lang.puppet.ruby.epp.elementTypes.EppElementTypes;
import com.intellij.lang.puppet.ruby.epp.ide.editor.EppSmartKeysUtil;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;

public final class EppTypedHandler
extends TypedHandlerDelegate {
    @NotNull
    public TypedHandlerDelegate.Result beforeCharTyped(char c, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file, @NotNull FileType fileType) {
        if (project == null) {
            EppTypedHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            EppTypedHandler.$$$reportNull$$$0(1);
        }
        if (file == null) {
            EppTypedHandler.$$$reportNull$$$0(2);
        }
        if (fileType == null) {
            EppTypedHandler.$$$reportNull$$$0(3);
        }
        if (!FileTypeRegistry.getInstance().isFileOfType(file.getVirtualFile(), (FileType)EppFileType.getInstance())) {
            TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
            if (result == null) {
                EppTypedHandler.$$$reportNull$$$0(4);
            }
            return result;
        }
        CaretModel caretModel = editor.getCaretModel();
        int offset = caretModel.getOffset();
        Document document = editor.getDocument();
        CharSequence charSequence = document.getCharsSequence();
        if (c == '%' && EppSmartKeysUtil.charIs(charSequence, offset - 1, '<') && EppSmartKeysUtil.getTokenInfo((Editor)editor, (int)(offset - 1)).tokenType == EppElementTypes.EPP_TEMPLATE_BLOCK) {
            EppSmartKeysUtil.TokenInfo nextEppTokenInfo = EppSmartKeysUtil.getNextEppTokenInfo(editor, offset);
            if (nextEppTokenInfo.tokenType == EppElementTypes.EPP_EXPRESSION_CLOSER) {
                TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
                if (result == null) {
                    EppTypedHandler.$$$reportNull$$$0(5);
                }
                return result;
            }
            document.insertString(offset, (CharSequence)"%  %>");
            caretModel.moveToOffset(offset + 2);
            TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
            if (result == null) {
                EppTypedHandler.$$$reportNull$$$0(6);
            }
            return result;
        }
        if (c == '|' && EppSmartKeysUtil.charIs(charSequence, offset - 1, ' ')) {
            EppSmartKeysUtil.TokenInfo openerInfo = EppSmartKeysUtil.getTokenInfo(editor, offset - 2);
            if (openerInfo.tokenType == EppElementTypes.EPP_EXPRESSION_OPENER && (openerInfo.startOffset == 0 || EppSmartKeysUtil.getPrevEppTokenInfo(editor, openerInfo.startOffset - 1).isEmpty())) {
                EppSmartKeysUtil.TokenInfo nextEppTokenInfo = EppSmartKeysUtil.getNextEppTokenInfo(editor, offset);
                if (nextEppTokenInfo.tokenType == EppElementTypes.EPP_EXPRESSION_CLOSER) {
                    if (EppSmartKeysUtil.textIs(charSequence, nextEppTokenInfo.startOffset - 2, "| ")) {
                        TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
                        if (result == null) {
                            EppTypedHandler.$$$reportNull$$$0(7);
                        }
                        return result;
                    }
                    document.insertString(nextEppTokenInfo.startOffset, (CharSequence)"| ");
                    document.insertString(offset, (CharSequence)"| ");
                    caretModel.moveToOffset(offset + 2);
                    TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
                    if (result == null) {
                        EppTypedHandler.$$$reportNull$$$0(8);
                    }
                    return result;
                }
            }
        }
        TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
        if (result == null) {
            EppTypedHandler.$$$reportNull$$$0(9);
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 7, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/puppet/ruby/epp/ide/editor/EppTypedHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/puppet/ruby/epp/ide/editor/EppTypedHandler";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "beforeCharTyped";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "beforeCharTyped";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 7, 8, 9 -> new IllegalStateException(string);
        };
    }
}

