/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.puppet.ruby.adapters;

import com.intellij.execution.filters.Filter;
import com.intellij.lang.puppet.PuppetBundle;
import com.intellij.lang.puppet.adapters.PuppetAbstractLibrarianAdapter;
import com.intellij.lang.puppet.project.PuppetEntity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtilRt;
import java.util.Collection;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.gem.GemsRunner;
import org.jetbrains.plugins.ruby.gem.MissingGemNotificationWithFix;
import org.jetbrains.plugins.ruby.rails.run.filters.RStackTraceFilter;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.run.MergingCommandLineArgumentsProvider;
import org.jetbrains.plugins.ruby.ruby.run.RubyCommandLineArgumentsProvider;
import org.jetbrains.plugins.ruby.ruby.run.RunContentDescriptorFactory;

public final class PuppetLibrarianGemAdapter
extends PuppetAbstractLibrarianAdapter {
    private static final Logger LOG = Logger.getInstance(PuppetLibrarianGemAdapter.class);

    @NotNull
    protected Logger getLogger() {
        Logger logger = LOG;
        if (logger == null) {
            PuppetLibrarianGemAdapter.$$$reportNull$$$0(0);
        }
        return logger;
    }

    protected void installDependencies(@NotNull PuppetEntity puppetEntity, @NotNull ProgressIndicator indicator) {
        if (puppetEntity == null) {
            PuppetLibrarianGemAdapter.$$$reportNull$$$0(1);
        }
        if (indicator == null) {
            PuppetLibrarianGemAdapter.$$$reportNull$$$0(2);
        }
        ApplicationManager.getApplication().runReadAction(() -> {
            Project project = puppetEntity.getProject();
            if (project.isDisposed()) {
                return;
            }
            VirtualFile entityRoot = puppetEntity.getRoot();
            if (!entityRoot.isValid()) {
                return;
            }
            Module module = ModuleUtilCore.findModuleForFile((VirtualFile)entityRoot, (Project)project);
            if (module == null) {
                return;
            }
            Sdk rubySdk = RModuleUtil.getInstance().findRubySdkForModule(module);
            MissingGemNotificationWithFix.checkGemExecPresenceOrInstall((Module)module, (Sdk)rubySdk, (String)"librarian-puppet", success -> {
                if (!success) {
                    return;
                }
                boolean shouldExcludeLibrarianDir = PuppetLibrarianGemAdapter.getLibrarianInternalDir((VirtualFile)entityRoot) == null;
                HashMap env = new HashMap();
                this.configureEnvironment(env);
                MergingCommandLineArgumentsProvider provider = new MergingCommandLineArgumentsProvider(ArrayUtilRt.toStringArray((Collection)this.createLibrarianArguments(puppetEntity)), null, null, env);
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (project.isDisposed() || !entityRoot.isValid() || rubySdk == null) {
                        return;
                    }
                    GemsRunner.runGemScriptInConsoleAndRefreshModule((Module)module, (Sdk)rubySdk, (String)PuppetBundle.message((String)"puppet.installing.dependencies", (Object[])new Object[]{puppetEntity.getDescriptiveName(), puppetEntity.getName()}), null, (String)"librarian-puppet", null, (String)"librarian-puppet", (String)entityRoot.getCanonicalPath(), (RubyCommandLineArgumentsProvider)provider, (RunContentDescriptorFactory)new RunContentDescriptorFactory.PinTabsFactory(), (Filter[])new Filter[]{new RStackTraceFilter(module, entityRoot.getCanonicalPath())}, () -> ApplicationManager.getApplication().runReadAction(() -> this.doPostInstallationWork(puppetEntity, () -> {
                        VirtualFile librarianInternalDir;
                        if (shouldExcludeLibrarianDir && (librarianInternalDir = PuppetLibrarianGemAdapter.getLibrarianInternalDir((VirtualFile)entityRoot)) != null) {
                            PuppetLibrarianGemAdapter.excludeVirtualFile((Project)project, (VirtualFile)librarianInternalDir);
                        }
                    })), (boolean)false, null);
                });
            });
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/puppet/ruby/adapters/PuppetLibrarianGemAdapter";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "puppetEntity";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogger";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/puppet/ruby/adapters/PuppetLibrarianGemAdapter";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "installDependencies";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }
}

