/*
 * Decompiled with CFR 0.152.
 */
package ru.adelf.idea.dotenv.ui;

import com.intellij.openapi.options.Configurable;
import com.intellij.ui.components.JBLabel;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.Nullable;
import ru.adelf.idea.dotenv.DotEnvBundle;
import ru.adelf.idea.dotenv.DotEnvSettings;

public class DotEnvSettingsConfigurable
implements Configurable {
    private JCheckBox completionEnabledCheckbox;
    private JCheckBox storeValuesCheckbox;
    private JCheckBox hideValuesCheckbox;

    @Nls
    public String getDisplayName() {
        return "DotEnv";
    }

    @Nullable
    public JComponent createComponent() {
        DotEnvSettings settings = DotEnvSettingsConfigurable.getSettings();
        Border standardBorder = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        this.completionEnabledCheckbox = new JCheckBox(DotEnvBundle.message("enable.environment.variables.completions", new Object[0]), settings.completionEnabled);
        this.completionEnabledCheckbox.setBorder(standardBorder);
        this.storeValuesCheckbox = new JCheckBox(DotEnvBundle.message("store.and.complete.values", new Object[0]), settings.storeValues);
        this.storeValuesCheckbox.setBorder(standardBorder);
        this.storeValuesCheckbox.setToolTipText(DotEnvBundle.message("storing.values.in.the.indices.can.be.turned.off.due.to.security.reasons", new Object[0]));
        JBLabel storeValuesInvalidateCachesLabel = new JBLabel(DotEnvBundle.message("label.run.file.invalidate.caches.to.update.indices", new Object[0]));
        storeValuesInvalidateCachesLabel.setBorder(standardBorder);
        storeValuesInvalidateCachesLabel.setVisible(false);
        this.storeValuesCheckbox.addChangeListener(arg_0 -> this.lambda$createComponent$0((JLabel)storeValuesInvalidateCachesLabel, arg_0));
        this.hideValuesCheckbox = new JCheckBox(DotEnvBundle.message("hide.values.in.env.files", new Object[0]), settings.storeValues);
        this.hideValuesCheckbox.setBorder(standardBorder);
        JBLabel hideValuesLabel = new JBLabel(DotEnvBundle.message("label.check.this.if.you.want.values.to.be.hidden.by.default.br.main.menu.code.folding.actions.can.be.used.to.control.it", new Object[0]));
        hideValuesLabel.setBorder(standardBorder);
        JPanel rootPanel = new JPanel();
        rootPanel.setLayout(new BoxLayout(rootPanel, 3));
        rootPanel.add(this.completionEnabledCheckbox);
        rootPanel.add(this.storeValuesCheckbox);
        rootPanel.add((Component)storeValuesInvalidateCachesLabel);
        rootPanel.add(this.hideValuesCheckbox);
        rootPanel.add((Component)hideValuesLabel);
        return rootPanel;
    }

    public boolean isModified() {
        return !this.completionEnabledCheckbox.isSelected() == DotEnvSettingsConfigurable.getSettings().completionEnabled || !this.storeValuesCheckbox.isSelected() == DotEnvSettingsConfigurable.getSettings().storeValues || !this.hideValuesCheckbox.isSelected() == DotEnvSettingsConfigurable.getSettings().hideValuesInTheFile;
    }

    public void apply() {
        DotEnvSettings settings = DotEnvSettingsConfigurable.getSettings();
        settings.completionEnabled = this.completionEnabledCheckbox.isSelected();
        settings.storeValues = this.storeValuesCheckbox.isSelected();
        settings.hideValuesInTheFile = this.hideValuesCheckbox.isSelected();
    }

    public void reset() {
        this.completionEnabledCheckbox.setSelected(DotEnvSettingsConfigurable.getSettings().completionEnabled);
        this.storeValuesCheckbox.setSelected(DotEnvSettingsConfigurable.getSettings().storeValues);
        this.hideValuesCheckbox.setSelected(DotEnvSettingsConfigurable.getSettings().hideValuesInTheFile);
    }

    private static DotEnvSettings getSettings() {
        return DotEnvSettings.getInstance();
    }

    private /* synthetic */ void lambda$createComponent$0(JLabel storeValuesInvalidateCachesLabel, ChangeEvent e) {
        storeValuesInvalidateCachesLabel.setVisible(this.storeValuesCheckbox.isSelected() != DotEnvSettingsConfigurable.getSettings().storeValues);
    }
}

