/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.coverage.run;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.OptionalChooserComponent;
import com.intellij.ui.ToolbarDecorator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.coverage.run.RCovPattern;
import org.jetbrains.plugins.ruby.coverage.run.RCovPatternDialog;

public class PatternsListComponent {
    private final OptionalChooserComponent<RCovPattern> myOptionalChooserComponent;
    private final JPanel myContentPane;

    public PatternsListComponent(final @NotNull Project project) {
        if (project == null) {
            PatternsListComponent.$$$reportNull$$$0(0);
        }
        this.myOptionalChooserComponent = new OptionalChooserComponent<RCovPattern>(Collections.emptyList()){

            public JCheckBox createCheckBox(RCovPattern pattern, boolean checked) {
                @NlsSafe String text = (pattern.isIncluded() ? "+" : "-") + ": " + pattern.getRegexps();
                return new JCheckBox(text, checked);
            }
        };
        this.myContentPane = ToolbarDecorator.createDecorator((JList)this.myOptionalChooserComponent.getList()).setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                RCovPattern pattern = RCovPatternDialog.showAddPatternDialog(project);
                if (pattern != null) {
                    this.insertInRightPlace(pattern);
                    PatternsListComponent.this.myOptionalChooserComponent.refresh();
                }
            }

            private void insertInRightPlace(RCovPattern pattern) {
                Pair covPatternAndEnabledPair = new Pair((Object)pattern, (Object)true);
                boolean isIncluded = pattern.isIncluded();
                ArrayList patterns = PatternsListComponent.this.myOptionalChooserComponent.getCurrentModel();
                if (isIncluded) {
                    patterns.add(covPatternAndEnabledPair);
                } else {
                    int size = patterns.size();
                    boolean wasAdded = false;
                    for (int i = 0; i < size; ++i) {
                        if (!((RCovPattern)((Pair)patterns.get((int)i)).first).isIncluded()) continue;
                        patterns.add(i, covPatternAndEnabledPair);
                        wasAdded = true;
                    }
                    if (!wasAdded) {
                        patterns.add(covPatternAndEnabledPair);
                    }
                }
            }
        }).setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                PatternsListComponent.this.myOptionalChooserComponent.removeSelected();
            }
        }).setEditAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                RCovPattern covPattern;
                int selectedIndex = PatternsListComponent.this.myOptionalChooserComponent.getSelectedIndex();
                if (selectedIndex != -1 && RCovPatternDialog.showEditPatternDialog(project, covPattern = (RCovPattern)((Pair)PatternsListComponent.this.myOptionalChooserComponent.getCurrentModel().get((int)selectedIndex)).first)) {
                    PatternsListComponent.this.myOptionalChooserComponent.refresh();
                }
            }
        }).disableUpDownActions().createPanel();
        this.reset(Collections.emptyList());
    }

    public List<Pair<RCovPattern, Boolean>> getAllPatterns() {
        return this.myOptionalChooserComponent.getCurrentModel();
    }

    public void reset(List<Pair<RCovPattern, Boolean>> allPatterns) {
        this.myOptionalChooserComponent.setInitialList(allPatterns);
        this.myOptionalChooserComponent.reset();
    }

    public JPanel getContentPane() {
        return this.myContentPane;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/ruby/coverage/run/PatternsListComponent", "<init>"));
    }
}

