/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.coverage;

import com.intellij.openapi.diagnostic.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.coverage.RCovCoverageType;
import org.jetbrains.plugins.ruby.coverage.RCovRawFileData;
import org.jetbrains.plugins.ruby.coverage.RubyCoverageDeserializationProvider;
import org.jetbrains.plugins.ruby.coverage.RubyCoverageUtil;

public final class SimpleCovYAMLDeserializationProvider
implements RubyCoverageDeserializationProvider {
    private static final Logger LOG = Logger.getInstance(SimpleCovYAMLDeserializationProvider.class);

    @Override
    public String getFormatName() {
        return "simplecov.yaml";
    }

    @Override
    public String getReportGeneratorGemName() {
        return "simplecov";
    }

    @Override
    public boolean acceptsFormat(@NotNull String dataFilePath, @NotNull String firstLine) {
        if (dataFilePath == null) {
            SimpleCovYAMLDeserializationProvider.$$$reportNull$$$0(0);
        }
        if (firstLine == null) {
            SimpleCovYAMLDeserializationProvider.$$$reportNull$$$0(1);
        }
        return firstLine.startsWith("---");
    }

    @Override
    public List<RCovRawFileData> deserialize(@NotNull String serializedDataPath) {
        Map yamlContent;
        if (serializedDataPath == null) {
            SimpleCovYAMLDeserializationProvider.$$$reportNull$$$0(2);
        }
        if ((yamlContent = RubyCoverageUtil.loadYaml(serializedDataPath, LOG)) == null) {
            return Collections.emptyList();
        }
        List<RCovRawFileData> coverage = SimpleCovYAMLDeserializationProvider.collectCoverage(yamlContent);
        if (coverage == null) {
            LOG.error("Unexpected yaml simplecov format for file: " + serializedDataPath);
            return Collections.emptyList();
        }
        return coverage;
    }

    @Nullable
    private static List<RCovRawFileData> collectCoverage(@NotNull Map yamlContent) {
        if (yamlContent == null) {
            SimpleCovYAMLDeserializationProvider.$$$reportNull$$$0(3);
        }
        ArrayList<RCovRawFileData> coverage = new ArrayList<RCovRawFileData>();
        Collection entries = yamlContent.values();
        for (Object entry : entries) {
            if (!(entry instanceof Map)) {
                return null;
            }
            Set coverageData = ((Map)entry).entrySet();
            boolean resultFound = false;
            for (Map.Entry propertyNameAndValue : coverageData) {
                Object propertyName = propertyNameAndValue.getKey();
                if (propertyName == null || !":original_result".equals(propertyName.toString())) continue;
                resultFound = true;
                Object filePath2HitsMap = propertyNameAndValue.getValue();
                if (!(filePath2HitsMap instanceof Map)) break;
                Set filePathAndHitsPairs = ((Map)filePath2HitsMap).entrySet();
                for (Map.Entry filePathAndHit : filePathAndHitsPairs) {
                    String filePath = filePathAndHit.getKey().toString();
                    List hitsData = (List)filePathAndHit.getValue();
                    coverage.add(SimpleCovYAMLDeserializationProvider.processHitsData(filePath, hitsData));
                }
            }
            if (resultFound) continue;
            return null;
        }
        return coverage;
    }

    @NotNull
    private static RCovRawFileData processHitsData(String filePath, List hitsData) {
        ArrayList<RCovCoverageType> coverageList = new ArrayList<RCovCoverageType>();
        int linesNumber = hitsData.size();
        int[] hits = new int[linesNumber];
        boolean[] srcLinesMap = new boolean[linesNumber];
        for (int i = 0; i < linesNumber; ++i) {
            Number hit = (Number)hitsData.get(i);
            boolean noHitsInfoAvailable = hit == null;
            hits[i] = noHitsInfoAvailable ? 0 : hit.intValue();
            srcLinesMap[i] = !noHitsInfoAvailable;
            coverageList.add(noHitsInfoAvailable ? RCovCoverageType.NOT_COVERED : RCovCoverageType.COVERED);
        }
        return new RCovRawFileData(filePath, coverageList, hits, srcLinesMap, Collections.emptyMap());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataFilePath";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "firstLine";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serializedDataPath";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "yamlContent";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/coverage/SimpleCovYAMLDeserializationProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "acceptsFormat";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "deserialize";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "collectCoverage";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

