/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.coverage;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.Reader;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.coverage.RCovCoverageType;
import org.jetbrains.plugins.ruby.coverage.RCovRawFileData;
import org.jetbrains.plugins.ruby.coverage.RubyCoverageDeserializationProvider;

public final class SimpleCovJSONDeserializationProvider
implements RubyCoverageDeserializationProvider {
    private static final Logger LOG = Logger.getInstance(SimpleCovJSONDeserializationProvider.class);

    @Override
    public String getFormatName() {
        return "simplecov.json";
    }

    @Override
    public String getReportGeneratorGemName() {
        return "simplecov";
    }

    @Override
    public boolean acceptsFormat(@NotNull String dataFilePath, @NotNull String firstLine) {
        if (dataFilePath == null) {
            SimpleCovJSONDeserializationProvider.$$$reportNull$$$0(0);
        }
        if (firstLine == null) {
            SimpleCovJSONDeserializationProvider.$$$reportNull$$$0(1);
        }
        return firstLine.startsWith("{");
    }

    /*
     * Loose catch block
     */
    @Override
    @NotNull
    public List<RCovRawFileData> deserialize(@NotNull String serializedDataPath) {
        ArrayList arrayList;
        BufferedReader reader;
        block23: {
            File file;
            if (serializedDataPath == null) {
                SimpleCovJSONDeserializationProvider.$$$reportNull$$$0(2);
            }
            if (!(file = new File(serializedDataPath)).exists()) {
                LOG.debug("File '" + serializedDataPath + "' doesn't exist!");
                List<RCovRawFileData> list = Collections.emptyList();
                if (list == null) {
                    SimpleCovJSONDeserializationProvider.$$$reportNull$$$0(3);
                }
                return list;
            }
            HashMap<String, RCovRawFileData> coverage = new HashMap<String, RCovRawFileData>();
            reader = Files.newBufferedReader(file.toPath());
            JsonElement content = JsonParser.parseReader((Reader)reader);
            Set entries = ((JsonObject)content).entrySet();
            for (Map.Entry testFrameworkAndCoverage : entries) {
                JsonElement coverageData = (JsonElement)testFrameworkAndCoverage.getValue();
                JsonElement fileCovData = ((JsonObject)coverageData).get("coverage");
                if (fileCovData == null) {
                    fileCovData = ((JsonObject)coverageData).get(":original_result");
                }
                if (fileCovData != null) {
                    Set fileCovDataEntries = ((JsonObject)fileCovData).entrySet();
                    for (Map.Entry filePathAndHits : fileCovDataEntries) {
                        List<RCovRawFileData.BranchElement> branches;
                        JsonArray hitsData;
                        String filePath = (String)filePathAndHits.getKey();
                        JsonElement data = (JsonElement)filePathAndHits.getValue();
                        if (data.isJsonArray()) {
                            hitsData = data.getAsJsonArray();
                            branches = Collections.emptyList();
                        } else {
                            JsonObject object = data.getAsJsonObject();
                            hitsData = object.get("lines").getAsJsonArray();
                            JsonElement member = object.get("branches");
                            branches = member != null ? SimpleCovJSONDeserializationProvider.parseBranchesData(member.getAsJsonObject().entrySet()) : Collections.emptyList();
                        }
                        coverage.merge(filePath, SimpleCovJSONDeserializationProvider.processHitsData(filePath, hitsData, branches), (old, newOne) -> SimpleCovJSONDeserializationProvider.mergeData(filePath, old, newOne));
                    }
                    continue;
                }
                Set covDataItems = ((JsonObject)coverageData).entrySet();
                StringBuilder buff = new StringBuilder();
                if (covDataItems.isEmpty()) {
                    buff.append("<none>");
                } else {
                    for (Map.Entry item : covDataItems) {
                        if (!buff.isEmpty()) {
                            buff.append(", ");
                        }
                        buff.append((String)item.getKey());
                    }
                }
                LOG.error("Unknown simplecov format for file: " + serializedDataPath + ", actual data keys = " + String.valueOf(buff));
            }
            arrayList = new ArrayList(coverage.values());
            if (reader == null) break block23;
            ((Reader)reader).close();
        }
        ArrayList arrayList2 = arrayList;
        if (arrayList2 == null) {
            SimpleCovJSONDeserializationProvider.$$$reportNull$$$0(4);
        }
        return arrayList2;
        {
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    LOG.error((Throwable)e);
                    List<RCovRawFileData> list = Collections.emptyList();
                    if (list == null) {
                        SimpleCovJSONDeserializationProvider.$$$reportNull$$$0(5);
                    }
                    return list;
                }
            }
        }
    }

    @NotNull
    private static RCovRawFileData processHitsData(@NotNull String filePath, @NotNull JsonArray hitsData, @NotNull List<RCovRawFileData.BranchElement> branches) {
        if (filePath == null) {
            SimpleCovJSONDeserializationProvider.$$$reportNull$$$0(6);
        }
        if (hitsData == null) {
            SimpleCovJSONDeserializationProvider.$$$reportNull$$$0(7);
        }
        if (branches == null) {
            SimpleCovJSONDeserializationProvider.$$$reportNull$$$0(8);
        }
        VirtualFile file = VirtualFileManager.getInstance().findFileByUrl(VfsUtilCore.pathToUrl((String)filePath));
        ArrayList<RCovCoverageType> coverageList = new ArrayList<RCovCoverageType>();
        int linesNumber = hitsData.size();
        int[] hits = new int[linesNumber];
        boolean[] srcLinesMap = new boolean[linesNumber];
        boolean noCov = false;
        Document document = null;
        for (int i = 0; i < linesNumber; ++i) {
            JsonElement hit = hitsData.get(i);
            boolean noHitsInfoAvailable = hit.isJsonNull();
            hits[i] = noHitsInfoAvailable ? 0 : hit.getAsInt();
            boolean bl = srcLinesMap[i] = !noHitsInfoAvailable;
            if (noHitsInfoAvailable) {
                String string;
                if (document == null && file != null) {
                    document = (Document)ReadAction.compute(() -> FileDocumentManager.getInstance().getDocument(file));
                }
                if (document != null && i < document.getLineCount() && (string = document.getCharsSequence().subSequence(document.getLineStartOffset(i), document.getLineEndOffset(i)).toString()).trim().endsWith(":nocov:")) {
                    boolean bl2 = noCov = !noCov;
                }
            }
            coverageList.add(noCov ? RCovCoverageType.INFERRED : (hits[i] == 0 ? RCovCoverageType.NOT_COVERED : RCovCoverageType.COVERED));
        }
        HashMap<Integer, RCovRawFileData.BranchElement> lineNumbersToBranches = new HashMap<Integer, RCovRawFileData.BranchElement>();
        for (RCovRawFileData.BranchElement branch : branches) {
            int startLine = branch.getStartLine();
            int endLine = branch.getEndLine();
            for (int i = startLine; i <= endLine; ++i) {
                RCovRawFileData.BranchElement element = (RCovRawFileData.BranchElement)lineNumbersToBranches.get(i);
                if (element != null && endLine - startLine >= element.getEndLine() - element.getStartLine()) continue;
                lineNumbersToBranches.put(i, branch);
            }
        }
        return new RCovRawFileData(filePath, coverageList, hits, srcLinesMap, lineNumbersToBranches);
    }

    private static List<RCovRawFileData.BranchElement> parseBranchesData(Set<Map.Entry<String, JsonElement>> entries) {
        ArrayList<RCovRawFileData.BranchElement> elements = new ArrayList<RCovRawFileData.BranchElement>();
        for (Map.Entry<String, JsonElement> entry : entries) {
            String key = entry.getKey();
            String[] s = key.substring(1, key.length() - 1).split(",");
            LOG.assertTrue(s.length == 6);
            JsonElement value = entry.getValue();
            boolean isNested = value instanceof JsonObject;
            List<RCovRawFileData.BranchElement> children = isNested ? SimpleCovJSONDeserializationProvider.parseBranchesData(value.getAsJsonObject().entrySet()) : Collections.emptyList();
            int hitCount = !isNested ? value.getAsInt() : children.stream().mapToInt(it -> it.getHitCount()).sum();
            elements.add(new RCovRawFileData.BranchElement(s[0], Integer.parseInt(s[1].trim()), Integer.parseInt(s[2].trim()), Integer.parseInt(s[3].trim()), Integer.parseInt(s[4].trim()), Integer.parseInt(s[5].trim()), hitCount, children));
        }
        return elements;
    }

    @NotNull
    private static RCovRawFileData mergeData(@NotNull String filePath, @NotNull RCovRawFileData oldCoverage, @NotNull RCovRawFileData newCoverage) {
        int i;
        if (filePath == null) {
            SimpleCovJSONDeserializationProvider.$$$reportNull$$$0(9);
        }
        if (oldCoverage == null) {
            SimpleCovJSONDeserializationProvider.$$$reportNull$$$0(10);
        }
        if (newCoverage == null) {
            SimpleCovJSONDeserializationProvider.$$$reportNull$$$0(11);
        }
        ArrayList<RCovCoverageType> mergedCoverage = new ArrayList<RCovCoverageType>();
        int oldSize = oldCoverage.getLinesNumber();
        int newSize = newCoverage.getLinesNumber();
        int size = Math.min(oldSize, newSize);
        boolean[] srcLinesMap = new boolean[Math.max(oldSize, newSize)];
        int[] hitsMap = new int[Math.max(oldSize, newSize)];
        for (i = 0; i < size; ++i) {
            boolean covered;
            srcLinesMap[i] = oldCoverage.isSourceCode(i) && newCoverage.isSourceCode(i);
            RCovCoverageType oldLineCov = oldCoverage.getCoverage(i);
            RCovCoverageType newLineCov = newCoverage.getCoverage(i);
            boolean bl = covered = (oldLineCov == RCovCoverageType.COVERED || newLineCov == RCovCoverageType.COVERED) && srcLinesMap[i];
            mergedCoverage.add(i, covered ? RCovCoverageType.COVERED : (oldLineCov == RCovCoverageType.INFERRED || newLineCov == RCovCoverageType.INFERRED ? RCovCoverageType.INFERRED : RCovCoverageType.NOT_COVERED));
            hitsMap[i] = oldCoverage.getHits(i) + newCoverage.getHits(i);
        }
        for (i = size; i < Math.max(oldSize, newSize); ++i) {
            RCovRawFileData cov = i < oldSize ? oldCoverage : newCoverage;
            srcLinesMap[i] = cov.isSourceCode(i);
            mergedCoverage.add(i, cov.getCoverage(i));
            hitsMap[i] = cov.getHits(i);
        }
        HashMap<Integer, RCovRawFileData.BranchElement> branches = new HashMap<Integer, RCovRawFileData.BranchElement>(oldCoverage.getBranches());
        branches.putAll(newCoverage.getBranches());
        return new RCovRawFileData(filePath, mergedCoverage, hitsMap, srcLinesMap, branches);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataFilePath";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "firstLine";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serializedDataPath";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/coverage/SimpleCovJSONDeserializationProvider";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hitsData";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branches";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldCoverage";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newCoverage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/coverage/SimpleCovJSONDeserializationProvider";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "deserialize";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "acceptsFormat";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "deserialize";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processHitsData";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "mergeData";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5 -> new IllegalStateException(string);
        };
    }
}

